/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.openide.loaders.RuntimeCatalog;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderAdapter;

class XMLDataObjectImpl {
    XMLDataObjectImpl() {
    }

    static DocumentBuilder makeBuilder(boolean validate) throws IOException, SAXException {
        DocumentBuilder builder;
        DocumentBuilderFactory factory;
        try {
            factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(validate);
            factory.setNamespaceAware(false);
        }
        catch (FactoryConfigurationError err) {
            XMLDataObjectImpl.notifyFactoryErr(err, "javax.xml.parsers.DocumentBuilderFactory");
            throw err;
        }
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            SAXException sex = new SAXException("Configuration exception.");
            sex.initCause(ex);
            Exceptions.attachLocalizedMessage((Throwable)sex, (String)"Can not create a DOM builder!\nCheck javax.xml.parsers.DocumentBuilderFactory property and the builder library presence on classpath.");
            throw sex;
        }
        return builder;
    }

    @Deprecated
    static Parser makeParser(boolean validate) {
        try {
            return new XMLReaderAdapter(XMLUtil.createXMLReader((boolean)validate));
        }
        catch (SAXException ex) {
            XMLDataObjectImpl.notifyNewSAXParserEx(ex);
            return null;
        }
    }

    static XMLReader makeXMLReader(boolean validating, boolean namespaces) {
        try {
            return XMLUtil.createXMLReader((boolean)validating, (boolean)namespaces);
        }
        catch (SAXException ex) {
            XMLDataObjectImpl.notifyNewSAXParserEx(ex);
            return null;
        }
    }

    private static void notifyNewSAXParserEx(Exception ex) {
        Exceptions.attachLocalizedMessage((Throwable)ex, (String)"Can not create a SAX parser!\nCheck javax.xml.parsers.SAXParserFactory property features and the parser library presence on classpath.");
        Exceptions.printStackTrace((Throwable)ex);
    }

    private static void notifyFactoryErr(Error err, String property) {
        Exceptions.attachLocalizedMessage((Throwable)err, (String)("Can not create a factory!\nCheck " + property + "  property and the factory library presence on classpath."));
        Exceptions.printStackTrace((Throwable)err);
    }

    static synchronized void registerCatalogEntry(String publicId, String uri) {
        for (Object o : Lookup.getDefault().lookupAll(EntityCatalog.class)) {
            if (!(o instanceof RuntimeCatalog)) continue;
            ((RuntimeCatalog)((Object)o)).registerCatalogEntry(publicId, uri);
            return;
        }
        assert (false);
    }
}

