/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.nb.javascript.serialize;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.mozilla.nb.javascript.Scriptable;
import org.mozilla.nb.javascript.ScriptableObject;
import org.mozilla.nb.javascript.UniqueTag;

public class ScriptableOutputStream
extends ObjectOutputStream {
    private Scriptable scope;
    private Map<Object, String> table;

    public ScriptableOutputStream(OutputStream outputStream, Scriptable scriptable) throws IOException {
        super(outputStream);
        this.scope = scriptable;
        this.table = new HashMap<Object, String>();
        this.table.put(scriptable, "");
        this.enableReplaceObject(true);
        this.excludeStandardObjectNames();
    }

    public void excludeAllIds(Object[] objectArray) {
        for (Object object : objectArray) {
            if (!(object instanceof String) || !(this.scope.get((String)object, this.scope) instanceof Scriptable)) continue;
            this.addExcludedName((String)object);
        }
    }

    public void addOptionalExcludedName(String string) {
        Object object = ScriptableOutputStream.lookupQualifiedName(this.scope, string);
        if (object != null && object != UniqueTag.NOT_FOUND) {
            if (!(object instanceof Scriptable)) {
                throw new IllegalArgumentException("Object for excluded name " + string + " is not a Scriptable, it is " + object.getClass().getName());
            }
            this.table.put(object, string);
        }
    }

    public void addExcludedName(String string) {
        Object object = ScriptableOutputStream.lookupQualifiedName(this.scope, string);
        if (!(object instanceof Scriptable)) {
            throw new IllegalArgumentException("Object for excluded name " + string + " not found.");
        }
        this.table.put(object, string);
    }

    public boolean hasExcludedName(String string) {
        return this.table.get(string) != null;
    }

    public void removeExcludedName(String string) {
        this.table.remove(string);
    }

    public void excludeStandardObjectNames() {
        String[] stringArray = new String[]{"Object", "Object.prototype", "Function", "Function.prototype", "String", "String.prototype", "Math", "Array", "Array.prototype", "Error", "Error.prototype", "Number", "Number.prototype", "Date", "Date.prototype", "RegExp", "RegExp.prototype", "Script", "Script.prototype", "Continuation", "Continuation.prototype"};
        for (int i = 0; i < stringArray.length; ++i) {
            this.addExcludedName(stringArray[i]);
        }
        String[] stringArray2 = new String[]{"XML", "XML.prototype", "XMLList", "XMLList.prototype"};
        for (int i = 0; i < stringArray2.length; ++i) {
            this.addOptionalExcludedName(stringArray2[i]);
        }
    }

    static Object lookupQualifiedName(Scriptable scriptable, String string) {
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        Object object = scriptable;
        while (stringTokenizer.hasMoreTokens() && (object = ScriptableObject.getProperty((Scriptable)object, string2 = stringTokenizer.nextToken())) != null && object instanceof Scriptable) {
        }
        return object;
    }

    @Override
    protected Object replaceObject(Object object) throws IOException {
        String string = this.table.get(object);
        if (string == null) {
            return object;
        }
        return new PendingLookup(string);
    }

    static class PendingLookup
    implements Serializable {
        static final long serialVersionUID = -2692990309789917727L;
        private String name;

        PendingLookup(String string) {
            this.name = string;
        }

        String getName() {
            return this.name;
        }
    }
}

