/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.classfile;

import java.io.IOException;
import java.util.ArrayList;
import org.netbeans.lib.profiler.classfile.ClassFileCache;
import org.netbeans.lib.profiler.classfile.ClassFileParser;
import org.netbeans.lib.profiler.classfile.ClassInfo;

public class DynamicClassInfo
extends ClassInfo {
    private ArrayList subclasses;
    private DynamicClassInfo superClass;
    private String classFileLocation;
    private int[] baseCPoolCount;
    private char[] instrMethodIds;
    private DynamicClassInfo[] interfacesDCI;
    private char[] methodScanStatus;
    private byte[][] modifiedAndSavedMethodInfos;
    private boolean allMethodsMarkers = false;
    private boolean allMethodsRoots = false;
    private boolean hasUninstrumentedMarkerMethods;
    private boolean hasUninstrumentedRootMethods;
    private boolean isLoaded;
    private boolean servletDoMethodScanned;
    private int currentCPoolCount;
    private int nInstrumentedMethods;

    public DynamicClassInfo(String className, int loaderId, String classFileLocation) throws IOException, ClassFormatError {
        super(className, loaderId);
        this.classFileLocation = classFileLocation;
        byte[] classFileBytes = this.getClassFileBytes();
        try {
            new ClassFileParser().parseClassFile(classFileBytes, this);
            if (!className.equals(this.name)) {
                throw new ClassFormatError("Mismatch between name in .class file and location for " + className + "\nYour class path setting may be incorrect.");
            }
        }
        catch (ClassFileParser.ClassFileReadException ex) {
            throw new ClassFormatError(ex.getMessage());
        }
        this.methodScanStatus = new char[this.methodNames.length];
        this.instrMethodIds = new char[this.methodNames.length];
        this.currentCPoolCount = this.origCPoolCount;
        this.baseCPoolCount = new int[11];
        for (int i = 0; i < 11; ++i) {
            this.baseCPoolCount[i] = -1;
        }
    }

    public void setAllMethodsMarkers() {
        this.allMethodsMarkers = true;
        this.hasUninstrumentedMarkerMethods = true;
    }

    public boolean getAllMethodsMarkers() {
        return this.allMethodsMarkers;
    }

    public void setAllMethodsRoots() {
        this.allMethodsRoots = true;
        this.hasUninstrumentedRootMethods = true;
    }

    public boolean getAllMethodsRoots() {
        return this.allMethodsRoots;
    }

    public void setBaseCPoolCount(int injType, int v) {
        this.baseCPoolCount[injType] = v;
    }

    public int getBaseCPoolCount(int injType) {
        return this.baseCPoolCount[injType];
    }

    public int getBaseCPoolCountLen() {
        return this.baseCPoolCount.length;
    }

    @Override
    public byte[] getClassFileBytes() throws IOException {
        return ClassFileCache.getDefault().getClassFile(this.name, this.classFileLocation);
    }

    public String getClassFileLocation() {
        return this.classFileLocation;
    }

    public void setCurrentCPoolCount(int v) {
        this.currentCPoolCount = v;
    }

    public int getCurrentCPoolCount() {
        return this.currentCPoolCount;
    }

    @Override
    public int getExceptionTableStartOffsetInMethodInfo(int idx) {
        if (this.modifiedAndSavedMethodInfos != null && this.modifiedAndSavedMethodInfos[idx] != null) {
            int bcLen = this.getBCLenForModifiedAndSavedMethodInfo(idx);
            return this.methodBytecodesOffsets[idx] + bcLen;
        }
        return super.getExceptionTableStartOffsetInMethodInfo(idx);
    }

    public void setHasUninstrumentedMarkerMethods(boolean v) {
        this.hasUninstrumentedMarkerMethods = v;
    }

    public void setHasUninstrumentedRootMethods(boolean v) {
        this.hasUninstrumentedRootMethods = v;
    }

    public void setInstrMethodId(int i, int id) {
        this.instrMethodIds[i] = (char)id;
    }

    public char getInstrMethodId(int i) {
        return this.instrMethodIds[i];
    }

    public void setLoaded(boolean loaded) {
        this.isLoaded = loaded;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    @Override
    public byte[] getMethodBytecode(int idx) {
        if (this.modifiedAndSavedMethodInfos != null && this.modifiedAndSavedMethodInfos[idx] != null) {
            byte[] methodInfo = this.modifiedAndSavedMethodInfos[idx];
            int bcLen = this.getBCLenForModifiedAndSavedMethodInfo(idx);
            byte[] ret = new byte[bcLen];
            System.arraycopy(methodInfo, this.methodBytecodesOffsets[idx], ret, 0, bcLen);
            return ret;
        }
        return super.getMethodBytecode(idx);
    }

    @Override
    public int getMethodBytecodesLength(int idx) {
        if (this.modifiedAndSavedMethodInfos != null && this.modifiedAndSavedMethodInfos[idx] != null) {
            return this.getBCLenForModifiedAndSavedMethodInfo(idx);
        }
        return super.getMethodBytecodesLength(idx);
    }

    @Override
    public byte[] getMethodInfo(int idx) {
        if (this.modifiedAndSavedMethodInfos != null && this.modifiedAndSavedMethodInfos[idx] != null) {
            return this.modifiedAndSavedMethodInfos[idx];
        }
        return super.getMethodInfo(idx);
    }

    @Override
    public int getMethodInfoLength(int idx) {
        if (this.modifiedAndSavedMethodInfos != null && this.modifiedAndSavedMethodInfos[idx] != null) {
            return this.modifiedAndSavedMethodInfos[idx].length;
        }
        return super.getMethodInfoLength(idx);
    }

    public void setMethodInstrumented(int i) {
        int n = i;
        this.methodScanStatus[n] = (char)(this.methodScanStatus[n] | 8);
        ++this.nInstrumentedMethods;
    }

    public boolean isMethodInstrumented(int i) {
        return (this.methodScanStatus[i] & 8) != 0;
    }

    public void setMethodLeaf(int i) {
        int n = i;
        this.methodScanStatus[n] = (char)(this.methodScanStatus[n] | 0x10);
    }

    public boolean isMethodLeaf(int i) {
        return (this.methodScanStatus[i] & 0x10) != 0;
    }

    public void setMethodMarker(int i) {
        int n = i;
        this.methodScanStatus[n] = (char)(this.methodScanStatus[n] | 0x100);
        this.hasUninstrumentedMarkerMethods = true;
    }

    public boolean isMethodMarker(int i) {
        return this.allMethodsMarkers || (this.methodScanStatus[i] & 0x100) != 0;
    }

    public void setMethodReachable(int i) {
        int n = i;
        this.methodScanStatus[n] = (char)(this.methodScanStatus[n] | '\u0001');
    }

    public boolean isMethodReachable(int i) {
        return (this.methodScanStatus[i] & '\u0001') != 0;
    }

    public void setMethodRoot(int i) {
        int n = i;
        this.methodScanStatus[n] = (char)(this.methodScanStatus[n] | 0x40);
        this.hasUninstrumentedRootMethods = true;
    }

    public boolean isMethodRoot(int i) {
        return this.allMethodsRoots || (this.methodScanStatus[i] & 0x40) != 0;
    }

    public void setMethodScanned(int i) {
        int n = i;
        this.methodScanStatus[n] = (char)(this.methodScanStatus[n] | 4);
    }

    public boolean isMethodScanned(int i) {
        return (this.methodScanStatus[i] & 4) != 0;
    }

    public void setMethodSpecial(int i) {
        int n = i;
        this.methodScanStatus[n] = (char)(this.methodScanStatus[n] | 0x80);
    }

    public boolean isMethodSpecial(int i) {
        return (this.methodScanStatus[i] & 0x80) != 0;
    }

    public void setMethodUnscannable(int i) {
        int n = i;
        this.methodScanStatus[n] = (char)(this.methodScanStatus[n] | 2);
    }

    public boolean isMethodUnscannable(int i) {
        return (this.methodScanStatus[i] & 2) != 0;
    }

    public void setMethodVirtual(int i) {
        int n = i;
        this.methodScanStatus[n] = (char)(this.methodScanStatus[n] | 0x20);
    }

    public boolean isMethodVirtual(int i) {
        return (this.methodScanStatus[i] & 0x20) != 0;
    }

    public byte[] getOrigMethodInfo(int idx) {
        return super.getMethodInfo(idx);
    }

    public int getOrigMethodInfoLength(int idx) {
        return super.getMethodInfoLength(idx);
    }

    public void setServletDoMethodScanned() {
        this.servletDoMethodScanned = true;
    }

    public boolean isServletDoMethodScanned() {
        return this.servletDoMethodScanned;
    }

    public boolean isSubclassOf(String superClass) {
        if (this.getName() == superClass) {
            return true;
        }
        DynamicClassInfo sc = this.getSuperClass();
        if (sc == null || sc == this) {
            return false;
        }
        return sc.isSubclassOf(superClass);
    }

    public ArrayList getSubclasses() {
        return this.subclasses;
    }

    public void setSuperClass(DynamicClassInfo sc) {
        this.superClass = sc;
    }

    public DynamicClassInfo getSuperClass() {
        return this.superClass;
    }

    public void setSuperInterface(DynamicClassInfo si, int idx) {
        if (this.interfacesDCI == null) {
            this.interfacesDCI = new DynamicClassInfo[this.interfaces.length];
        }
        this.interfacesDCI[idx] = si;
    }

    public DynamicClassInfo[] getSuperInterfaces() {
        return this.interfacesDCI;
    }

    public void addSubclass(DynamicClassInfo subclass) {
        if (this.subclasses == null) {
            this.subclasses = this.name == "java/lang/Object" ? new ArrayList(500) : new ArrayList();
        }
        this.subclasses.add(subclass);
    }

    public boolean hasInstrumentedMethods() {
        return this.nInstrumentedMethods > 0;
    }

    public boolean hasUninstrumentedMarkerMethods() {
        return this.hasUninstrumentedMarkerMethods;
    }

    public boolean hasUninstrumentedRootMethods() {
        return this.hasUninstrumentedRootMethods;
    }

    public boolean implementsInterface(String intfName) {
        DynamicClassInfo superClass;
        int loaderId = this.getLoaderId();
        String[] intfs = this.getInterfaceNames();
        if (intfs != null) {
            for (int i = 0; i < intfs.length; ++i) {
                if (intfName != intfs[i]) continue;
                return true;
            }
            DynamicClassInfo[] intfsDCI = this.getSuperInterfaces();
            if (intfsDCI != null) {
                for (int i = 0; i < intfsDCI.length; ++i) {
                    DynamicClassInfo intfClazz = intfsDCI[i];
                    if (intfClazz == null || !intfClazz.implementsInterface(intfName)) continue;
                    return true;
                }
            }
        }
        if ((superClass = this.getSuperClass()) == null || superClass.getName() == "java/lang/Object") {
            return false;
        }
        return superClass.implementsInterface(intfName);
    }

    public void saveMethodInfo(int idx, byte[] methodInfo) {
        if (this.modifiedAndSavedMethodInfos == null) {
            this.modifiedAndSavedMethodInfos = new byte[this.methodNames.length][];
        }
        this.modifiedAndSavedMethodInfos[idx] = methodInfo;
    }

    public void unsetMethodInstrumented(int i) {
        int n = i;
        this.methodScanStatus[n] = (char)(this.methodScanStatus[n] & 0xFFFFFFF7);
        --this.nInstrumentedMethods;
    }

    public void unsetMethodSpecial(int i) {
        int n = i;
        this.methodScanStatus[n] = (char)(this.methodScanStatus[n] & 0xFFFFFF7F);
    }

    private int getBCLenForModifiedAndSavedMethodInfo(int idx) {
        byte[] methodInfo = this.modifiedAndSavedMethodInfos[idx];
        int bcLenPos = this.methodBytecodesOffsets[idx] - 4;
        return ((methodInfo[bcLenPos++] & 0xFF) << 24) + ((methodInfo[bcLenPos++] & 0xFF) << 16) + ((methodInfo[bcLenPos++] & 0xFF) << 8) + (methodInfo[bcLenPos++] & 0xFF);
    }
}

