/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.spi.completion;

import java.util.Collections;
import java.util.List;
import org.openide.filesystems.FileObject;

public final class CompletionContext {
    private final int anchor;
    private final FileObject sourceFile;
    private final String sourceClassName;
    private final String className;
    private final boolean staticContext;
    private final List<String> properties;
    private final String prefix;
    private final boolean leaf;
    private final boolean nameOnly;

    public CompletionContext(int anchor, FileObject sourceFile, String sourceClassName, String className, String prefix, boolean staticContext, List<String> properties, boolean leaf, boolean nameOnly) {
        this.sourceFile = sourceFile;
        this.sourceClassName = sourceClassName;
        this.className = className;
        this.prefix = prefix;
        this.staticContext = staticContext;
        this.properties = properties;
        this.leaf = leaf;
        this.nameOnly = nameOnly;
        this.anchor = anchor;
    }

    public int getAnchor() {
        return this.anchor;
    }

    public String getClassName() {
        return this.className;
    }

    public FileObject getSourceFile() {
        return this.sourceFile;
    }

    public List<String> getProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    public String getSourceClassName() {
        return this.sourceClassName;
    }

    public boolean isStaticContext() {
        return this.staticContext;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    public boolean isNameOnly() {
        return this.nameOnly;
    }
}

