/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.layout;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Baseline {
    private static final Rectangle viewRect = new Rectangle();
    private static final Rectangle textRect = new Rectangle();
    private static final Rectangle iconRect = new Rectangle();
    private static final int EDGE_SPACING = 2;
    private static final int TEXT_SPACING = 2;
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private static Label TABLE_LABEL;
    private static Label LIST_LABEL;
    private static Label TREE_LABEL;
    private static Class CLASSIC_WINDOWS;
    private static boolean checkedForClassic;
    private static final Map BASELINE_MAP;
    private static Method COMPONENT_BASELINE_METHOD;
    static /* synthetic */ Class class$java$awt$Component;

    public static int getBaseline(Component component) {
        Dimension pref = component.getPreferredSize();
        return Baseline.getBaseline(component, pref.width, pref.height);
    }

    private static Method getBaselineMethod(Component component) {
        Class<?> klass;
        if (COMPONENT_BASELINE_METHOD != null) {
            return COMPONENT_BASELINE_METHOD;
        }
        for (klass = component.getClass(); klass != null; klass = klass.getSuperclass()) {
            if (!BASELINE_MAP.containsKey(klass)) continue;
            Method method = (Method)BASELINE_MAP.get(klass);
            return method;
        }
        klass = component.getClass();
        Method[] methods = klass.getMethods();
        for (int i = methods.length - 1; i >= 0; --i) {
            Class<?>[] params;
            Method method = methods[i];
            if (!"getBaseline".equals(method.getName()) || (params = method.getParameterTypes()).length != 2 || params[0] != Integer.TYPE || params[1] != Integer.TYPE) continue;
            BASELINE_MAP.put(klass, method);
            return method;
        }
        BASELINE_MAP.put(klass, null);
        return null;
    }

    private static int invokeBaseline(Method method, Component c, int width, int height) {
        int baseline = -1;
        try {
            baseline = (Integer)method.invoke((Object)c, new Integer(width), new Integer(height));
        }
        catch (IllegalAccessException iae) {
        }
        catch (IllegalArgumentException iae2) {
        }
        catch (InvocationTargetException ite2) {
            // empty catch block
        }
        return baseline;
    }

    public static int getBaseline(Component component, int width, int height) {
        return -1;
    }

    private static Insets rotateInsets(Insets topInsets, int targetPlacement) {
        return new Insets(topInsets.top, topInsets.left, topInsets.bottom, topInsets.right);
    }

    private static int getTextAreaBaseline(TextArea text, int height) {
        FontMetrics fm = text.getFontMetrics(text.getFont());
        return 6 + fm.getAscent();
    }

    private static int getListBaseline(List list, int height) {
        int rowHeight = -1;
        if (LIST_LABEL == null) {
            LIST_LABEL = new Label("X");
        }
        Label label = LIST_LABEL;
        label.setFont(list.getFont());
        if (rowHeight == -1) {
            rowHeight = label.getPreferredSize().height;
        }
        return Baseline.getLabelBaseline(label, rowHeight) + 6;
    }

    private static int getScrollPaneBaseline(ScrollPane sp, int height) {
        return -1;
    }

    private static int getPanelBaseline(Panel panel, int height) {
        return -1;
    }

    private static int getLabelBaseline(Label label, int height) {
        FontMetrics fm = label.getFontMetrics(label.getFont());
        Baseline.resetRects(label, height);
        return Baseline.textRect.y + fm.getAscent();
    }

    private static int getSingleLineTextBaseline(TextComponent textComponent, int h) {
        return -1;
    }

    private static int getButtonBaseline(Button button, int height) {
        FontMetrics fm = button.getFontMetrics(button.getFont());
        Baseline.resetRects(button, height);
        String text = button.getLabel();
        if (text != null && text.startsWith("<html>")) {
            return -1;
        }
        return Baseline.textRect.y + fm.getAscent();
    }

    private static void resetRects(Component c, int height) {
        Insets insets = new Insets(5, 5, 5, 5);
        Baseline.viewRect.x = insets.left;
        Baseline.viewRect.y = insets.top;
        Baseline.viewRect.width = c.getWidth() - (insets.right + Baseline.viewRect.x);
        Baseline.viewRect.height = height - (insets.bottom + Baseline.viewRect.y);
        Baseline.textRect.height = 0;
        Baseline.textRect.width = 0;
        Baseline.textRect.y = 0;
        Baseline.textRect.x = 0;
        Baseline.iconRect.height = 0;
        Baseline.iconRect.width = 0;
        Baseline.iconRect.y = 0;
        Baseline.iconRect.x = 0;
    }

    protected Baseline() {
    }

    public int getComponentBaseline(Component component, int width, int height) {
        return -1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        BASELINE_MAP = Collections.synchronizedMap(new HashMap());
        COMPONENT_BASELINE_METHOD = null;
        try {
            COMPONENT_BASELINE_METHOD = (class$java$awt$Component == null ? (class$java$awt$Component = Baseline.class$("java.awt.Component")) : class$java$awt$Component).getMethod("getBaseline", Integer.TYPE, Integer.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

