/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import java.util.prefs.Preferences;
import org.netbeans.modules.nativeexecution.ConnectionManagerAccessor;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.util.NbPreferences;

public final class Authentication {
    private static final Preferences prefs = NbPreferences.forModule(Authentication.class);
    private static final boolean isUnitTest = Boolean.getBoolean("nativeexecution.mode.unittest");
    private static final String knownHosts;
    private static String last_ssh_key;
    private final ExecutionEnvironment env;
    private final String pref_key;
    private String ssh_key;
    private Type type = Type.UNDEFINED;

    private Authentication(ExecutionEnvironment env) {
        this.pref_key = env == null ? null : Authentication.class.getName() + '_' + ExecutionEnvironmentFactory.toUniqueID(env);
        this.env = env;
    }

    public static Authentication getFor(ExecutionEnvironment env) {
        Authentication result = new Authentication(env);
        result.restore();
        if (isUnitTest) {
            result.setPassword();
        } else if (result.ssh_key == null || result.ssh_key.trim().length() == 0) {
            result.ssh_key = last_ssh_key;
        }
        return result;
    }

    public boolean isDefined() {
        return this.type != Type.UNDEFINED;
    }

    public void setPassword() {
        if (this.type == Type.PASSWORD) {
            return;
        }
        this.type = Type.PASSWORD;
    }

    public String getKnownHosts() {
        return knownHosts;
    }

    public void setSSHKey(String ssh_key) throws IllegalArgumentException {
        if (!Authentication.isValidKey(ssh_key)) {
            throw new IllegalArgumentException("Invalid key " + ssh_key);
        }
        this.type = Type.SSH_KEY;
        this.ssh_key = ssh_key;
    }

    public static boolean isValidKey(String key) {
        JSch test = new JSch();
        try {
            test.addIdentity(key);
        }
        catch (JSchException ex) {
            return false;
        }
        return true;
    }

    private static boolean isValidHosts(String knownHosts) {
        JSch test = new JSch();
        try {
            test.setKnownHosts(knownHosts);
        }
        catch (JSchException ex) {
            return false;
        }
        return true;
    }

    public Type getType() {
        return this.type;
    }

    public void store() {
        if (this.env == null) {
            return;
        }
        if (this.type == Type.SSH_KEY) {
            prefs.put(this.pref_key, this.ssh_key);
            last_ssh_key = this.ssh_key;
        } else {
            prefs.put(this.pref_key, this.type.name());
        }
    }

    private void restore() {
        if (this.env == null) {
            return;
        }
        String typeOrKey = prefs.get(this.pref_key, Type.UNDEFINED.name());
        if (Type.UNDEFINED.name().equals(typeOrKey)) {
            this.type = Type.UNDEFINED;
        } else if (Type.PASSWORD.name().equals(typeOrKey)) {
            this.type = Type.PASSWORD;
        } else if (Authentication.isValidKey(typeOrKey)) {
            this.type = Type.SSH_KEY;
            this.ssh_key = typeOrKey;
        } else {
            this.type = Type.UNDEFINED;
        }
    }

    public ExecutionEnvironment getEnv() {
        return this.env;
    }

    public void remove() {
        if (this.pref_key != null) {
            prefs.remove(this.pref_key);
        }
    }

    public void apply() {
        if (this.env == null) {
            return;
        }
        this.store();
        ConnectionManagerAccessor access = ConnectionManagerAccessor.getDefault();
        access.changeAuth(this.env, this);
    }

    public String getKey() {
        return this.ssh_key;
    }

    static {
        String hosts = System.getProperty("ssh.knonwhosts.file", null);
        if (!(hosts != null && Authentication.isValidHosts(hosts) || Authentication.isValidHosts(hosts = System.getProperty("user.home") + "/.ssh/known_hosts") || Authentication.isValidHosts(hosts = System.getProperty("netbeans.user") + "/.ssh/known_hosts"))) {
            hosts = null;
        }
        knownHosts = hosts;
        String key = System.getProperty("user.home") + "/.ssh/id_dsa";
        if (!Authentication.isValidKey(key) && !Authentication.isValidKey(key = System.getProperty("user.home") + "/.ssh/id_rsa")) {
            key = null;
        }
        last_ssh_key = key;
    }

    public static enum Type {
        UNDEFINED,
        PASSWORD,
        SSH_KEY;

    }
}

