/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.api.execution;

import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.impl.DLightSessionConfigurationAccessor;
import org.netbeans.modules.dlight.api.tool.DLightConfiguration;

public final class DLightSessionConfiguration {
    private String dlightConfigurationName;
    private DLightConfiguration dlightConfiguration;
    private String storageID;
    private String sessionName;
    private DLightTarget target;
    private final Mode sesionMode;
    private boolean isUsingSharedStorage = false;

    public DLightSessionConfiguration() {
        this(Mode.ALL);
    }

    public DLightSessionConfiguration(Mode sessionMode) {
        this.sesionMode = sessionMode;
    }

    public void setSharedStorageKey(String storageUniqueID) {
        this.storageID = storageUniqueID;
        this.isUsingSharedStorage = this.storageID != null && !this.storageID.trim().equals("");
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public void setDLightTarget(DLightTarget dlightTarget) {
        this.target = dlightTarget;
    }

    public void setDLightConfigurationName(String dlightConfigurationName) {
        this.dlightConfigurationName = dlightConfigurationName;
    }

    public void setDLightConfiguration(DLightConfiguration configuration) {
        this.dlightConfiguration = configuration;
    }

    public String toString() {
        return "DLight [" + this.dlightConfiguration == null ? this.dlightConfigurationName : this.dlightConfiguration.getConfigurationName() + "] Session Creation for " + this.target;
    }

    static {
        DLightSessionConfigurationAccessor.setDefault(new DLightSessionConfigurationAccesorImpl());
    }

    private static final class DLightSessionConfigurationAccesorImpl
    extends DLightSessionConfigurationAccessor {
        private DLightSessionConfigurationAccesorImpl() {
        }

        @Override
        public String getSessionName(DLightSessionConfiguration configuration) {
            return configuration.sessionName;
        }

        @Override
        public String getDLightConfigurationName(DLightSessionConfiguration configuration) {
            return configuration.dlightConfigurationName;
        }

        @Override
        public DLightConfiguration getDLightConfiguration(DLightSessionConfiguration configuration) {
            return configuration.dlightConfiguration;
        }

        @Override
        public DLightTarget getDLightTarget(DLightSessionConfiguration configuration) {
            return configuration.target;
        }

        @Override
        public Mode getSessionMode(DLightSessionConfiguration configuration) {
            return configuration.sesionMode;
        }

        @Override
        public boolean isUsingSharedStorage(DLightSessionConfiguration configuration) {
            return configuration.isUsingSharedStorage;
        }

        @Override
        public String getSharedStorageUniqueKey(DLightSessionConfiguration configuration) {
            return configuration.storageID;
        }
    }

    public static enum Mode {
        ALL,
        ANALYZE;

    }
}

