/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ProjectCustomizerPanel
extends JPanel
implements HelpCtx.Provider {
    private static final String[] LAF_RESOURCE_NAMES = new String[]{"default", "system"};
    private static final String[] LAF_DISPLAY_NAMES = new String[]{NbBundle.getMessage(ProjectCustomizerPanel.class, (String)"LAF_Default"), NbBundle.getMessage(ProjectCustomizerPanel.class, (String)"LAF_System")};
    private FileObject lafJarRoot;
    static String fileChooserDir;
    private JTextField appIdTextField;
    private JButton browseButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JComboBox lafCombo;
    private JTextField vendorIdTextField;

    public ProjectCustomizerPanel() {
        this.initComponents();
        this.lafCombo.setModel(this.lafComboModel());
    }

    void setVendorId(String text) {
        this.vendorIdTextField.setText(text);
    }

    String getVendorId() {
        return this.vendorIdTextField.getText();
    }

    void setApplicationId(String text) {
        this.appIdTextField.setText(text);
    }

    String getApplicationId() {
        return this.appIdTextField.getText();
    }

    void setLookAndFeel(String clsName) {
        for (int i = 0; i < LAF_RESOURCE_NAMES.length; ++i) {
            if (!LAF_RESOURCE_NAMES[i].equalsIgnoreCase(clsName)) continue;
            this.lafCombo.setSelectedItem(LAF_DISPLAY_NAMES[i]);
            return;
        }
        this.lafCombo.setSelectedItem(clsName);
    }

    String getLookAndFeel() {
        String lafText = ((String)this.lafCombo.getEditor().getItem()).trim();
        for (int i = 0; i < LAF_RESOURCE_NAMES.length; ++i) {
            if (!LAF_DISPLAY_NAMES[i].equalsIgnoreCase(lafText)) continue;
            return LAF_RESOURCE_NAMES[i];
        }
        return lafText;
    }

    FileObject getLookAndFeelJAR() {
        if (this.lafJarRoot != null) {
            String lafText = ((String)this.lafCombo.getEditor().getItem()).trim();
            for (int i = 0; i < LAF_RESOURCE_NAMES.length; ++i) {
                if (!LAF_DISPLAY_NAMES[i].equalsIgnoreCase(lafText) && !LAF_RESOURCE_NAMES[i].equalsIgnoreCase(lafText)) continue;
                return null;
            }
        }
        return this.lafJarRoot;
    }

    void setReadOnly() {
        this.vendorIdTextField.setEnabled(false);
        this.appIdTextField.setEnabled(false);
        this.lafCombo.setEnabled(false);
        this.browseButton.setVisible(false);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.vendorIdTextField = new JTextField();
        this.appIdTextField = new JTextField();
        this.lafCombo = new JComboBox();
        this.browseButton = new JButton();
        this.jLabel1.setText(NbBundle.getMessage(ProjectCustomizerPanel.class, (String)"jLabel1.text"));
        this.jLabel2.setText(NbBundle.getMessage(ProjectCustomizerPanel.class, (String)"jLabel2.text"));
        this.jLabel3.setText(NbBundle.getMessage(ProjectCustomizerPanel.class, (String)"jLabel3.text"));
        this.jLabel4.setText(NbBundle.getMessage(ProjectCustomizerPanel.class, (String)"jLabel4.text"));
        this.vendorIdTextField.setToolTipText(NbBundle.getMessage(ProjectCustomizerPanel.class, (String)"vendorIdTextField.toolTipText"));
        this.appIdTextField.setToolTipText(NbBundle.getMessage(ProjectCustomizerPanel.class, (String)"vendorIdTextField.toolTipText"));
        this.lafCombo.setEditable(true);
        this.browseButton.setText(NbBundle.getMessage(ProjectCustomizerPanel.class, (String)"browseButton.text"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectCustomizerPanel.this.browseButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel2).add((Component)this.jLabel3).add((Component)this.jLabel4)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.vendorIdTextField, -1, 304, Short.MAX_VALUE).add((Component)this.appIdTextField, -1, 304, Short.MAX_VALUE).add(2, (Component)this.lafCombo, 0, 304, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.browseButton))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.vendorIdTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.appIdTextField, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.lafCombo, -2, -1, -2).add((Component)this.browseButton)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        File file;
        JFileChooser fileChooser = new JFileChooser(fileChooserDir);
        fileChooser.setDialogTitle(NbBundle.getMessage(ProjectCustomizerPanel.class, (String)"CTL_SelectJAR_Caption"));
        fileChooser.setFileSelectionMode(0);
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.setControlButtonsAreShown(true);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".jar");
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(ProjectCustomizerPanel.class, (String)"CTL_JarArchivesMask");
            }
        });
        if (fileChooser.showOpenDialog(this.getTopLevelAncestor()) == 0 && (file = fileChooser.getSelectedFile()) != null) {
            FileObject jar = FileUtil.toFileObject((File)file);
            if (jar != null && FileUtil.isArchiveFile((FileObject)jar)) {
                FileObject root = FileUtil.getArchiveRoot((FileObject)jar);
                LinkedList<String> lafList = new LinkedList<String>();
                try {
                    ProjectCustomizerPanel.scanFolderForLaF(root, lafList, ClassPathSupport.createClassPath((URL[])new URL[]{root.getURL()}));
                }
                catch (IOException ex) {
                    Logger.getLogger(ProjectCustomizerPanel.class.getClass().getName()).log(Level.SEVERE, "JAR file scanning failed", ex);
                }
                if (!lafList.isEmpty()) {
                    for (int i = LAF_DISPLAY_NAMES.length - 1; i >= 0; --i) {
                        lafList.add(0, LAF_DISPLAY_NAMES[i]);
                    }
                    this.lafCombo.setModel(new DefaultComboBoxModel<Object>(lafList.toArray()));
                    this.lafCombo.setSelectedIndex(LAF_DISPLAY_NAMES.length);
                    this.lafJarRoot = root;
                } else {
                    NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ProjectCustomizerPanel.class, (String)"MSG_NoLafFound"));
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                }
            }
            fileChooserDir = file.getParent();
        }
    }

    private static void scanFolderForLaF(FileObject folder, List<String> classList, ClassPath jarCP) throws IOException {
        for (FileObject fo : folder.getChildren()) {
            String lafClsName;
            if (fo.isFolder()) {
                ProjectCustomizerPanel.scanFolderForLaF(fo, classList, jarCP);
                continue;
            }
            if (!"class".equals(fo.getExt()) || DataObject.find((FileObject)fo) == null || (lafClsName = ProjectCustomizerPanel.scanClassFile(fo, classList, jarCP)) == null) continue;
            classList.add(lafClsName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String scanClassFile(FileObject classFO, List<String> classList, ClassPath jarCP) throws IOException {
        int access;
        ClassFile clazz;
        InputStream is = null;
        try {
            is = classFO.getInputStream();
            clazz = new ClassFile(is, false);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        if (!(clazz == null || !Modifier.isPublic(access = clazz.getAccess()) || Modifier.isAbstract(access) || Modifier.isInterface(access) || clazz.isAnnotation() || clazz.isEnum() || clazz.isSynthetic() || clazz.getSuperClass() == null)) {
            String superName = clazz.getSuperClass().getExternalName();
            FileObject fo = jarCP.findResource(superName.replace('.', '/') + ".class");
            if (ProjectCustomizerPanel.isStandardLAFSuperClass(superName) || fo != null && ProjectCustomizerPanel.scanClassFile(fo, classList, jarCP) != null) {
                return clazz.getName().getExternalName();
            }
        }
        return null;
    }

    private static boolean isStandardLAFSuperClass(String name) {
        return name.startsWith("javax.swing") && ("javax.swing.LookAndFeel".equals(name) || "javax.swing.plaf.metal.MetalLookAndFeel".equals(name) || "javax.swing.plaf.basic.BasicLookAndFeel".equals(name) || "javax.swing.plaf.synth.SynthLookAndFeel".equals(name));
    }

    private ComboBoxModel lafComboModel() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(LAF_DISPLAY_NAMES);
        for (UIManager.LookAndFeelInfo laf : UIManager.getInstalledLookAndFeels()) {
            model.addElement(laf.getClassName());
        }
        return model;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.swingapp.ProjectCustomizerPanel");
    }
}

