/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.annotate;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.StatusBar;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.cvsclient.command.annotate.AnnotateLine;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.versioning.system.cvss.ui.actions.annotate.AnnotationMark;
import org.netbeans.modules.versioning.system.cvss.ui.actions.annotate.AnnotationMarkInstaller;
import org.netbeans.modules.versioning.system.cvss.ui.actions.annotate.AnnotationMarkProvider;
import org.netbeans.modules.versioning.system.cvss.ui.actions.annotate.LinesReader;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.actions.log.LogOutputListener;
import org.netbeans.modules.versioning.system.cvss.ui.actions.log.SearchHistoryAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.GetCleanAction;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.spi.diff.DiffProvider;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.xml.XMLUtil;

final class AnnotationBar
extends JComponent
implements Accessible,
PropertyChangeListener,
LogOutputListener,
DocumentListener,
ChangeListener,
ActionListener,
Runnable,
ComponentListener {
    private final JTextComponent textComponent;
    private final EditorUI editorUI;
    private final FoldHierarchy foldHierarchy;
    private final BaseDocument doc;
    private final Caret caret;
    private Timer caretTimer;
    private boolean annotated;
    private Map elementAnnotations;
    private Map commitMessages;
    private String elementAnnotationsSubstitute;
    private Color backgroundColor = Color.WHITE;
    private Color foregroundColor = Color.BLACK;
    private Color selectedColor = Color.BLUE;
    private String recentStatusMessage;
    private String recentRevision;
    RequestProcessor requestProcessor = null;
    private RequestProcessor.Task latestAnnotationTask = null;
    private final Map renderingHints;

    public AnnotationBar(JTextComponent target) {
        this.textComponent = target;
        this.editorUI = Utilities.getEditorUI((JTextComponent)target);
        this.foldHierarchy = FoldHierarchy.get((JTextComponent)this.editorUI.getComponent());
        this.doc = this.editorUI.getDocument();
        this.caret = this.textComponent.getCaret();
        if (this.textComponent instanceof JEditorPane) {
            String mimeType = NbEditorUtilities.getMimeType((JTextComponent)this.textComponent);
            FontColorSettings fcs = (FontColorSettings)MimeLookup.getLookup((String)mimeType).lookup(FontColorSettings.class);
            this.renderingHints = (Map)fcs.getFontColors("default").getAttribute(EditorStyleConstants.RenderingHints);
        } else {
            this.renderingHints = null;
        }
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.elementAnnotationsSubstitute = "";
    }

    public void annotate() {
        this.annotated = true;
        this.elementAnnotations = null;
        this.commitMessages = null;
        ResourceBundle loc = NbBundle.getBundle(AnnotationBar.class);
        this.elementAnnotationsSubstitute = loc.getString("CTL_AnnotationSubstitute");
        this.doc.addDocumentListener((DocumentListener)this);
        this.textComponent.addComponentListener(this);
        this.editorUI.addPropertyChangeListener((PropertyChangeListener)this);
        this.revalidate();
    }

    @Override
    public void annotationLines(File file, List annotateLines) {
        final LinkedList lines = new LinkedList(annotateLines);
        int lineCount = lines.size();
        final int[] ann2editorPermutation = new int[lineCount];
        for (int i = 0; i < lineCount; ++i) {
            ann2editorPermutation[i] = i + 1;
        }
        DiffProvider diff = (DiffProvider)Lookup.getDefault().lookup(DiffProvider.class);
        if (diff != null) {
            LinesReader r = new LinesReader(lines);
            Reader docReader = Utils.getDocumentReader((Document)this.doc);
            try {
                int secondLen;
                int firstLen;
                int firstShift;
                Difference d;
                int i;
                Difference[] differences = diff.computeDiff((Reader)r, docReader);
                for (i = 0; i < differences.length; ++i) {
                    int editorStart;
                    d = differences[i];
                    if (d.getType() == 1) continue;
                    firstShift = d.getFirstEnd() - d.getFirstStart() + 1;
                    if (d.getType() == 2) {
                        firstLen = d.getFirstEnd() - d.getFirstStart();
                        secondLen = d.getSecondEnd() - d.getSecondStart();
                        if (secondLen >= firstLen) continue;
                        editorStart = d.getSecondStart();
                        firstShift = firstLen - secondLen;
                    } else {
                        editorStart = d.getSecondStart() + 1;
                    }
                    int c = editorStart + firstShift - 1;
                    while (c < lineCount) {
                        int n = c++;
                        ann2editorPermutation[n] = ann2editorPermutation[n] - firstShift;
                    }
                }
                for (i = differences.length - 1; i >= 0; --i) {
                    int firstStart;
                    d = differences[i];
                    if (d.getType() == 0) continue;
                    firstShift = d.getSecondEnd() - d.getSecondStart() + 1;
                    if (d.getType() == 2) {
                        firstLen = d.getFirstEnd() - d.getFirstStart();
                        secondLen = d.getSecondEnd() - d.getSecondStart();
                        if (secondLen <= firstLen) continue;
                        firstShift = secondLen - firstLen;
                        firstStart = d.getFirstStart();
                    } else {
                        firstStart = d.getFirstStart() + 1;
                    }
                    int k = firstStart - 1;
                    while (k < lineCount) {
                        int n = k++;
                        ann2editorPermutation[n] = ann2editorPermutation[n] + firstShift;
                    }
                }
            }
            catch (IOException e) {
                ErrorManager err = ErrorManager.getDefault();
                err.annotate((Throwable)e, "Cannot compute local diff required for annotations, ignoring...");
                err.notify(1, (Throwable)e);
            }
        }
        this.doc.runAtomic(new Runnable(){

            @Override
            public void run() {
                StyledDocument sd = (StyledDocument)AnnotationBar.this.doc;
                Iterator it = lines.iterator();
                AnnotationBar.this.elementAnnotations = Collections.synchronizedMap(new HashMap(lines.size()));
                while (it.hasNext()) {
                    AnnotateLine line = (AnnotateLine)it.next();
                    int lineNum = ann2editorPermutation[line.getLineNum() - 1];
                    try {
                        int lineOffset = NbDocument.findLineOffset((StyledDocument)sd, (int)(lineNum - 1));
                        Element element = sd.getParagraphElement(lineOffset);
                        AnnotationBar.this.elementAnnotations.put(element, line);
                    }
                    catch (IndexOutOfBoundsException ex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                    }
                }
            }
        });
        this.caret.addChangeListener(this);
        this.caretTimer = new Timer(500, this);
        this.caretTimer.setRepeats(false);
        this.onCurrentLine();
        this.revalidate();
        this.repaint();
    }

    @Override
    public void commitMessages(Map messages) {
        this.commitMessages = messages;
    }

    private File getCurrentFile() {
        File result = null;
        DataObject dobj = (DataObject)this.doc.getProperty((Object)"stream");
        if (dobj != null) {
            FileObject fo = dobj.getPrimaryFile();
            result = FileUtil.toFile((FileObject)fo);
        }
        return result;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    e.consume();
                    AnnotationBar.this.createPopup().show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.setToolTipText("");
    }

    private JPopupMenu createPopup() {
        ResourceBundle loc = NbBundle.getBundle(AnnotationBar.class);
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem diffMenu = new JMenuItem(loc.getString("CTL_MenuItem_DiffToRevision"));
        diffMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file;
                String prevRevision;
                if (AnnotationBar.this.recentRevision != null && (prevRevision = org.netbeans.modules.versioning.system.cvss.util.Utils.previousRevision(AnnotationBar.this.recentRevision)) != null && (file = AnnotationBar.this.getCurrentFile()) != null) {
                    DiffExecutor diffExecutor = new DiffExecutor(file.getName());
                    diffExecutor.showDiff(file, prevRevision, AnnotationBar.this.recentRevision);
                }
            }
        });
        popupMenu.add(diffMenu);
        JMenuItem rollbackMenu = new JMenuItem(loc.getString("CTL_MenuItem_RollbackToRevision"));
        rollbackMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = AnnotationBar.this.getCurrentFile();
                GetCleanAction.rollback(file, AnnotationBar.this.recentRevision);
            }
        });
        popupMenu.add(rollbackMenu);
        Project prj = org.netbeans.modules.versioning.system.cvss.util.Utils.getProject(this.getCurrentFile());
        if (prj != null) {
            String prjName = ProjectUtils.getInformation((Project)prj).getDisplayName();
            JMenuItem menu = new JMenuItem(NbBundle.getMessage(AnnotationBar.class, (String)"CTL_MenuItem_FindCommitInProject", (Object)prjName));
            menu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int line = AnnotationBar.this.getCurrentLine();
                    if (line == -1) {
                        return;
                    }
                    AnnotateLine al = AnnotationBar.this.getAnnotateLine(line);
                    if (al == null || AnnotationBar.this.commitMessages == null) {
                        return;
                    }
                    String message = (String)AnnotationBar.this.commitMessages.get(al.getRevision());
                    File file = AnnotationBar.this.getCurrentFile();
                    Project project = org.netbeans.modules.versioning.system.cvss.util.Utils.getProject(file);
                    Context context = org.netbeans.modules.versioning.system.cvss.util.Utils.getProjectContext(project, file);
                    SearchHistoryAction.openSearch(context, ProjectUtils.getInformation((Project)project).getDisplayName(), message, al.getAuthor(), al.getDate());
                }
            });
            popupMenu.add(menu);
        }
        JMenuItem menu = new JMenuItem(loc.getString("CTL_MenuItem_FindCommitInProjects"));
        menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int line = AnnotationBar.this.getCurrentLine();
                if (line == -1) {
                    return;
                }
                AnnotateLine al = AnnotationBar.this.getAnnotateLine(line);
                if (al == null || AnnotationBar.this.commitMessages == null) {
                    return;
                }
                String message = (String)AnnotationBar.this.commitMessages.get(al.getRevision());
                Project[] projects = OpenProjects.getDefault().getOpenProjects();
                int n = projects.length;
                SearchHistoryAction.openSearch(n == 1 ? ProjectUtils.getInformation((Project)projects[0]).getDisplayName() : NbBundle.getMessage(AnnotationBar.class, (String)"CTL_FindAssociateChanges_OpenProjects_Title", (Object)Integer.toString(n)), message, al.getAuthor(), al.getDate());
            }
        });
        popupMenu.add(menu);
        menu = new JMenuItem(loc.getString("CTL_MenuItem_CloseAnnotations"));
        menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnnotationBar.this.hideBar();
            }
        });
        popupMenu.addSeparator();
        popupMenu.add(menu);
        diffMenu.setVisible(false);
        rollbackMenu.setVisible(false);
        if (this.recentRevision != null) {
            String format;
            String prevRevision = org.netbeans.modules.versioning.system.cvss.util.Utils.previousRevision(this.recentRevision);
            if (prevRevision != null) {
                format = loc.getString("CTL_MenuItem_DiffToRevision");
                diffMenu.setText(MessageFormat.format(format, this.recentRevision, prevRevision));
                diffMenu.setVisible(true);
            }
            format = loc.getString("CTL_MenuItem_RollbackToRevision");
            rollbackMenu.setText(MessageFormat.format(format, this.recentRevision));
            rollbackMenu.setVisible(true);
        }
        return popupMenu;
    }

    void hideBar() {
        this.annotated = false;
        this.revalidate();
        this.release();
    }

    private int getCurrentLine() {
        int result = 0;
        int offset = this.caret.getDot();
        try {
            result = Utilities.getLineOffset((BaseDocument)this.doc, (int)offset);
        }
        catch (BadLocationException ex) {
            result = -1;
        }
        return result;
    }

    private RequestProcessor getRequestProcessor() {
        if (this.requestProcessor == null) {
            this.requestProcessor = new RequestProcessor("AnnotationBarRP", 1, true);
        }
        return this.requestProcessor;
    }

    private void onCurrentLine() {
        if (this.latestAnnotationTask != null) {
            this.latestAnnotationTask.cancel();
        }
        this.latestAnnotationTask = this.getRequestProcessor().post((Runnable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ResourceBundle loc = NbBundle.getBundle(AnnotationBar.class);
        StatusBar statusBar = this.editorUI.getStatusBar();
        this.recentStatusMessage = loc.getString("CTL_StatusBar_WaitFetchAnnotation");
        statusBar.setText("main", this.recentStatusMessage);
        int line = -1;
        int offset = this.caret.getDot();
        try {
            line = Utilities.getLineOffset((BaseDocument)this.doc, (int)offset);
        }
        catch (BadLocationException ex) {
            ErrorManager err = ErrorManager.getDefault();
            err.annotate((Throwable)ex, "Can not get line for caret at offset " + offset);
            err.notify((Throwable)ex);
            this.clearRecentFeedback();
            return;
        }
        AnnotateLine al = this.getAnnotateLine(line);
        if (al == null) {
            AnnotationMarkProvider amp = AnnotationMarkInstaller.getMarkProvider(this.textComponent);
            if (amp != null) {
                amp.setMarks(Collections.EMPTY_LIST);
            }
            this.clearRecentFeedback();
            if (this.recentRevision != null) {
                this.recentRevision = null;
                this.repaint();
            }
            return;
        }
        String revision = al.getRevision();
        if (!revision.equals(this.recentRevision)) {
            this.recentRevision = revision;
            this.repaint();
            AnnotationMarkProvider amp = AnnotationMarkInstaller.getMarkProvider(this.textComponent);
            if (amp != null) {
                Iterator it2;
                ArrayList<AnnotationMark> marks = new ArrayList<AnnotationMark>(this.elementAnnotations.size());
                Map map = this.elementAnnotations;
                synchronized (map) {
                    it2 = new HashSet(this.elementAnnotations.entrySet()).iterator();
                }
                while (it2.hasNext()) {
                    Map.Entry next = it2.next();
                    AnnotateLine annotateLine = (AnnotateLine)next.getValue();
                    if (revision.equals(annotateLine.getRevision())) {
                        Element element = (Element)next.getKey();
                        if (!this.elementAnnotations.containsKey(element)) continue;
                        int elementOffset = element.getStartOffset();
                        int lineNumber = NbDocument.findLineNumber((StyledDocument)((StyledDocument)this.doc), (int)elementOffset);
                        AnnotationMark mark = new AnnotationMark(lineNumber, revision);
                        marks.add(mark);
                    }
                    if (!Thread.interrupted()) continue;
                    this.clearRecentFeedback();
                    return;
                }
                amp.setMarks(marks);
            }
        }
        if (this.commitMessages != null) {
            String message = (String)this.commitMessages.get(revision);
            if (message != null) {
                this.recentStatusMessage = message;
                statusBar.setText("main", al.getAuthor() + ": " + this.recentStatusMessage);
            } else {
                this.clearRecentFeedback();
            }
        } else {
            this.clearRecentFeedback();
        }
    }

    private void clearRecentFeedback() {
        StatusBar statusBar = this.editorUI.getStatusBar();
        if (statusBar.getText("main") == this.recentStatusMessage) {
            statusBar.setText("main", "");
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int width;
        Dimension dim = this.textComponent.getSize();
        dim.width = width = this.annotated ? this.getBarWidth() : 0;
        dim.height *= 2;
        return dim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getBarWidth() {
        String longestString = "";
        if (this.elementAnnotations == null) {
            longestString = this.elementAnnotationsSubstitute;
        } else {
            Map map = this.elementAnnotations;
            synchronized (map) {
                for (AnnotateLine line : this.elementAnnotations.values()) {
                    String displayName = line.getRevision() + " " + line.getAuthor();
                    if (displayName.length() <= longestString.length()) continue;
                    longestString = displayName;
                }
            }
        }
        char[] data = longestString.toCharArray();
        int w = this.getGraphics().getFontMetrics().charsWidth(data, 0, data.length);
        return w;
    }

    private void release() {
        AnnotationMarkProvider amp;
        this.editorUI.removePropertyChangeListener((PropertyChangeListener)this);
        this.textComponent.removeComponentListener(this);
        this.doc.removeDocumentListener((DocumentListener)this);
        this.caret.removeChangeListener(this);
        if (this.caretTimer != null) {
            this.caretTimer.removeActionListener(this);
        }
        this.commitMessages = null;
        this.elementAnnotations = null;
        if (this.latestAnnotationTask != null) {
            this.latestAnnotationTask.cancel();
        }
        if ((amp = AnnotationMarkInstaller.getMarkProvider(this.textComponent)) != null) {
            amp.setMarks(Collections.EMPTY_LIST);
        }
        this.clearRecentFeedback();
    }

    private void paintView(View view, Graphics g, int yBase) {
        JTextComponent component = this.editorUI.getComponent();
        if (component == null) {
            return;
        }
        BaseTextUI textUI = (BaseTextUI)component.getUI();
        Element rootElem = textUI.getRootView(component).getElement();
        int line = rootElem.getElementIndex(view.getStartOffset());
        String annotation = "";
        AnnotateLine al = null;
        if (this.elementAnnotations != null) {
            al = this.getAnnotateLine(line);
            if (al != null) {
                annotation = al.getRevision() + " " + al.getAuthor();
            }
        } else {
            annotation = this.elementAnnotationsSubstitute;
        }
        if (al != null && al.getRevision().equals(this.recentRevision)) {
            g.setColor(this.selectedColor());
        } else {
            g.setColor(this.foregroundColor());
        }
        g.drawString(annotation, 0, yBase + this.editorUI.getLineAscent());
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        if (this.editorUI == null) {
            return null;
        }
        int line = this.getLineFromMouseEvent(e);
        StringBuffer annotation = new StringBuffer();
        if (this.elementAnnotations != null) {
            AnnotateLine al = this.getAnnotateLine(line);
            if (al != null) {
                String message;
                String escapedAuthor = NbBundle.getMessage(AnnotationBar.class, (String)"BK0001");
                try {
                    escapedAuthor = XMLUtil.toElementContent((String)al.getAuthor());
                }
                catch (CharConversionException e1) {
                    ErrorManager err = ErrorManager.getDefault();
                    err.annotate((Throwable)e1, "CVS.AB: can not HTML escape: " + al.getAuthor());
                    err.notify(1, (Throwable)e1);
                }
                annotation.append("<html><!-- line=" + line++ + " -->" + al.getRevision() + " <b>" + escapedAuthor + "</b> " + al.getDateString());
                if (this.commitMessages != null && (message = (String)this.commitMessages.get(al.getRevision())) != null) {
                    String escaped = null;
                    try {
                        escaped = XMLUtil.toElementContent((String)message);
                    }
                    catch (CharConversionException e1) {
                        ErrorManager err = ErrorManager.getDefault();
                        err.annotate((Throwable)e1, "CVS.AB: can not HTML escape: " + message);
                        err.notify(1, (Throwable)e1);
                    }
                    if (escaped != null) {
                        String lined = escaped.replaceAll(System.getProperty("line.separator"), "<br>");
                        annotation.append("<p>" + lined);
                    }
                }
            }
        } else {
            annotation.append(this.elementAnnotationsSubstitute);
        }
        return annotation.toString();
    }

    private AnnotateLine getAnnotateLine(int line) {
        StyledDocument sd = (StyledDocument)this.doc;
        int lineOffset = NbDocument.findLineOffset((StyledDocument)sd, (int)line);
        Element element = sd.getParagraphElement(lineOffset);
        AnnotateLine al = (AnnotateLine)this.elementAnnotations.get(element);
        if (al != null) {
            int startOffset = element.getStartOffset();
            int endOffset = element.getEndOffset();
            try {
                int len = endOffset - startOffset;
                String text = this.doc.getText(startOffset, len - 1);
                String content = al.getContent();
                if (text.equals(content)) {
                    return al;
                }
            }
            catch (BadLocationException e) {
                ErrorManager err = ErrorManager.getDefault();
                err.annotate((Throwable)e, "CVS.AB: can not locate line annotation.");
                err.notify(1, (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        block14: {
            super.paintComponent(g);
            Rectangle clip = g.getClipBounds();
            JTextComponent component = this.editorUI.getComponent();
            if (component == null) {
                return;
            }
            BaseTextUI textUI = (BaseTextUI)component.getUI();
            View rootView = Utilities.getDocumentView((JTextComponent)component);
            if (rootView == null) {
                return;
            }
            g.setColor(this.backgroundColor());
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
            if (this.renderingHints != null) {
                ((Graphics2D)g).addRenderingHints(this.renderingHints);
            }
            AbstractDocument doc = (AbstractDocument)component.getDocument();
            doc.readLock();
            try {
                this.foldHierarchy.lock();
                try {
                    int startPos = textUI.getPosFromY(clip.y);
                    int startViewIndex = rootView.getViewIndex(startPos, Position.Bias.Forward);
                    int rootViewCount = rootView.getViewCount();
                    if (startViewIndex < 0 || startViewIndex >= rootViewCount) break block14;
                    int clipEndY = clip.y + clip.height;
                    for (int i = startViewIndex; i < rootViewCount; ++i) {
                        View view = rootView.getView(i);
                        Rectangle rec = component.modelToView(view.getStartOffset());
                        if (rec == null) {
                        } else {
                            int y = rec.y;
                            this.paintView(view, g, y);
                            if (y < clipEndY) continue;
                        }
                        break;
                    }
                }
                finally {
                    this.foldHierarchy.unlock();
                }
            }
            catch (BadLocationException ble) {
                ErrorManager.getDefault().notify((Throwable)ble);
            }
            finally {
                doc.readUnlock();
            }
        }
    }

    private Color backgroundColor() {
        if (this.textComponent != null) {
            return this.textComponent.getBackground();
        }
        return this.backgroundColor;
    }

    private Color foregroundColor() {
        if (this.textComponent != null) {
            return this.textComponent.getForeground();
        }
        return this.foregroundColor;
    }

    private Color selectedColor() {
        if (this.backgroundColor == this.backgroundColor()) {
            return this.selectedColor;
        }
        if (this.textComponent != null) {
            return this.textComponent.getForeground();
        }
        return this.selectedColor;
    }

    private int getLineFromMouseEvent(MouseEvent e) {
        int line = -1;
        if (this.editorUI != null) {
            try {
                JTextComponent component = this.editorUI.getComponent();
                BaseTextUI textUI = (BaseTextUI)component.getUI();
                int clickOffset = textUI.viewToModel(component, new Point(0, e.getY()));
                line = Utilities.getLineOffset((BaseDocument)this.doc, (int)clickOffset);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return line;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt == null) {
            return;
        }
        String id = evt.getPropertyName();
        if ("component".equals(id) && evt.getNewValue() == null) {
            this.release();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void insertUpdate(DocumentEvent e) {
        if (this.elementAnnotations != null) {
            Element[] elements = e.getDocument().getRootElements();
            Map map = this.elementAnnotations;
            synchronized (map) {
                for (int i = 0; i < elements.length; ++i) {
                    Element key;
                    Object recent;
                    Element[] added;
                    Element element = elements[i];
                    DocumentEvent.ElementChange change = e.getChange(element);
                    if (change == null) continue;
                    Element[] removed = change.getChildrenRemoved();
                    if (removed.length == (added = change.getChildrenAdded()).length) {
                        for (int c = 0; c < removed.length; ++c) {
                            recent = this.elementAnnotations.get(removed[c]);
                            if (recent == null) continue;
                            this.elementAnnotations.remove(removed[c]);
                            this.elementAnnotations.put(added[c], recent);
                        }
                        continue;
                    }
                    if (removed.length != 1 || added.length <= 0 || (recent = this.elementAnnotations.get(key = removed[0])) == null) continue;
                    this.elementAnnotations.remove(key);
                    this.elementAnnotations.put(added[0], recent);
                }
            }
        }
        this.repaint();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (e.getDocument().getLength() == 0) {
            this.hideBar();
        }
        this.repaint();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        assert (e.getSource() == this.caret);
        this.caretTimer.restart();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        assert (e.getSource() == this.caretTimer);
        this.onCurrentLine();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.revalidate();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    private static class CvsAnnotation
    extends Annotation {
        private final String text;
        private Line line;

        public CvsAnnotation(String tooltip, Line line) {
            this.text = tooltip;
            this.line = line;
        }

        public void attach() {
            this.attach((Annotatable)this.line);
            this.line = null;
        }

        public String getShortDescription() {
            return this.text;
        }

        public String getAnnotationType() {
            return "org-netbeans-modules-versioning-system-cvss-Annotation";
        }
    }
}

