/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ruby.platform.gems.GemFilesParser;
import org.netbeans.modules.ruby.platform.gems.Gems;
import org.netbeans.modules.ruby.rubyproject.GemRequirement;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.openide.util.Parameters;

public final class RequiredGems {
    public static final String REQUIRED_GEMS_PROPERTY = "required.gems";
    public static final String REQUIRED_GEMS_TESTS_PROPERTY = "required.gems.tests";
    private List<GemRequirement> requirements;
    private final List<URL> indexedGems = new ArrayList<URL>();
    private final boolean forTests;

    private RequiredGems(boolean forTests) {
        this.forTests = forTests;
    }

    public static RequiredGems create(RubyBaseProject project) {
        RequiredGems result = new RequiredGems(false);
        result.setRequiredGems(RequiredGems.fromString(project.evaluator().getProperty(REQUIRED_GEMS_PROPERTY)));
        return result;
    }

    public static RequiredGems createForTests(RubyBaseProject project) {
        RequiredGems result = new RequiredGems(true);
        result.setRequiredGems(RequiredGems.fromString(project.evaluator().getProperty(REQUIRED_GEMS_TESTS_PROPERTY)));
        return result;
    }

    public static RequiredGems[] lookup(Project project) {
        Collection reqGems = project.getLookup().lookupAll(RequiredGems.class);
        assert (reqGems.size() == 2);
        RequiredGems rg = null;
        RequiredGems rgTest = null;
        for (RequiredGems each : reqGems) {
            if (each.isForTests()) {
                rgTest = each;
                continue;
            }
            rg = each;
        }
        return new RequiredGems[]{rg, rgTest};
    }

    public boolean isForTests() {
        return this.forTests;
    }

    public synchronized List<GemRequirement> getGemRequirements() {
        if (this.requirements == null) {
            return null;
        }
        List<GemRequirement> result = RequiredGems.mergeVersions(this.requirements);
        Collections.sort(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequirements(Collection<GemRequirement> gemRequirements) {
        Parameters.notNull((CharSequence)"gemRequirements", gemRequirements);
        RequiredGems requiredGems = this;
        synchronized (requiredGems) {
            if (this.requirements == null) {
                this.requirements = new ArrayList<GemRequirement>();
                for (GemIndexingStatus status : this.getGemIndexingStatuses()) {
                    this.requirements.add(status.getRequirement());
                }
            }
            for (GemRequirement each : gemRequirements) {
                if (this.requirements.contains(each)) continue;
                this.requirements.add(each);
            }
        }
    }

    public static String asString(List<GemRequirement> requirements) {
        if (requirements == null || requirements.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        Iterator<GemRequirement> it = requirements.iterator();
        while (it.hasNext()) {
            GemRequirement gemRequirement = it.next();
            result.append(gemRequirement.asString());
            if (!it.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public synchronized void setRequiredGems(List<GemRequirement> requirements) {
        this.requirements = requirements == null ? null : new ArrayList<GemRequirement>(requirements);
    }

    public void setRequiredGems(String requirements) {
        this.setRequiredGems(RequiredGems.fromString(requirements));
    }

    public synchronized List<URL> getIndexedGems() {
        return Collections.unmodifiableList(this.indexedGems);
    }

    public synchronized void setIndexedGems(Collection<URL> gemUrls) {
        Parameters.notNull((CharSequence)"gemUrls", gemUrls);
        this.indexedGems.clear();
        this.indexedGems.addAll(gemUrls);
    }

    public synchronized Collection<URL> filterNotRequiredGems(Collection<URL> gemUrls) {
        if (this.requirements == null && this.forTests) {
            return gemUrls;
        }
        ArrayList<URL> result = new ArrayList<URL>();
        block0: for (URL url : gemUrls) {
            String[] nameAndVersion = GemFilesParser.parseNameAndVersion((URL)url);
            if (nameAndVersion == null) continue;
            String name = nameAndVersion[0];
            String version = nameAndVersion[1];
            if (RequiredGems.isRailsOrRake(name)) {
                result.add(url);
                continue;
            }
            if (this.requirements == null && !this.forTests) {
                if (Gems.isTestingGem((String)name)) continue;
                result.add(url);
                continue;
            }
            for (GemRequirement each : this.requirements) {
                if (!each.getName().equals(name) || !each.satisfiedBy(version)) continue;
                result.add(url);
                continue block0;
            }
        }
        return result;
    }

    public synchronized List<GemIndexingStatus> getGemIndexingStatuses() {
        boolean addAll = this.requirements == null;
        ArrayList<GemRequirement> requirementsCopy = new ArrayList<GemRequirement>();
        if (this.requirements != null) {
            requirementsCopy.addAll(this.requirements);
        }
        ArrayList<GemIndexingStatus> result = new ArrayList<GemIndexingStatus>();
        for (URL gemUrl : this.indexedGems) {
            String[] nameAndVersion = GemFilesParser.parseNameAndVersion((URL)gemUrl);
            if (nameAndVersion == null) continue;
            boolean added = false;
            String name = nameAndVersion[0];
            String version = nameAndVersion[1];
            if (addAll) {
                result.add(new GemIndexingStatus(new GemRequirement(name, null, null, GemRequirement.Status.INSTALLED), version));
                added = true;
            } else {
                Iterator it = requirementsCopy.iterator();
                while (it.hasNext()) {
                    GemRequirement req = (GemRequirement)it.next();
                    if (!req.getName().equals(name)) continue;
                    result.add(new GemIndexingStatus(req, version));
                    it.remove();
                    added = true;
                    break;
                }
            }
            if (added) continue;
            result.add(new GemIndexingStatus(new GemRequirement(name, null, null, GemRequirement.Status.NOT_INSTALLED), version));
        }
        if (!addAll) {
            for (GemRequirement req : requirementsCopy) {
                result.add(new GemIndexingStatus(req, null));
            }
        }
        Collections.sort(result, new Comparator<GemIndexingStatus>(){

            @Override
            public int compare(GemIndexingStatus o1, GemIndexingStatus o2) {
                return o1.getRequirement().compareTo(o2.getRequirement());
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRequirement(String name) {
        ArrayList<GemIndexingStatus> statuses = new ArrayList<GemIndexingStatus>(this.getGemIndexingStatuses());
        RequiredGems requiredGems = this;
        synchronized (requiredGems) {
            if (this.requirements == null) {
                ArrayList<GemRequirement> newReqs = new ArrayList<GemRequirement>();
                for (GemIndexingStatus each : statuses) {
                    if (each.getRequirement().getName().equals(name)) continue;
                    newReqs.add(each.getRequirement());
                }
                if (newReqs.size() < statuses.size()) {
                    this.setRequiredGems(newReqs);
                }
            } else {
                Iterator<GemRequirement> it = this.requirements.iterator();
                while (it.hasNext()) {
                    GemRequirement each = it.next();
                    if (!each.getName().equals(name)) continue;
                    it.remove();
                }
            }
        }
    }

    static List<GemRequirement> fromString(String str) {
        if (str == null) {
            return null;
        }
        String[] gems = str.split(",");
        ArrayList<GemRequirement> result = new ArrayList<GemRequirement>();
        for (String gem : gems) {
            GemRequirement requirement = GemRequirement.fromString(gem.trim());
            if (result.contains(requirement)) continue;
            result.add(requirement);
        }
        return result;
    }

    private static boolean isRailsOrRake(String name) {
        return Gems.isRailsGem((String)name) || Gems.isRakeGem((String)name);
    }

    private static List<GemRequirement> mergeVersions(List<GemRequirement> requirements) {
        HashMap<String, GemRequirement> map = new HashMap<String, GemRequirement>();
        for (GemRequirement each : requirements) {
            GemRequirement existing = (GemRequirement)map.get(each.getName());
            if (existing != null) {
                if (existing.compareTo(each) >= 0) continue;
                map.put(each.getName(), each);
                continue;
            }
            map.put(each.getName(), each);
        }
        return new ArrayList<GemRequirement>(map.values());
    }

    public static final class GemIndexingStatus {
        private final GemRequirement requirement;
        private final String indexedVersion;

        private GemIndexingStatus(GemRequirement requirement, String indexedVersion) {
            this.requirement = requirement;
            this.indexedVersion = indexedVersion;
        }

        public String getIndexedVersion() {
            return this.indexedVersion;
        }

        public GemRequirement getRequirement() {
            return this.requirement;
        }
    }
}

