/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.awt.Dialog;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.RubyProcessCreator;
import org.netbeans.modules.ruby.rubyproject.RubyBaseActionProvider;
import org.netbeans.modules.ruby.rubyproject.RunFilePanel;
import org.netbeans.spi.project.ActionProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class RunFileActionProvider
implements ActionProvider {
    private static final Map<File, RunFileArgs> ARGS_FOR_FILE = new HashMap<File, RunFileArgs>();

    public String[] getSupportedActions() {
        return new String[]{"run.single", "debug.single"};
    }

    public void invokeAction(String command, Lookup context) throws IllegalArgumentException {
        boolean debug = "debug.single".equals(command);
        for (DataObject d : context.lookupAll(DataObject.class)) {
            File f = FileUtil.toFile((FileObject)d.getPrimaryFile());
            if (f == null) continue;
            RubyBaseActionProvider.saveFile(d.getPrimaryFile());
            this.runFile(f, debug);
        }
    }

    static RunFileArgs getRunArgs(File file) {
        return ARGS_FOR_FILE.get(file);
    }

    static RunFileArgs showDialog(RunFileArgs presetArgs, File file, boolean debug, boolean allowPlatformChange) {
        Object[] options = new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION};
        RunFilePanel panel = new RunFilePanel(presetArgs, allowPlatformChange);
        String key = debug ? "DebugFile" : "RunFile";
        DialogDescriptor descriptor = new DialogDescriptor((Object)panel, NbBundle.getMessage(RunFileActionProvider.class, (String)key, (Object)file.getName()), true, options, DialogDescriptor.OK_OPTION, 0, null, null);
        descriptor.setClosingOptions(new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.setVisible(true);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunFileActionProvider.class, (String)(debug ? "ACSD_DebugFile" : "ACSD_RunFile"), (Object)file.getName()));
        if (descriptor.getValue() == DialogDescriptor.OK_OPTION) {
            RunFileArgs runFileArgs = panel.getArgs();
            ARGS_FOR_FILE.put(file, runFileArgs);
            return runFileArgs;
        }
        return null;
    }

    private void runFile(File file, boolean debug) {
        RunFileArgs runFileArgs;
        RunFileArgs existing = ARGS_FOR_FILE.get(file);
        if (existing != null && !existing.displayDialog) {
            this.doRun(file, existing, debug);
            return;
        }
        if (existing == null) {
            existing = new RunFileArgs(null, null, null, null, file.getParent(), true);
        }
        if ((runFileArgs = RunFileActionProvider.showDialog(existing, file, debug, true)) == null) {
            return;
        }
        this.doRun(file, runFileArgs, debug);
    }

    private void doRun(File file, RunFileArgs runFileArgs, boolean debug) {
        File workDir = new File(runFileArgs.getWorkDir());
        RubyExecutionDescriptor desc = new RubyExecutionDescriptor(runFileArgs.getPlatform(), file.getName(), workDir);
        if (runFileArgs.getRunArgs() != null) {
            desc.additionalArgs(Utilities.parseParameters((String)runFileArgs.getRunArgs()));
        }
        desc.jvmArguments(runFileArgs.getJvmArgs());
        desc.initialArgs(runFileArgs.getRubyOpts());
        desc.debug(debug);
        desc.script(file.getAbsolutePath());
        RubyProcessCreator rpc = new RubyProcessCreator(desc);
        if (rpc.isAbleToCreateProcess()) {
            ExecutionService.newService((Callable)rpc, (ExecutionDescriptor)desc.toExecutionDescriptor(), (String)file.getName()).run();
        }
    }

    public boolean isActionEnabled(String command, Lookup context) throws IllegalArgumentException {
        Project p = (Project)context.lookup(Project.class);
        if (p != null) {
            return false;
        }
        Collection files = context.lookupAll(DataObject.class);
        if (files.isEmpty()) {
            return false;
        }
        for (DataObject d : files) {
            if (d.getPrimaryFile().getMIMEType().equals("text/x-ruby")) continue;
            return false;
        }
        return true;
    }

    static final class RunFileArgs {
        private final RubyPlatform platform;
        private final String runArgs;
        private final String jvmArgs;
        private final String rubyOpts;
        private final String workDir;
        private final boolean displayDialog;

        public RunFileArgs(RubyPlatform platform, String runArgs, String jvmArgs, String rubyOpts, String workDir, boolean displayDialog) {
            this.platform = platform;
            this.runArgs = runArgs;
            this.jvmArgs = jvmArgs;
            this.rubyOpts = rubyOpts;
            this.workDir = workDir;
            this.displayDialog = displayDialog;
        }

        public String getJvmArgs() {
            return this.jvmArgs;
        }

        public RubyPlatform getPlatform() {
            return this.platform;
        }

        public String getRunArgs() {
            return this.runArgs;
        }

        public boolean displayDialog() {
            return this.displayDialog;
        }

        public String getRubyOpts() {
            return this.rubyOpts;
        }

        public String getWorkDir() {
            return this.workDir;
        }
    }
}

