/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.ui;

import java.awt.Image;
import java.util.Collections;
import javax.swing.Action;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.ui.PlatformNode;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public final class LibrariesNode
extends AbstractNode {
    private static final Image LIBRARIES_ICON_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/ruby/rubyproject/resources/libraries-badge.png");
    private static Image folderIconCache;
    private static Image openedFolderIconCache;

    public LibrariesNode(RubyBaseProject project) {
        super((Children)new LibrariesChildren(project));
    }

    public String getDisplayName() {
        return NbBundle.getMessage(LibrariesNode.class, (String)"LibrariesNode.Libraries");
    }

    public Action[] getActions(boolean context) {
        return new Action[0];
    }

    public Image getIcon(int type) {
        return this.computeIcon(false, type);
    }

    public Image getOpenedIcon(int type) {
        return this.computeIcon(true, type);
    }

    private Image computeIcon(boolean opened, int type) {
        Image image = LibrariesNode.getFolderIcon(opened);
        image = ImageUtilities.mergeImages((Image)image, (Image)LIBRARIES_ICON_BADGE, (int)7, (int)7);
        return image;
    }

    static synchronized Image getFolderIcon(boolean opened) {
        if (opened) {
            if (openedFolderIconCache == null) {
                openedFolderIconCache = LibrariesNode.getTreeFolderIcon(opened);
            }
            return openedFolderIconCache;
        }
        if (folderIconCache == null) {
            folderIconCache = LibrariesNode.getTreeFolderIcon(opened);
        }
        return folderIconCache;
    }

    private static Image getTreeFolderIcon(boolean opened) {
        Image base;
        Node n = DataFolder.findFolder((FileObject)FileUtil.getConfigRoot()).getNodeDelegate();
        Image image = base = opened ? n.getOpenedIcon(1) : n.getIcon(1);
        assert (base != null);
        return base;
    }

    private static final class LibrariesChildren
    extends Children.Keys<Object> {
        private final RubyBaseProject project;

        LibrariesChildren(RubyBaseProject project) {
            this.project = project;
        }

        protected void addNotify() {
            this.setKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
        }

        protected Node[] createNodes(Object key) {
            return new Node[]{new PlatformNode(this.project)};
        }

        private void setKeys() {
            RubyPlatform platform = this.project.getPlatform();
            assert (platform != null) : "platform cannot be null";
            this.setKeys(Collections.singleton(platform));
        }
    }
}

