/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.ui;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.ruby.rubyproject.RubyProject;
import org.netbeans.modules.ruby.rubyproject.rake.RakeSupport;
import org.netbeans.modules.ruby.rubyproject.ui.LibrariesNode;
import org.netbeans.modules.ruby.rubyproject.ui.TreeRootNode;
import org.netbeans.modules.ruby.rubyproject.ui.customizer.CustomizerProviderImpl;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.actions.FileSystemAction;
import org.openide.actions.FindAction;
import org.openide.actions.PasteAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;

public final class ProjectRootNodeFactory
implements NodeFactory {
    private static final Logger LOGGER = Logger.getLogger(ProjectRootNodeFactory.class.getName());

    public NodeList createNodes(Project p) {
        RubyProject project = (RubyProject)p.getLookup().lookup(RubyProject.class);
        assert (project != null);
        return new RootChildren(project);
    }

    private static class PreselectPropertiesAction
    extends AbstractAction {
        private final Project project;
        private final String nodeName;
        private final String panelName;

        PreselectPropertiesAction(Project project, String nodeName) {
            this(project, nodeName, null);
        }

        PreselectPropertiesAction(Project project, String nodeName, String panelName) {
            super(NbBundle.getMessage(ProjectRootNodeFactory.class, (String)"LBL_Properties_Action"));
            this.project = project;
            this.nodeName = nodeName;
            this.panelName = panelName;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CustomizerProviderImpl cp = (CustomizerProviderImpl)this.project.getLookup().lookup(CustomizerProviderImpl.class);
            if (cp != null) {
                cp.showCustomizer(this.nodeName, this.panelName);
            }
        }
    }

    private static class FolderViewFilterNode
    extends FilterNode {
        protected String nodeName;
        private final Project project;
        private Action[] actions;

        FolderViewFilterNode(SourceGroup sourceGroup, Project project) {
            super(FolderViewFilterNode.getOriginalNode(sourceGroup));
            this.project = project;
            this.nodeName = "Sources";
        }

        private static Node getOriginalNode(SourceGroup group) {
            if (group == null) {
                return new AbstractNode(FilterNode.Children.LEAF);
            }
            FileObject root = group.getRootFolder();
            if (root == null || !root.isValid()) {
                return new AbstractNode(FilterNode.Children.LEAF);
            }
            return new TreeRootNode(group);
        }

        public Action[] getActions(boolean context) {
            if (this.actions == null) {
                this.actions = new Action[]{CommonProjectActions.newFileAction(), null, SystemAction.get(FileSystemAction.class), null, SystemAction.get(FindAction.class), null, SystemAction.get(PasteAction.class), null, SystemAction.get(ToolsAction.class), null, new PreselectPropertiesAction(this.project, this.nodeName)};
            }
            return this.actions;
        }
    }

    private static class RootChildNode {
        private final SourceGroup group;
        private final FileObject fileObject;
        private final boolean libraryNode;

        private RootChildNode(SourceGroup group, FileObject fileObject, boolean libraryNode) {
            this.group = group;
            this.fileObject = fileObject;
            this.libraryNode = libraryNode;
        }

        private RootChildNode(SourceGroup group, FileObject fileObject) {
            this(group, fileObject, false);
        }

        static RootChildNode group(SourceGroup group) {
            return new RootChildNode(group, group.getRootFolder());
        }

        static RootChildNode fileObject(FileObject fileObject) {
            return new RootChildNode(null, fileObject);
        }

        static RootChildNode libraries() {
            return new RootChildNode(null, null, true);
        }

        public int hashCode() {
            if (this.libraryNode) {
                return 0;
            }
            return this.fileObject.hashCode();
        }

        public boolean equals(Object obj) {
            String otherDisplayName;
            if (!(obj instanceof RootChildNode)) {
                return false;
            }
            RootChildNode otherKey = (RootChildNode)obj;
            if (this.libraryNode || otherKey.libraryNode) {
                return this.libraryNode && otherKey.libraryNode;
            }
            String thisDisplayName = this.group == null ? null : this.group.getDisplayName();
            String string = otherDisplayName = otherKey.group == null ? null : otherKey.group.getDisplayName();
            return this.fileObject.equals(otherKey.fileObject) && (thisDisplayName == null ? otherDisplayName == null : thisDisplayName.equals(otherDisplayName));
        }

        public String toString() {
            return "ProjectRootNodeFactory[fileObject: " + this.fileObject + ", group: " + this.group + ", libraryNode: " + this.libraryNode + ']';
        }
    }

    private static class RootChildren
    implements NodeList<RootChildNode>,
    ChangeListener {
        private final FileChangeListener rootFOListener = new RootFileChangeListener();
        private final RubyProject project;
        private final List<ChangeListener> changeListeners;

        public RootChildren(RubyProject proj) {
            FileObject prjRoot = proj.getProjectDirectory();
            prjRoot.addFileChangeListener((FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)this.rootFOListener, (Object)prjRoot));
            this.changeListeners = new CopyOnWriteArrayList<ChangeListener>();
            this.project = proj;
        }

        public List<RootChildNode> keys() {
            if (this.project.getProjectDirectory() == null || !this.project.getProjectDirectory().isValid()) {
                return Collections.emptyList();
            }
            Sources sources = this.getSources();
            SourceGroup[] groups = sources.getSourceGroups("ruby");
            ArrayList<RootChildNode> result = new ArrayList<RootChildNode>();
            for (int i = 0; i < groups.length; ++i) {
                result.add(RootChildNode.group(groups[i]));
            }
            result.add(RootChildNode.libraries());
            result.addAll(this.getRootFiles());
            return result;
        }

        private List<? extends RootChildNode> getRootFiles() {
            FileObject rootDir = this.project.getProjectDirectory();
            ArrayList<RootChildNode> rootFiles = new ArrayList<RootChildNode>();
            FileObject rakeFile = RakeSupport.findRakeFile(this.project);
            if (rakeFile != null && rootDir.equals(rakeFile.getParent())) {
                rootFiles.add(RootChildNode.fileObject(rakeFile));
            }
            FileObject[] children = rootDir.getChildren();
            Comparator<FileObject> c = new Comparator<FileObject>(){

                @Override
                public int compare(FileObject f1, FileObject f2) {
                    return f1.getNameExt().toLowerCase().compareTo(f2.getNameExt().toLowerCase());
                }
            };
            Arrays.sort(children, c);
            for (FileObject rootChild : children) {
                if (rootChild.isFolder() || RakeSupport.isMainRakeFile(rootChild)) continue;
                rootFiles.add(RootChildNode.fileObject(rootChild));
            }
            return rootFiles;
        }

        public void addChangeListener(ChangeListener l) {
            this.changeListeners.add(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.changeListeners.remove(l);
        }

        private void fireChange() {
            for (ChangeListener changeListener : this.changeListeners) {
                changeListener.stateChanged(new ChangeEvent(this));
            }
        }

        public Node node(RootChildNode key) {
            if (key.libraryNode) {
                return new LibrariesNode(this.project);
            }
            if (key.group != null) {
                return new FolderViewFilterNode(key.group, this.project);
            }
            if (key.fileObject != null) {
                try {
                    if (RakeSupport.isRakeFile(key.fileObject)) {
                        return new RakeSupport.RakeNode(key.fileObject);
                    }
                    if (!key.fileObject.isValid()) {
                        LOGGER.info("Invalid FO, skipping node: " + key.fileObject.getPath());
                        return null;
                    }
                    DataObject dobj = DataObject.find((FileObject)key.fileObject);
                    return new FilterNode(dobj.getNodeDelegate());
                }
                catch (DataObjectNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return null;
                }
            }
            throw new AssertionError((Object)("Unknown/Invalid key: " + key));
        }

        public void addNotify() {
            this.getSources().addChangeListener((ChangeListener)this);
        }

        public void removeNotify() {
            this.getSources().removeChangeListener((ChangeListener)this);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RootChildren.this.fireChange();
                }
            });
        }

        private Sources getSources() {
            return ProjectUtils.getSources((Project)this.project);
        }

        final class RootFileChangeListener
        extends FileChangeAdapter {
            RootFileChangeListener() {
            }

            public void fileFolderCreated(FileEvent fe) {
                RootChildren.this.stateChanged(null);
            }

            public void fileDataCreated(FileEvent fe) {
                RootChildren.this.stateChanged(null);
            }

            public void fileDeleted(FileEvent fe) {
                RootChildren.this.stateChanged(null);
            }

            public void fileRenamed(FileRenameEvent fe) {
                RootChildren.this.stateChanged(null);
            }
        }
    }
}

