/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.project.ui.PhysicalView;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;

public class BrowseFolders
extends JPanel
implements ExplorerManager.Provider {
    private ExplorerManager manager;
    private SourceGroup[] folders;
    private BeanTreeView btv;
    private Project project;
    private static JScrollPane SAMPLE_SCROLL_PANE = new JScrollPane();
    private JPanel folderPanel;
    private JLabel jLabel1;

    public BrowseFolders(SourceGroup[] folders, Project project, String preselectedFileName) {
        this.initComponents();
        this.folders = folders;
        this.project = project;
        this.manager = new ExplorerManager();
        AbstractNode rootNode = new AbstractNode((Children)new SourceGroupsChildren(folders, project));
        this.manager.setRootContext((Node)rootNode);
        this.btv = new BeanTreeView();
        this.btv.setRootVisible(false);
        this.btv.setSelectionMode(1);
        this.btv.setBorder(SAMPLE_SCROLL_PANE.getBorder());
        this.btv.setPopupAllowed(false);
        this.btv.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BrowseFolders.class, (String)"ACSN_BrowseFolders_folderPanel"));
        this.btv.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrowseFolders.class, (String)"ACSD_BrowseFolders_folderPanel"));
        this.expandSelection(preselectedFileName);
        this.folderPanel.add((Component)this.btv, "Center");
        this.jLabel1.setLabelFor(this.btv.getViewport().getView());
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.folderPanel = new JPanel();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(BrowseFolders.class, (String)"LBL_BrowseFolders_jLabel1"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BrowseFolders.class, (String)"ACSN_BrowseFolders_jLabel1"));
        this.folderPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.folderPanel, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BrowseFolders.class, (String)"ACSN_BrowseFolders"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrowseFolders.class, (String)"ACSN_BrowseFolders"));
    }

    public static FileObject showDialog(SourceGroup[] folders, Project project, String preselectedFileName) {
        BrowseFolders bf = new BrowseFolders(folders, project, preselectedFileName);
        Object[] options = new JButton[]{new JButton(), new JButton(NbBundle.getMessage(BrowseFolders.class, (String)"BTN_BrowseFolders_Cancel_Option"))};
        OptionsListener optionsListener = new OptionsListener(bf);
        options[0].setActionCommand("SELECT");
        options[0].addActionListener(optionsListener);
        Mnemonics.setLocalizedText((AbstractButton)options[0], (String)NbBundle.getMessage(BrowseFolders.class, (String)"BTN_BrowseFolders_Select_Option"));
        options[0].getAccessibleContext().setAccessibleName(NbBundle.getMessage(BrowseFolders.class, (String)"ACSN_BrowseFolders_Select_Option"));
        options[0].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrowseFolders.class, (String)"ACSD_BrowseFolders_Select_Option"));
        options[1].setActionCommand("CANCEL");
        options[1].addActionListener(optionsListener);
        options[1].getAccessibleContext().setAccessibleName(NbBundle.getMessage(BrowseFolders.class, (String)"ACSN_BrowseFolders_Cancel_Option"));
        options[1].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrowseFolders.class, (String)"ACSD_BrowseFolders_Cancel_Option"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)bf, NbBundle.getMessage(BrowseFolders.class, (String)"LBL_BrowseFolders_Dialog"), true, options, (Object)options[0], 0, null, null);
        dialogDescriptor.setClosingOptions(new Object[]{options[0], options[1]});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        return optionsListener.getResult();
    }

    private void expandSelection(String preselectedFileName) {
        int i;
        Node root = this.manager.getRootContext();
        Children ch = root.getChildren();
        if (ch == Children.LEAF) {
            return;
        }
        Node[] nodes = ch.getNodes(true);
        Node sel = null;
        if (preselectedFileName != null && preselectedFileName.length() > 0) {
            for (i = 0; i < nodes.length; ++i) {
                try {
                    sel = NodeOp.findPath((Node)nodes[i], (Enumeration)NbCollections.checkedEnumerationByFilter((Enumeration)new StringTokenizer(preselectedFileName, "/"), String.class, (boolean)true));
                    break;
                }
                catch (NodeNotFoundException e) {
                    System.out.println(e.getMissingChildName());
                    continue;
                }
            }
        }
        if (sel == null) {
            this.btv.expandNode(root);
            for (i = 0; i < nodes.length; ++i) {
                this.btv.expandNode(nodes[i]);
                if (i != 0) continue;
                sel = nodes[i];
            }
        }
        if (sel != null) {
            try {
                this.manager.setSelectedNodes(new Node[]{sel});
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
        }
    }

    private static final class OptionsListener
    implements ActionListener {
        public static final String COMMAND_SELECT = "SELECT";
        public static final String COMMAND_CANCEL = "CANCEL";
        private BrowseFolders browsePanel;
        private FileObject result;

        public OptionsListener(BrowseFolders browsePanel) {
            this.browsePanel = browsePanel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileObject fo;
            DataObject dobj;
            Node[] selection;
            String command = e.getActionCommand();
            if (COMMAND_SELECT.equals(command) && (selection = this.browsePanel.getExplorerManager().getSelectedNodes()) != null && selection.length > 0 && (dobj = (DataObject)selection[0].getLookup().lookup(DataObject.class)) != null && (fo = dobj.getPrimaryFile()).isFolder()) {
                this.result = fo;
            }
        }

        public FileObject getResult() {
            return this.result;
        }
    }

    private static final class SourceGroupChildren
    extends Children.Keys<FileObject> {
        private final SourceGroup group;
        private final FileObject fo;

        public SourceGroupChildren(FileObject fo, SourceGroup group) {
            assert (fo != null);
            assert (group != null);
            this.fo = fo;
            this.group = group;
        }

        protected void addNotify() {
            super.addNotify();
            ArrayList<FileObject> l = new ArrayList<FileObject>();
            for (FileObject f : this.fo.getChildren()) {
                if (!f.isFolder() || !this.group.contains(f) || !VisibilityQuery.getDefault().isVisible(f)) continue;
                l.add(f);
            }
            Collections.sort(l, new Comparator<FileObject>(){
                Collator COLL = Collator.getInstance();

                @Override
                public int compare(FileObject f1, FileObject f2) {
                    return this.COLL.compare(f1.getNameExt(), f2.getNameExt());
                }
            });
            this.setKeys(l);
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
            super.removeNotify();
        }

        protected Node[] createNodes(FileObject folder) {
            FilterNode fn = new FilterNode(DataFolder.findFolder((FileObject)folder).getNodeDelegate(), (Children)new SourceGroupChildren(folder, this.group));
            return new Node[]{fn};
        }
    }

    private static final class SourceGroupsChildren
    extends Children.Keys<SourceGroup> {
        private final List<SourceGroup> groups;
        private final Project project;

        public SourceGroupsChildren(SourceGroup[] groups, Project project) {
            assert (groups != null);
            assert (project != null);
            this.groups = Arrays.asList(groups);
            assert (!this.groups.contains(null)) : this.groups;
            this.project = project;
        }

        protected void addNotify() {
            super.addNotify();
            this.setKeys(this.groups);
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
            super.removeNotify();
        }

        protected Node[] createNodes(SourceGroup g) {
            FileObject folder = g.getRootFolder();
            FilterNode fn = new FilterNode((Node)new PhysicalView.GroupNode(this.project, g, folder.equals(this.project.getProjectDirectory()), DataFolder.findFolder((FileObject)folder)), (Children)new SourceGroupChildren(folder, g));
            return new Node[]{fn};
        }
    }
}

