/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jackpot.spi.support;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.HintMetadata;
import org.netbeans.modules.java.hints.options.HintsSettings;
import org.netbeans.modules.java.hints.spi.support.FixFactory;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.EnhancedFix;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ErrorDescriptionFactory {
    private ErrorDescriptionFactory() {
    }

    public static ErrorDescription forTree(HintContext hintContext, TreePath treePath, String string, Fix ... fixArray) {
        return ErrorDescriptionFactory.forTree(hintContext, treePath.getLeaf(), string, fixArray);
    }

    public static ErrorDescription forTree(HintContext hintContext, Tree tree, String string, Fix ... fixArray) {
        int n = (int)hintContext.getInfo().getTrees().getSourcePositions().getStartPosition(hintContext.getInfo().getCompilationUnit(), tree);
        int n2 = (int)hintContext.getInfo().getTrees().getSourcePositions().getEndPosition(hintContext.getInfo().getCompilationUnit(), tree);
        if (n != -1 && n2 != -1) {
            List<Fix> list = ErrorDescriptionFactory.resolveDefaultFixes(hintContext, fixArray);
            return org.netbeans.spi.editor.hints.ErrorDescriptionFactory.createErrorDescription((Severity)hintContext.getSeverity().toEditorSeverity(), (String)string, list, (FileObject)hintContext.getInfo().getFileObject(), (int)n, (int)n2);
        }
        return null;
    }

    public static ErrorDescription forName(HintContext hintContext, TreePath treePath, String string, Fix ... fixArray) {
        return ErrorDescriptionFactory.forName(hintContext, treePath.getLeaf(), string, fixArray);
    }

    public static ErrorDescription forName(HintContext hintContext, Tree tree, String string, Fix ... fixArray) {
        int[] nArray = ErrorDescriptionFactory.computeNameSpan(tree, hintContext);
        if (nArray != null && nArray[0] != -1 && nArray[1] != -1) {
            List<Fix> list = ErrorDescriptionFactory.resolveDefaultFixes(hintContext, fixArray);
            return org.netbeans.spi.editor.hints.ErrorDescriptionFactory.createErrorDescription((Severity)hintContext.getSeverity().toEditorSeverity(), (String)string, list, (FileObject)hintContext.getInfo().getFileObject(), (int)nArray[0], (int)nArray[1]);
        }
        return null;
    }

    private static int[] computeNameSpan(Tree tree, HintContext hintContext) {
        switch (tree.getKind()) {
            case METHOD: {
                return hintContext.getInfo().getTreeUtilities().findNameSpan((MethodTree)tree);
            }
            case CLASS: {
                return hintContext.getInfo().getTreeUtilities().findNameSpan((ClassTree)tree);
            }
            case VARIABLE: {
                return hintContext.getInfo().getTreeUtilities().findNameSpan((VariableTree)tree);
            }
            case MEMBER_SELECT: {
                MemberSelectTree memberSelectTree = (MemberSelectTree)tree;
                int[] nArray = hintContext.getInfo().getTreeUtilities().findNameSpan(memberSelectTree);
                if (nArray == null) {
                    int n = (int)hintContext.getInfo().getTrees().getSourcePositions().getEndPosition(hintContext.getInfo().getCompilationUnit(), tree);
                    nArray = new int[]{n - memberSelectTree.getIdentifier().length(), n};
                }
                return nArray;
            }
            case METHOD_INVOCATION: {
                return ErrorDescriptionFactory.computeNameSpan(((MethodInvocationTree)tree).getMethodSelect(), hintContext);
            }
        }
        int n = (int)hintContext.getInfo().getTrees().getSourcePositions().getStartPosition(hintContext.getInfo().getCompilationUnit(), tree);
        if (StatementTree.class.isAssignableFrom(tree.getKind().asInterface()) && tree.getKind() != Tree.Kind.EXPRESSION_STATEMENT && tree.getKind() != Tree.Kind.BLOCK) {
            TokenSequence tokenSequence = hintContext.getInfo().getTokenHierarchy().tokenSequence();
            tokenSequence.move(n);
            if (tokenSequence.moveNext()) {
                return new int[]{tokenSequence.offset(), tokenSequence.offset() + tokenSequence.token().length()};
            }
        }
        return new int[]{n, (int)hintContext.getInfo().getTrees().getSourcePositions().getEndPosition(hintContext.getInfo().getCompilationUnit(), tree)};
    }

    public static List<Fix> resolveDefaultFixes(HintContext hintContext, Fix ... fixArray) {
        LinkedList<Fix> linkedList = new LinkedList<Fix>();
        if (hintContext.getHintMetadata() != null) {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            for (String fixArray2 : hintContext.getHintMetadata().suppressWarnings) {
                if (fixArray2 == null || fixArray2.length() == 0) break;
                linkedHashSet.add(fixArray2);
            }
            linkedList.add(new DisableConfigure(hintContext.getHintMetadata(), true));
            linkedList.add(new DisableConfigure(hintContext.getHintMetadata(), false));
            if (!linkedHashSet.isEmpty()) {
                linkedList.addAll(FixFactory.createSuppressWarnings(hintContext.getInfo(), hintContext.getPath(), linkedHashSet.toArray(new String[0])));
            }
            LinkedList linkedList2 = new LinkedList();
            for (Fix fix : fixArray != null ? fixArray : new Fix[]{}) {
                if (fix == null) continue;
                if (FixFactory.isSuppressWarningsFix(fix)) {
                    Logger.getLogger(ErrorDescriptionFactory.class.getName()).log(Level.FINE, "Eliminated SuppressWarnings fix");
                    continue;
                }
                linkedList2.add(org.netbeans.spi.editor.hints.ErrorDescriptionFactory.attachSubfixes((Fix)fix, linkedList));
            }
            if (linkedList2.isEmpty()) {
                linkedList2.add(org.netbeans.spi.editor.hints.ErrorDescriptionFactory.attachSubfixes((Fix)new TopLevelConfigureFix(hintContext.getHintMetadata()), linkedList));
            }
            return linkedList2;
        }
        return Arrays.asList(fixArray);
    }

    private static final class TopLevelConfigureFix
    extends DisableConfigure
    implements EnhancedFix {
        public TopLevelConfigureFix(@NonNull HintMetadata hintMetadata) {
            super(hintMetadata, false);
        }

        public CharSequence getSortText() {
            return "\uffffzz";
        }
    }

    private static class DisableConfigure
    implements Fix {
        @NonNull
        private final HintMetadata metadata;
        private final boolean disable;

        DisableConfigure(@NonNull HintMetadata hintMetadata, boolean bl) {
            this.metadata = hintMetadata;
            this.disable = bl;
        }

        public String getText() {
            String string;
            String string2 = this.metadata.displayName;
            switch (this.metadata.kind) {
                case HINT: 
                case HINT_NON_GUI: {
                    string = this.disable ? "FIX_DisableHint" : "FIX_ConfigureHint";
                    break;
                }
                case SUGGESTION: 
                case SUGGESTION_NON_GUI: {
                    string = this.disable ? "FIX_DisableSuggestion" : "FIX_ConfigureSuggestion";
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return NbBundle.getMessage(ErrorDescriptionFactory.class, (String)string, (Object)string2);
        }

        public ChangeInfo implement() throws Exception {
            if (this.disable) {
                HintsSettings.setEnabled(this.metadata, false);
            } else {
                OptionsDisplayer.getDefault().open("Editor/Hints/text/x-java/" + this.metadata.id);
            }
            return null;
        }
    }
}

