/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.completion.api;

import java.awt.Color;
import javax.swing.ImageIcon;
import org.netbeans.modules.web.core.syntax.completion.api.JspCompletionItem;
import org.openide.util.ImageUtilities;

public class ElCompletionItem {
    public static JspCompletionItem createELImplicitObject(String name, int substitutionOffset, int type) {
        return new ELImplicitObject(name, substitutionOffset, type);
    }

    public static JspCompletionItem createELBean(String name, int substitutionOffset, String type) {
        return new ELBean(name, substitutionOffset, type);
    }

    public static JspCompletionItem createELProperty(String name, String insertText, int substitutionOffset, String type) {
        return new ELProperty(name, insertText, substitutionOffset, type);
    }

    public static JspCompletionItem createELFunction(String name, int substitutionOffset, String type, String prefix, String parameters) {
        return new ELFunction(name, substitutionOffset, type, prefix, parameters);
    }

    public static class ELFunction
    extends ELBean {
        private static final String PREFIX_COLOR = ELFunction.hexColorCode(Color.blue.darker().darker());
        private static final String FUNCTION_NAME_COLOR = ELFunction.hexColorCode(Color.black);
        private static final String PARAMETER_COLOR = ELFunction.hexColorCode(Color.black);
        private static final String ICON_PATH = "org/netbeans/modules/web/core/syntax/completion/resources/function_16.png";
        private String prefix;
        private String parameters;

        public ELFunction(String name, int substitutionOffset, String type, String prefix, String parameters) {
            super(name, substitutionOffset, type);
            this.prefix = prefix;
            this.parameters = parameters;
        }

        @Override
        protected String getLeftHtmlText() {
            StringBuilder lText = new StringBuilder();
            lText.append("<font color=#" + PREFIX_COLOR + "><b>" + this.prefix + "</b></font>");
            lText.append("<font color=#" + FUNCTION_NAME_COLOR + "><b>" + ":" + this.getItemText() + "</b></font>");
            lText.append("<font color=#" + PARAMETER_COLOR + ">" + "(" + "</b></font>");
            if (this.parameters != null) {
                lText.append("<font color=#" + PARAMETER_COLOR + ">" + this.parameters + "</b></font>");
            }
            lText.append("<font color=#" + PARAMETER_COLOR + ">" + ")" + "</b></font>");
            return lText.toString();
        }

        @Override
        protected ImageIcon getIcon() {
            return ImageUtilities.loadImageIcon((String)ICON_PATH, (boolean)false);
        }

        @Override
        public int getSortPriority() {
            return 12;
        }

        @Override
        protected String getSubstituteText() {
            return this.prefix + ":" + super.getItemText() + "()";
        }

        @Override
        protected int getMoveBackLength() {
            return 1;
        }
    }

    public static class ELProperty
    extends ELBean {
        private static final String PROPERTY_NAME_COLOR = ELProperty.hexColorCode(Color.blue.darker().darker());
        private static final String PROPERTY_PATH = "org/netbeans/modules/web/core/syntax/completion/resources/property_16.png";
        private String myInsertText;

        public ELProperty(String text, int substitutionOffset, String type) {
            this(text, text, substitutionOffset, type);
        }

        public ELProperty(String text, String insertText, int substitutionOffset, String type) {
            super(text, substitutionOffset, type);
            this.myInsertText = insertText;
        }

        @Override
        protected String getSubstituteText() {
            return this.myInsertText;
        }

        @Override
        protected String getLeftHtmlText() {
            return "<font color=#" + PROPERTY_NAME_COLOR + ">" + this.getItemText() + "</font>";
        }

        @Override
        protected ImageIcon getIcon() {
            return ImageUtilities.loadImageIcon((String)PROPERTY_PATH, (boolean)false);
        }
    }

    public static class ELBean
    extends JspCompletionItem {
        private static final String BEAN_NAME_COLOR = ELBean.hexColorCode(Color.blue.darker().darker());
        private static final String BEAN_PATH = "org/netbeans/modules/web/core/syntax/completion/resources/bean_16.png";
        private String type;

        public ELBean(String text, int substitutionOffset, String type) {
            super(text, substitutionOffset);
            this.parseType(type);
        }

        private void parseType(String t) {
            int ltIndex = t.indexOf("<");
            String mainType = ltIndex == -1 ? t : t.substring(0, ltIndex);
            String genericType = ltIndex == -1 ? null : t.substring(ltIndex + 1);
            this.type = this.stripPackage(mainType) + (genericType != null ? "<" + this.stripPackage(genericType) : "");
            this.type = this.type.replace("<", "&lt;").replace(">", "&gt;");
        }

        private String stripPackage(String type) {
            int dotIndex = type.lastIndexOf(46);
            if (dotIndex >= 0) {
                type = type.substring(dotIndex + 1);
            }
            return type;
        }

        @Override
        public int getSortPriority() {
            return 10;
        }

        @Override
        protected String getLeftHtmlText() {
            return "<font color=#" + BEAN_NAME_COLOR + ">" + this.getItemText() + "</font>";
        }

        @Override
        protected String getRightHtmlText() {
            return this.type;
        }

        @Override
        protected ImageIcon getIcon() {
            return ImageUtilities.loadImageIcon((String)BEAN_PATH, (boolean)false);
        }
    }

    public static class ELImplicitObject
    extends JspCompletionItem {
        private static final String OBJECT_PATH = "org/netbeans/modules/web/core/syntax/completion/resources/class_16.png";
        private static final String MAP_PATH = "org/netbeans/modules/web/core/syntax/completion/resources/map_16.png";
        int type;

        ELImplicitObject(String text, int substitutionOffset, int type) {
            super(text, substitutionOffset);
            this.type = type;
        }

        @Override
        public int getSortPriority() {
            return 15;
        }

        @Override
        protected ImageIcon getIcon() {
            ImageIcon icon = null;
            switch (this.type) {
                case 0: {
                    icon = ImageUtilities.loadImageIcon((String)OBJECT_PATH, (boolean)false);
                    break;
                }
                case 1: {
                    icon = ImageUtilities.loadImageIcon((String)MAP_PATH, (boolean)false);
                }
            }
            return icon;
        }

        @Override
        protected String getLeftHtmlText() {
            return "<font color=#0000ff>" + this.getItemText() + "</font>";
        }

        @Override
        public String getItemText() {
            String result = this.text;
            if (this.type == 1) {
                result = result + "[]";
            }
            return result;
        }

        @Override
        protected int getMoveBackLength() {
            return this.type == 1 ? 1 : 0;
        }
    }
}

