/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.context;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Vector;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.loader.AdaptiveServletLoader;

public class LoaderInterceptor
extends BaseInterceptor {
    public void contextInit(Context context) throws TomcatException {
        ContextManager cm = context.getContextManager();
        AdaptiveServletLoader loader = new AdaptiveServletLoader();
        ClassLoader cl = cm.getParentClassLoader();
        if (cl == null) {
            loader.setParentLoader(this.getClass().getClassLoader());
        } else {
            loader.setParentLoader(cl);
        }
        context.setServletLoader(loader);
        String base = context.getDocBase();
        Object p = context.getPermissions();
        Object pd = context.getProtectionDomain();
        File dir = new File(String.valueOf(base) + "/WEB-INF/classes");
        dir = cm.getAbsolute(dir);
        if (dir.exists()) {
            loader.addRepository(dir, pd);
        }
        File f = cm.getAbsolute(new File(String.valueOf(base) + "/WEB-INF/lib"));
        Vector jars = new Vector();
        this.getJars(jars, f);
        int i = 0;
        while (i < jars.size()) {
            String jarfile = (String)jars.elementAt(i);
            File jarF = new File(f, jarfile);
            loader.addRepository(cm.getAbsolute(jarF), pd);
            ++i;
        }
    }

    private void getJars(Vector v, File f) {
        FilenameFilter jarfilter = new FilenameFilter(){

            public boolean accept(File dir, String fname) {
                return fname.endsWith(".jar");
            }
        };
        if (f.exists() && f.isDirectory() && f.isAbsolute()) {
            String[] jarlist = f.list(jarfilter);
            int i = 0;
            while (jarlist != null && i < jarlist.length) {
                v.addElement(jarlist[i]);
                ++i;
            }
        }
    }
}

