/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaCustomField;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaFlag;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxConfigurationContentHandler
extends DefaultHandler {
    private static final String ELEMENT_RESOLUTION = "resolution";
    private static final String ELEMENT_STATUS_OPEN = "status_open";
    private static final String ELEMENT_TARGET_MILESTONE = "target_milestone";
    private static final String ELEMENT_TARGET_MILESTONES = "target_milestones";
    private static final String ELEMENT_INSTALL_VERSION = "install_version";
    private static final String ELEMENT_DB_ENCODING = "db_encoding";
    private static final String ATTRIBUTE_RDF_ABOUT = "rdf:about";
    private static final String ATTRIBUTE_RESOURCE = "resource";
    private static final String ELEMENT_VERSION = "version";
    private static final String ELEMENT_VERSIONS = "versions";
    private static final String ELEMENT_COMPONENT = "component";
    private static final String ELEMENT_COMPONENTS = "components";
    private static final String ELEMENT_NAME = "name";
    private static final String ELEMENT_PRODUCTS = "products";
    private static final String ELEMENT_DESCRIPTION = "description";
    private static final String ELEMENT_FIELDS = "fields";
    private static final String ELEMENT_FIELD = "field";
    private static final String ELEMENT_FLAG_TYPES = "flag_types";
    private static final String ELEMENT_FLAG_TYPE = "flag_type";
    private static final String ELEMENT_SEVERITY = "severity";
    private static final String ELEMENT_PRIORITY = "priority";
    private static final String ELEMENT_KEYWORD = "keyword";
    private static final String ELEMENT_OP_SYS = "op_sys";
    private static final String ELEMENT_PLATFORM = "platform";
    private static final String ELEMENT_LI = "li";
    private static final String ELEMENT_STATUS = "status";
    private static final String ELEMENT_TYPE = "type";
    private static final String ELEMENT_ENTER_BUG = "enter_bug";
    private static final String ELEMENT_REQUESTABLE = "requestable";
    private static final String ELEMENT_SPECIFICALLY_REQUESTABLE = "specifically_requestable";
    private static final String ELEMENT_ID = "id";
    private static final String ELEMENT_MULTIPLICABLE = "multiplicable";
    private static final int EXPECTING_ROOT = 0;
    private static final int IN_INSTALL_VERSION = 2;
    private static final int IN_STATUS = 4;
    private static final int IN_PLATFORM = 8;
    private static final int IN_OP_SYS = 16;
    private static final int IN_PRIORITY = 32;
    private static final int IN_SEVERITY = 64;
    private static final int IN_PRODUCTS = 128;
    private static final int IN_COMPONENTS = 256;
    private static final int IN_VERSIONS = 512;
    private static final int IN_LI = 1024;
    private static final int IN_LI_LI = 2048;
    private static final int IN_NAME = 4096;
    private static final int IN_COMPONENT = 8192;
    private static final int IN_VERSION = 16384;
    private static final int IN_TARGET_MILESTONES = 32768;
    private static final int IN_TARGET_MILESTONE = 65536;
    private static final int IN_STATUS_OPEN = 131072;
    private static final int IN_RESOLUTION = 262144;
    private static final int IN_KEYWORD = 524288;
    private static final int IN_STATUS_CLOSED = 0x100000;
    private static final int IN_FIELDS = 0x200000;
    private static final int IN_FIELD = 0x400000;
    private static final int IN_CUSTOM_OPTION = 0x800000;
    private static final int IN_FLAG_TYPES = 0x1000000;
    private static final int IN_FLAG_TYPE = 0x2000000;
    private static final int IN_DB_ENCODING = 0x4000000;
    private int state = 0;
    private String currentProduct = "";
    private String currentName = "";
    private String currentDescription = "";
    private String currentType;
    private String currentRequestable;
    private String currentSpecifically_requestable;
    private String currentMultiplicable;
    private int currentId;
    private String currentEnterBug = "";
    private StringBuffer characters = new StringBuffer();
    private String about;
    private final RepositoryConfiguration configuration;
    private final Map<String, List<String>> components = new HashMap<String, List<String>>();
    private final Map<String, List<String>> versions = new HashMap<String, List<String>>();
    private final Map<String, List<String>> milestones = new HashMap<String, List<String>>();
    private final Map<String, String> componentNames = new HashMap<String, String>();
    private final Map<String, String> versionNames = new HashMap<String, String>();
    private final Map<String, String> milestoneNames = new HashMap<String, String>();
    private final Map<String, List<String>> customOption = new HashMap<String, List<String>>();
    private final Map<String, Map<String, List<String>>> flagsInComponent = new HashMap<String, Map<String, List<String>>>();
    private final Map<String, Integer> flagIds = new HashMap<String, Integer>();
    private String currentComponent = "";
    private String currentCustomOptionName = "";

    public SaxConfigurationContentHandler() {
        this.configuration = new RepositoryConfiguration();
    }

    public RepositoryConfiguration getConfiguration() {
        return this.configuration;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.characters.append(ch, start, length);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.characters = new StringBuffer();
        if (localName.equals(ELEMENT_STATUS)) {
            this.state |= 4;
        } else if (localName.equals(ELEMENT_LI) && (this.state & 0x400) == 1024) {
            this.state |= 0x800;
            this.parseResource(attributes);
        } else if (localName.equals(ELEMENT_LI) && (this.state & 0x400) != 1024) {
            this.state |= 0x400;
        } else if (localName.equals(ELEMENT_PLATFORM)) {
            this.state |= 8;
        } else if (localName.equals(ELEMENT_OP_SYS)) {
            this.state |= 0x10;
        } else if (localName.equals(ELEMENT_PRIORITY)) {
            this.state |= 0x20;
        } else if (localName.equals(ELEMENT_SEVERITY)) {
            this.state |= 0x40;
        } else if (localName.equals(ELEMENT_PRODUCTS)) {
            this.state |= 0x80;
        } else if (localName.equals(ELEMENT_OP_SYS)) {
            this.state |= 0x10;
        } else if (localName.equals(ELEMENT_NAME)) {
            this.state |= 0x1000;
        } else if (localName.equals(ELEMENT_COMPONENTS)) {
            this.state |= 0x100;
        } else if (localName.equals(ELEMENT_COMPONENT)) {
            this.state |= 0x2000;
            this.parseResource(attributes);
        } else if (localName.equals(ELEMENT_VERSIONS)) {
            this.state |= 0x200;
        } else if (localName.equals(ELEMENT_VERSION)) {
            this.state |= 0x4000;
            this.parseResource(attributes);
        } else if (localName.equals(ELEMENT_INSTALL_VERSION)) {
            this.state |= 2;
        } else if (localName.equals(ELEMENT_DB_ENCODING)) {
            this.state |= 0x4000000;
        } else if (localName.equals(ELEMENT_TARGET_MILESTONES)) {
            this.state |= 0x8000;
        } else if (localName.equals(ELEMENT_TARGET_MILESTONE)) {
            this.state |= 0x10000;
            this.parseResource(attributes);
        } else if (localName.equals(ELEMENT_STATUS_OPEN)) {
            this.state |= 0x20000;
        } else if (localName.equals(ELEMENT_RESOLUTION)) {
            this.state |= 0x40000;
        } else if (localName.equals(ELEMENT_KEYWORD)) {
            this.state |= 0x80000;
        } else if (localName.equals(ELEMENT_FIELDS)) {
            this.state |= 0x200000;
        } else if (localName.equals(ELEMENT_FIELD)) {
            this.state |= 0x400000;
            this.parseResource(attributes);
            this.currentName = "";
            this.currentDescription = "";
            this.currentType = "";
            this.currentEnterBug = "";
            this.currentId = -1;
        } else if (localName.equals(ELEMENT_FLAG_TYPES)) {
            this.state |= 0x1000000;
        } else if (localName.equals(ELEMENT_FLAG_TYPE)) {
            this.state |= 0x2000000;
            this.parseResource(attributes);
        } else if (localName.startsWith("cf_")) {
            this.state |= 0x800000;
            this.currentCustomOptionName = localName;
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals(ELEMENT_STATUS)) {
            this.state &= 0xFFFFFFFB;
        } else if (localName.equals(ELEMENT_LI) && (this.state & 0x800) == 2048) {
            this.state &= 0xFFFFF7FF;
        } else if (localName.equals(ELEMENT_LI) && (this.state & 0x800) != 2048) {
            this.state &= 0xFFFFFBFF;
            if (this.characters.length() == 0) {
                return;
            }
            if (this.state == 4) {
                this.configuration.addStatus(this.characters.toString());
            } else if (this.state == 131072) {
                this.configuration.addOpenStatusValue(this.characters.toString());
            } else if (this.state != 0x100000) {
                if (this.state == 262144) {
                    this.configuration.addResolution(this.characters.toString());
                } else if (this.state == 524288) {
                    this.configuration.addKeyword(this.characters.toString());
                } else if (this.state == 8) {
                    this.configuration.addPlatform(this.characters.toString());
                } else if (this.state == 16) {
                    this.configuration.addOS(this.characters.toString());
                } else if (this.state == 32) {
                    this.configuration.addPriority(this.characters.toString());
                } else if (this.state == 64) {
                    this.configuration.addSeverity(this.characters.toString());
                } else if (this.state == 0x800000 && this.currentCustomOptionName != null && this.characters.length() > 0) {
                    List<String> customOptionList = this.customOption.get(this.currentCustomOptionName);
                    if (customOptionList == null) {
                        customOptionList = new ArrayList<String>();
                        this.customOption.put(this.currentCustomOptionName, customOptionList);
                    }
                    customOptionList.add(this.characters.toString());
                }
            }
        } else if (localName.equals(ELEMENT_PLATFORM)) {
            this.state &= 0xFFFFFFF7;
        } else if (localName.equals(ELEMENT_OP_SYS)) {
            this.state &= 0xFFFFFFEF;
        } else if (localName.equals(ELEMENT_PRIORITY)) {
            this.state &= 0xFFFFFFDF;
        } else if (localName.equals(ELEMENT_SEVERITY)) {
            this.state &= 0xFFFFFFBF;
        } else if (localName.equals(ELEMENT_PRODUCTS)) {
            this.state &= 0xFFFFFF7F;
        } else if (localName.equals(ELEMENT_OP_SYS)) {
            this.state &= 0xFFFFFFEF;
        } else if (localName.equals(ELEMENT_NAME)) {
            this.state &= 0xFFFFEFFF;
            if (this.state == 1152) {
                this.currentProduct = this.characters.toString();
                this.configuration.addProduct(this.currentProduct);
            } else if (this.state == 17920) {
                if (this.about != null && !this.versionNames.containsValue(this.about) && this.characters.length() > 0) {
                    this.versionNames.put(this.about, this.characters.toString());
                }
            } else if (this.state == 9472) {
                this.currentComponent = this.characters.toString();
                if (this.about != null && !this.componentNames.containsValue(this.about) && this.currentComponent.length() > 0) {
                    this.componentNames.put(this.about, this.currentComponent);
                }
            } else if (this.state == 99328) {
                if (this.about != null && !this.milestoneNames.containsValue(this.about) && this.characters.length() > 0) {
                    this.milestoneNames.put(this.about, this.characters.toString());
                }
            } else if (this.state == 0x600400 || this.state == 0x3000400) {
                this.currentName = this.characters.toString();
            }
        } else if (localName.equals(ELEMENT_COMPONENTS)) {
            this.state &= 0xFFFFFEFF;
        } else if (localName.equals(ELEMENT_COMPONENT)) {
            this.state &= 0xFFFFDFFF;
        } else if (localName.equals(ELEMENT_VERSION)) {
            this.state &= 0xFFFFBFFF;
        } else if (localName.equals(ELEMENT_VERSIONS)) {
            this.state &= 0xFFFFFDFF;
        } else if (localName.equals(ELEMENT_INSTALL_VERSION)) {
            this.state &= 0xFFFFFFFD;
            this.configuration.setInstallVersion(this.characters.toString());
        } else if (localName.equals(ELEMENT_DB_ENCODING)) {
            this.state &= 0xFBFFFFFF;
            String charsetString = this.characters.toString().trim();
            if (charsetString.length() > 0) {
                try {
                    Charset.forName(charsetString);
                    this.configuration.setEncoding(charsetString);
                }
                catch (Exception exception) {
                    StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.bugzilla", "Unrecognized encoding in configuration: " + charsetString));
                }
            }
        } else if (localName.equals(ELEMENT_TARGET_MILESTONE)) {
            this.state &= 0xFFFEFFFF;
        } else if (localName.equals(ELEMENT_TARGET_MILESTONES)) {
            this.state &= 0xFFFF7FFF;
        } else if (localName.equals(ELEMENT_STATUS_OPEN)) {
            this.state &= 0xFFFDFFFF;
        } else if (localName.equals(ELEMENT_RESOLUTION)) {
            this.state &= 0xFFFBFFFF;
        } else if (localName.equals(ELEMENT_KEYWORD)) {
            this.state &= 0xFFF7FFFF;
        } else if (localName.equals(ELEMENT_FIELDS)) {
            this.state &= 0xFFDFFFFF;
        } else if (localName.equals(ELEMENT_FIELD)) {
            if (this.currentName.startsWith("cf_")) {
                BugzillaCustomField newField = new BugzillaCustomField(this.currentDescription, this.currentName, this.currentType, this.currentEnterBug);
                List<String> customOptionList = this.customOption.get(this.currentName);
                if (customOptionList != null && !customOptionList.isEmpty()) {
                    newField.setOptions(customOptionList);
                }
                this.configuration.addCustomField(newField);
            }
            this.state &= 0xFFBFFFFF;
        } else if (localName.equals(ELEMENT_DESCRIPTION)) {
            this.currentDescription = this.characters.toString();
        } else if (localName.equals(ELEMENT_TYPE)) {
            this.currentType = this.characters.toString();
        } else if (localName.equals(ELEMENT_ID)) {
            this.currentId = Integer.parseInt(this.characters.toString());
        } else if (localName.equals(ELEMENT_ENTER_BUG)) {
            this.currentEnterBug = this.characters.toString();
        } else if (localName.equals(ELEMENT_REQUESTABLE)) {
            this.currentRequestable = this.characters.toString();
        } else if (localName.equals(ELEMENT_SPECIFICALLY_REQUESTABLE)) {
            this.currentSpecifically_requestable = this.characters.toString();
        } else if (localName.equals(ELEMENT_MULTIPLICABLE)) {
            this.currentMultiplicable = this.characters.toString();
        } else if (localName.equals(ELEMENT_FLAG_TYPES)) {
            this.state &= 0xFEFFFFFF;
        } else if (localName.equals(ELEMENT_FLAG_TYPE)) {
            if (this.currentId != -1) {
                if (this.about != null && !this.flagIds.containsValue(this.about)) {
                    this.flagIds.put(this.about, this.currentId);
                }
                BugzillaFlag newFlag = new BugzillaFlag(this.currentName, this.currentDescription, this.currentType, this.currentRequestable, this.currentSpecifically_requestable, this.currentMultiplicable, this.currentId);
                this.configuration.addFlag(newFlag);
            }
            this.state &= 0xFDFFFFFF;
        } else if (localName.startsWith("cf_")) {
            this.state &= 0xFF7FFFFF;
            this.currentCustomOptionName = "";
        }
    }

    private void parseResource(Attributes attributes) {
        switch (this.state) {
            case 3456: {
                String compURI;
                if (attributes == null || (compURI = attributes.getValue(ATTRIBUTE_RESOURCE)) == null || this.currentProduct.length() <= 0) break;
                List<String> compURIs = this.components.get(this.currentProduct);
                if (compURIs == null) {
                    compURIs = new ArrayList<String>();
                    this.components.put(this.currentProduct, compURIs);
                }
                compURIs.add(compURI);
                break;
            }
            case 3712: {
                String resourceURI;
                if (attributes == null || (resourceURI = attributes.getValue(ATTRIBUTE_RESOURCE)) == null || this.currentProduct.length() <= 0) break;
                List<String> versionUris = this.versions.get(this.currentProduct);
                if (versionUris == null) {
                    versionUris = new ArrayList<String>();
                    this.versions.put(this.currentProduct, versionUris);
                }
                versionUris.add(resourceURI);
                break;
            }
            case 35968: {
                String resourceURI;
                if (attributes == null || (resourceURI = attributes.getValue(ATTRIBUTE_RESOURCE)) == null) break;
                List<String> milestoneUris = this.milestones.get(this.currentProduct);
                if (milestoneUris == null) {
                    milestoneUris = new ArrayList<String>();
                    this.milestones.put(this.currentProduct, milestoneUris);
                }
                milestoneUris.add(resourceURI);
                break;
            }
            case 16788736: {
                List<String> flagsForComponent;
                String compURI;
                if (attributes == null || (compURI = attributes.getValue(ATTRIBUTE_RESOURCE)) == null || this.currentComponent.length() <= 0 || this.currentProduct.length() <= 0 || compURI.length() <= 0) break;
                Map<String, List<String>> flagComponentList = this.flagsInComponent.get(this.currentProduct);
                if (flagComponentList == null) {
                    flagComponentList = new HashMap<String, List<String>>();
                    this.flagsInComponent.put(this.currentProduct, flagComponentList);
                }
                if ((flagsForComponent = flagComponentList.get(this.currentComponent)) == null) {
                    flagsForComponent = new ArrayList<String>();
                    flagComponentList.put(this.currentComponent, flagsForComponent);
                }
                flagsForComponent.add(compURI.replace("flags.cgi?id=", "flag.cgi?id="));
                int i = 0;
                ++i;
                break;
            }
            case 9472: {
                if (attributes == null) break;
                this.about = attributes.getValue(ATTRIBUTE_RDF_ABOUT);
                int idx = this.about.indexOf("&product=");
                if (idx == -1) break;
                this.currentProduct = this.about.substring(idx + 9);
                break;
            }
            case 17920: {
                if (attributes == null) break;
                this.about = attributes.getValue(ATTRIBUTE_RDF_ABOUT);
                break;
            }
            case 99328: {
                if (attributes == null) break;
                this.about = attributes.getValue(ATTRIBUTE_RDF_ABOUT);
                break;
            }
            case 0x600400: {
                if (attributes == null) break;
                this.about = attributes.getValue(ATTRIBUTE_RDF_ABOUT);
                break;
            }
            case 0x3000400: {
                if (attributes == null) break;
                this.about = attributes.getValue(ATTRIBUTE_RDF_ABOUT);
            }
        }
    }

    public void endDocument() throws SAXException {
        String realName;
        for (String product : this.components.keySet()) {
            List<String> componentURIs = this.components.get(product);
            for (String uri : componentURIs) {
                realName = this.componentNames.get(uri);
                if (realName == null) continue;
                this.configuration.addComponent(product, realName);
            }
        }
        for (String product : this.versions.keySet()) {
            List<String> versionURIs = this.versions.get(product);
            for (String uri : versionURIs) {
                realName = this.versionNames.get(uri);
                if (realName == null) continue;
                this.configuration.addVersion(product, realName);
            }
        }
        for (String product : this.milestones.keySet()) {
            List<String> milestoneURIs = this.milestones.get(product);
            for (String uri : milestoneURIs) {
                realName = this.milestoneNames.get(uri);
                if (realName == null) continue;
                this.configuration.addTargetMilestone(product, realName);
            }
        }
        for (String flagProduct : this.flagsInComponent.keySet()) {
            Map<String, List<String>> flagComponentUsage = this.flagsInComponent.get(flagProduct);
            for (String flagusageList : flagComponentUsage.keySet()) {
                List<String> flagList = flagComponentUsage.get(flagusageList);
                for (String flagAbout : flagList) {
                    Integer flagId = this.flagIds.get(flagAbout);
                    BugzillaFlag flag = this.configuration.getFlagWithId(flagId);
                    flag.addUsed(flagProduct, flagusageList);
                }
            }
        }
        super.endDocument();
    }
}

