/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.gems;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.netbeans.modules.ruby.platform.Util;

public final class Gem
implements Comparable<Gem> {
    private String name;
    private String desc;
    private String installedVersions;
    private String availableVersions;

    public Gem(String name, String installedVersions, String availableVersions) {
        this.name = name;
        this.installedVersions = installedVersions;
        this.availableVersions = availableVersions;
    }

    public String getName() {
        return this.name;
    }

    public String getInstalledVersionsAsString() {
        return this.installedVersions;
    }

    List<String> getInstalledVersions() {
        if (this.installedVersions == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.installedVersions.trim().split(","));
    }

    public String getLatestInstalled() {
        return Gem.getLatestVersion(this.installedVersions);
    }

    SortedSet<String> getAvailableVersions() {
        return Gem.getVersions(this.availableVersions);
    }

    public String getAvailableVersionsAsString() {
        return this.availableVersions;
    }

    String getLatestAvailable() {
        return Gem.getLatestVersion(this.availableVersions);
    }

    boolean hasUpdateAvailable() {
        String latestAvailable = this.getLatestAvailable();
        return latestAvailable != null && Util.compareVersions(latestAvailable, this.getLatestInstalled()) > 0;
    }

    public String getDescription() {
        return this.desc;
    }

    public String getHTMLDescription() {
        return this.desc.replace("\n", "<br>\n");
    }

    @Override
    public int compareTo(Gem other) {
        return this.name.compareTo(other.name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAvailableVersions(String versions) {
        this.availableVersions = versions;
    }

    public void setInstalledVersions(String versions) {
        this.installedVersions = versions;
    }

    public void setDescription(String description) {
        this.desc = description;
    }

    private static String getLatestVersion(String commaVersions) {
        SortedSet<String> versions = Gem.getVersions(commaVersions);
        if (versions.isEmpty()) {
            return null;
        }
        return versions.last();
    }

    private static SortedSet<String> getVersions(String commaVersions) {
        if (commaVersions == null) {
            return new TreeSet<String>();
        }
        StringTokenizer st = new StringTokenizer(commaVersions, " ,");
        TreeSet<String> versions = new TreeSet<String>(Util.VERSION_COMPARATOR);
        while (st.hasMoreTokens()) {
            versions.add(st.nextToken());
        }
        return versions;
    }
}

