/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.project.ui;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.InstanceListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.project.ui.LibrariesNode;
import org.netbeans.modules.java.api.common.project.ui.ProjectUISupport;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;

class J2eePlatformTestNode
extends AbstractNode
implements PropertyChangeListener,
InstanceListener {
    private static final String ARCHIVE_ICON = "org/netbeans/modules/j2ee/common/project/ui/resources/jar.gif";
    private static final String DEFAULT_ICON = "org/netbeans/modules/j2ee/common/project/ui/resources/j2eeServer.gif";
    private static final String BROKEN_PROJECT_BADGE = "org/netbeans/modules/j2ee/common/project/ui/resources/brokenProjectBadge.gif";
    private static final Icon icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/j2ee/common/project/ui/resources/jar.gif", (boolean)false);
    private static final Image brokenIcon = ImageUtilities.mergeImages((Image)ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/common/project/ui/resources/j2eeServer.gif"), (Image)ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/common/project/ui/resources/brokenProjectBadge.gif"), (int)8, (int)0);
    private final PropertyEvaluator evaluator;
    private final String platformPropName;
    private J2eePlatform platformCache;
    private final PropertyChangeListener platformListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("displayName".equals(propertyChangeEvent.getPropertyName())) {
                J2eePlatformTestNode.this.fireNameChange((String)propertyChangeEvent.getOldValue(), (String)propertyChangeEvent.getNewValue());
                J2eePlatformTestNode.this.fireDisplayNameChange((String)propertyChangeEvent.getOldValue(), (String)propertyChangeEvent.getNewValue());
            }
            if ("classpath".equals(propertyChangeEvent.getPropertyName())) {
                J2eePlatformTestNode.this.postAddNotify();
            }
        }
    };
    private PropertyChangeListener weakPlatformListener;

    private J2eePlatformTestNode(Project project, PropertyEvaluator propertyEvaluator, String string, ClassPathSupport classPathSupport) {
        super((Children)new PlatformContentChildren(classPathSupport));
        this.evaluator = propertyEvaluator;
        this.platformPropName = string;
        propertyEvaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)propertyEvaluator));
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        j2eeModuleProvider.addInstanceListener((InstanceListener)WeakListeners.create(InstanceListener.class, (EventListener)this, (Object)j2eeModuleProvider));
    }

    public static J2eePlatformTestNode create(Project project, PropertyEvaluator propertyEvaluator, String string, ClassPathSupport classPathSupport) {
        return new J2eePlatformTestNode(project, propertyEvaluator, string, classPathSupport);
    }

    public String getName() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        return "";
    }

    public String getHtmlDisplayName() {
        if (this.getPlatform() != null) {
            return this.getPlatform().getDisplayName() + " (" + NbBundle.getMessage(J2eePlatformTestNode.class, (String)"LBL_J2eeServerEmbeddableContainer") + ")";
        }
        return NbBundle.getMessage(J2eePlatformTestNode.class, (String)"LBL_J2eeServerMissing");
    }

    public Image getIcon(int n) {
        Image image = null;
        if (this.getPlatform() != null) {
            image = this.getPlatform().getIcon();
        }
        return image != null ? image : brokenIcon;
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    public boolean canCopy() {
        return false;
    }

    public Action[] getActions(boolean bl) {
        return new SystemAction[0];
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.platformPropName.equals(propertyChangeEvent.getPropertyName())) {
            this.refresh();
        }
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (J2eePlatformTestNode.this.platformCache != null) {
                    J2eePlatformTestNode.this.platformCache.removePropertyChangeListener(J2eePlatformTestNode.this.weakPlatformListener);
                }
                J2eePlatformTestNode.this.platformCache = null;
                J2eePlatformTestNode.this.fireNameChange(null, null);
                J2eePlatformTestNode.this.fireDisplayNameChange(null, null);
                J2eePlatformTestNode.this.fireIconChange();
                J2eePlatformTestNode.this.postAddNotify();
            }
        });
    }

    public void instanceAdded(String string) {
        this.refresh();
    }

    public void instanceRemoved(String string) {
        this.refresh();
    }

    public void changeDefaultInstance(String string, String string2) {
    }

    private void postAddNotify() {
        LibrariesNode.rp.post(new Runnable(){

            @Override
            public void run() {
                ((PlatformContentChildren)J2eePlatformTestNode.this.getChildren()).addNotify();
            }
        });
    }

    private J2eePlatform getPlatform() {
        if (this.platformCache == null) {
            String string = this.evaluator.getProperty(this.platformPropName);
            if (string != null) {
                this.platformCache = Deployment.getDefault().getJ2eePlatform(string);
            }
            if (this.platformCache != null) {
                this.weakPlatformListener = WeakListeners.propertyChange((PropertyChangeListener)this.platformListener, (Object)this.platformCache);
                this.platformCache.addPropertyChangeListener(this.weakPlatformListener);
                this.fireIconChange();
            }
        }
        return this.platformCache;
    }

    private static class PlatformContentChildren
    extends Children.Keys<SourceGroup> {
        PlatformContentChildren(ClassPathSupport classPathSupport) {
        }

        protected void addNotify() {
            this.setKeys(this.getKeys());
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
        }

        protected Node[] createNodes(SourceGroup sourceGroup) {
            return new Node[]{ProjectUISupport.createFilteredLibrariesNode((Node)PackageView.createPackageView((SourceGroup)sourceGroup), null, null, null, null, null, null)};
        }

        private List<SourceGroup> getKeys() {
            List<SourceGroup> list;
            J2eePlatform j2eePlatform = ((J2eePlatformTestNode)this.getNode()).getPlatform();
            if (j2eePlatform != null && j2eePlatform.isToolSupported("embeddableejb")) {
                File[] fileArray = j2eePlatform.getToolClasspathEntries("embeddableejb");
                list = new ArrayList<SourceGroup>(fileArray.length);
                for (int i = 0; i < fileArray.length; ++i) {
                    FileObject fileObject;
                    FileObject fileObject2 = FileUtil.toFileObject((File)fileArray[i]);
                    if (fileObject2 == null || (fileObject = FileUtil.getArchiveRoot((FileObject)fileObject2)) == null) continue;
                    list.add(ProjectUISupport.createLibrariesSourceGroup((FileObject)fileObject, (String)fileObject2.getNameExt(), (Icon)icon, (Icon)icon));
                }
            } else {
                list = Collections.emptyList();
            }
            return list;
        }
    }
}

