/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.completion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.modules.xml.api.model.GrammarQuery;
import org.netbeans.modules.xml.api.model.GrammarResult;
import org.netbeans.modules.xml.api.model.HintContext;
import org.netbeans.modules.xml.spi.dom.UOException;
import org.netbeans.modules.xml.text.bracematch.XMLBraceMatcher;
import org.netbeans.modules.xml.text.completion.AttributeResultItem;
import org.netbeans.modules.xml.text.completion.ElementResultItem;
import org.netbeans.modules.xml.text.completion.EntityRefResultItem;
import org.netbeans.modules.xml.text.completion.GrammarManager;
import org.netbeans.modules.xml.text.completion.SyntaxQueryHelper;
import org.netbeans.modules.xml.text.completion.ValueResultItem;
import org.netbeans.modules.xml.text.completion.XMLResultItem;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.syntax.XMLTokenIDs;
import org.netbeans.modules.xml.text.syntax.dom.SyntaxNode;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.w3c.dom.Node;

public class XMLCompletionQuery
implements XMLTokenIDs {
    public static final String DOCUMENT_GRAMMAR_BINDING_PROP = "doc-bind-query";

    public List<CompletionItem> query(JTextComponent component, int offset, SyntaxSupport support) {
        BaseDocument doc = (BaseDocument)component.getDocument();
        if (doc == null) {
            return null;
        }
        XMLSyntaxSupport sup = (XMLSyntaxSupport)support.get(XMLSyntaxSupport.class);
        if (sup == null) {
            return null;
        }
        try {
            SyntaxQueryHelper helper = new SyntaxQueryHelper(sup, offset);
            XMLResultItem.substituteOffset = helper.getOffset() - helper.getEraseCount();
            if (helper.getCompletionType() != 6) {
                ElementResultItem item;
                List<CompletionItem> stlist;
                ArrayList<CompletionItem> all = new ArrayList<CompletionItem>();
                List<CompletionItem> list = null;
                switch (helper.getCompletionType()) {
                    case 1: {
                        list = this.queryAttributes(helper, (Document)doc, sup);
                        break;
                    }
                    case 2: {
                        list = this.queryValues(helper, (Document)doc, sup);
                        break;
                    }
                    case 3: {
                        list = this.queryElements(helper, (Document)doc, sup);
                        break;
                    }
                    case 4: {
                        list = this.queryEntities(helper, (Document)doc, sup);
                        break;
                    }
                    case 5: {
                        list = this.queryNotations(helper, (Document)doc, sup);
                    }
                    case 0: {
                        return null;
                    }
                }
                if (list == null) {
                    return null;
                }
                if (list.isEmpty() && helper.getPreText().startsWith("</") && (stlist = XMLCompletionQuery.findStartTag((SyntaxNode)helper.getSyntaxElement(), !helper.getPreText().endsWith("/") ? "/" : "")) != null && !stlist.isEmpty() && !XMLBraceMatcher.hasEndTag((Document)doc, offset, (item = (ElementResultItem)stlist.get(0)).getItemText()) && (!item.getItemText().startsWith("/") || item.getItemText().startsWith(helper.getPreText().substring(1)))) {
                    String title = NbBundle.getMessage(XMLCompletionQuery.class, (String)"MSG_result", (Object)helper.getPreText());
                }
                String debugMsg = Boolean.getBoolean("netbeans.debug.xml") ? " " + helper.getOffset() + "-" + helper.getEraseCount() : "";
                String title = NbBundle.getMessage(XMLCompletionQuery.class, (String)"MSG_result", (Object)helper.getPreText()) + debugMsg;
                all.addAll(list);
                if (!all.isEmpty()) {
                    return all;
                }
            } else if (helper.getToken().getTokenID() == PI_CONTENT && helper.getPreText().endsWith("encoding=")) {
                ArrayList<XMLResultItem> encodings = new ArrayList<XMLResultItem>(2);
                encodings.add(new XMLResultItem("\"UTF-8\""));
                encodings.add(new XMLResultItem("\"UTF-16\""));
            }
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        return null;
    }

    public static GrammarQuery getPerformer(Document doc, XMLSyntaxSupport sup) {
        Object grammarBindingObj = doc.getProperty(DOCUMENT_GRAMMAR_BINDING_PROP);
        if (grammarBindingObj == null) {
            grammarBindingObj = new GrammarManager(doc, sup);
            doc.putProperty(DOCUMENT_GRAMMAR_BINDING_PROP, grammarBindingObj);
        }
        return ((GrammarManager)grammarBindingObj).getGrammar();
    }

    private List queryEntities(SyntaxQueryHelper helper, Document doc, XMLSyntaxSupport sup) {
        Enumeration res = XMLCompletionQuery.getPerformer(doc, sup).queryEntities(helper.getContext().getCurrentPrefix());
        return this.translateEntityRefs(res);
    }

    private List queryElements(SyntaxQueryHelper helper, Document doc, XMLSyntaxSupport sup) {
        try {
            GrammarQuery performer = XMLCompletionQuery.getPerformer(doc, sup);
            HintContext ctx = helper.getContext();
            if (helper.getPreText().startsWith("</")) {
                return Collections.EMPTY_LIST;
            }
            String typedPrefix = ctx.getCurrentPrefix();
            Enumeration res = performer.queryElements(ctx);
            return this.translateElements(res, typedPrefix, performer);
        }
        catch (UOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return null;
        }
    }

    private List<CompletionItem> queryAttributes(SyntaxQueryHelper helper, Document doc, XMLSyntaxSupport sup) {
        Enumeration res = XMLCompletionQuery.getPerformer(doc, sup).queryAttributes(helper.getContext());
        return this.translateAttributes(res, helper.isBoundary());
    }

    private List<CompletionItem> queryValues(SyntaxQueryHelper helper, Document doc, XMLSyntaxSupport sup) {
        try {
            Enumeration res = XMLCompletionQuery.getPerformer(doc, sup).queryValues(helper.getContext());
            return this.translateValues(res);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private List<CompletionItem> queryNotations(SyntaxQueryHelper helper, Document doc, XMLSyntaxSupport sup) {
        Enumeration res = XMLCompletionQuery.getPerformer(doc, sup).queryNotations(helper.getContext().getCurrentPrefix());
        return null;
    }

    private List<CompletionItem> translateEntityRefs(Enumeration refs) {
        ArrayList<CompletionItem> result = new ArrayList<CompletionItem>(133);
        while (refs.hasMoreElements()) {
            GrammarResult next = (GrammarResult)refs.nextElement();
            if (next == null || next.getNodeName() == null) continue;
            EntityRefResultItem ref = new EntityRefResultItem(next);
            result.add(ref);
        }
        return result;
    }

    private List<CompletionItem> translateElements(Enumeration els, String prefix, GrammarQuery perfomer) {
        ArrayList<CompletionItem> result = new ArrayList<CompletionItem>(13);
        while (els.hasMoreElements()) {
            GrammarResult next = (GrammarResult)els.nextElement();
            if (prefix.equals(next.getNodeName()) || next == null || next.getNodeName() == null) continue;
            ElementResultItem ei = new ElementResultItem(next);
            result.add(ei);
        }
        return result;
    }

    private List<CompletionItem> translateAttributes(Enumeration attrs, boolean boundary) {
        ArrayList<CompletionItem> result = new ArrayList<CompletionItem>(13);
        while (attrs.hasMoreElements()) {
            GrammarResult next = (GrammarResult)attrs.nextElement();
            if (next == null || next.getNodeName() == null) continue;
            AttributeResultItem attr = new AttributeResultItem(next, false);
            result.add(attr);
        }
        return result;
    }

    private List<CompletionItem> translateValues(Enumeration values) {
        ArrayList<CompletionItem> result = new ArrayList<CompletionItem>(3);
        while (values.hasMoreElements()) {
            GrammarResult next = (GrammarResult)values.nextElement();
            if (next == null || next.getDisplayName() == null) continue;
            ValueResultItem val = new ValueResultItem(next);
            result.add(val);
        }
        return result;
    }

    private static List<CompletionItem> findStartTag(SyntaxNode text, String prefix) {
        Node parent = text.getParentNode();
        if (parent == null) {
            return Collections.EMPTY_LIST;
        }
        String name = parent.getNodeName();
        if (name == null) {
            return Collections.EMPTY_LIST;
        }
        ElementResultItem res = new ElementResultItem(prefix + name);
        ArrayList<CompletionItem> list = new ArrayList<CompletionItem>(1);
        list.add(res);
        return list;
    }

    private static List<CompletionItem> findStartTag(SyntaxNode text) {
        return XMLCompletionQuery.findStartTag(text, "");
    }
}

