/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.query;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneLayout;
import javax.swing.border.Border;
import org.netbeans.modules.bugtracking.ui.query.ViewportWidthAwarePanel;

class QueryTopComponentScrollPaneLayout
extends ScrollPaneLayout {
    QueryTopComponentScrollPaneLayout() {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Border viewportBorder;
        JScrollPane scrollPane = (JScrollPane)parent;
        this.vsbPolicy = scrollPane.getVerticalScrollBarPolicy();
        this.hsbPolicy = scrollPane.getHorizontalScrollBarPolicy();
        Insets insets = parent.getInsets();
        int prefWidth = insets.left + insets.right;
        int prefHeight = insets.top + insets.bottom;
        Dimension extentSize = null;
        Dimension viewSize = null;
        if (this.viewport != null) {
            extentSize = this.viewport.getPreferredSize();
            viewSize = this.viewport.getViewSize();
        }
        if (extentSize != null) {
            prefWidth += extentSize.width;
            prefHeight += extentSize.height;
        }
        if ((viewportBorder = scrollPane.getViewportBorder()) != null) {
            Insets vpbInsets = viewportBorder.getBorderInsets(parent);
            prefWidth += vpbInsets.left + vpbInsets.right;
            prefHeight += vpbInsets.top + vpbInsets.bottom;
        }
        if (this.vsb != null && viewSize != null && extentSize != null && viewSize.height > extentSize.height) {
            prefWidth += this.vsb.getPreferredSize().width;
        }
        if (this.hsb != null && viewSize != null && extentSize != null && viewSize.width > extentSize.width) {
            prefHeight += this.hsb.getPreferredSize().height;
        }
        return new Dimension(prefWidth, prefHeight);
    }

    @Override
    public void layoutContainer(Container parent) {
        boolean hsbNeeded;
        boolean vsbNeeded;
        Dimension viewPrefSize;
        Dimension extentSize;
        Insets vpbInsets;
        JScrollPane scrollPane = (JScrollPane)parent;
        this.vsbPolicy = scrollPane.getVerticalScrollBarPolicy();
        this.hsbPolicy = scrollPane.getHorizontalScrollBarPolicy();
        Rectangle availR = scrollPane.getBounds();
        availR.y = 0;
        availR.x = 0;
        Insets insets = parent.getInsets();
        availR.x = insets.left;
        availR.y = insets.top;
        availR.width -= insets.left + insets.right;
        availR.height -= insets.top + insets.bottom;
        Border viewportBorder = scrollPane.getViewportBorder();
        if (viewportBorder != null) {
            vpbInsets = viewportBorder.getBorderInsets(parent);
            availR.x += vpbInsets.left;
            availR.y += vpbInsets.top;
            availR.width -= vpbInsets.left + vpbInsets.right;
            availR.height -= vpbInsets.top + vpbInsets.bottom;
        } else {
            vpbInsets = new Insets(0, 0, 0, 0);
        }
        Component view = this.viewport != null ? this.viewport.getView() : null;
        ViewportWidthAwarePanel viewportWidthAwareView = view instanceof ViewportWidthAwarePanel ? (ViewportWidthAwarePanel)view : null;
        Dimension dimension = extentSize = this.viewport != null ? this.viewport.toViewCoordinates(availR.getSize()) : new Dimension(0, 0);
        if (view != null) {
            if (viewportWidthAwareView != null) {
                viewportWidthAwareView.setAvailableWidth(extentSize.width);
            }
            viewPrefSize = view.getPreferredSize();
        } else {
            viewPrefSize = new Dimension(0, 0);
        }
        boolean isEmpty = availR.width < 0 || availR.height < 0;
        Rectangle vsbR = new Rectangle(0, availR.y - vpbInsets.top, 0, 0);
        if (isEmpty) {
            vsbNeeded = false;
        } else {
            boolean bl = vsbNeeded = viewPrefSize.height > extentSize.height;
        }
        if (this.vsb != null && vsbNeeded) {
            this.adjustForVSB(availR, vsbR, vpbInsets);
            extentSize = this.viewport.toViewCoordinates(availR.getSize());
            if (viewportWidthAwareView != null) {
                viewportWidthAwareView.setAvailableWidth(extentSize.width);
                viewPrefSize = view.getPreferredSize();
            }
        }
        Rectangle hsbR = new Rectangle(availR.x - vpbInsets.left, 0, 0, 0);
        if (isEmpty) {
            hsbNeeded = false;
        } else {
            boolean bl = hsbNeeded = viewPrefSize.width > extentSize.width;
        }
        if (this.hsb != null && hsbNeeded) {
            this.adjustForHSB(availR, hsbR, vpbInsets);
            if (this.vsb != null && !vsbNeeded) {
                extentSize = this.viewport.toViewCoordinates(availR.getSize());
                boolean bl = vsbNeeded = viewPrefSize.height > extentSize.height;
                if (vsbNeeded) {
                    this.adjustForVSB(availR, vsbR, vpbInsets);
                    if (viewportWidthAwareView != null) {
                        extentSize = this.viewport.toViewCoordinates(availR.getSize());
                        viewportWidthAwareView.setAvailableWidth(extentSize.width);
                    }
                }
            }
        }
        if (this.viewport != null) {
            this.viewport.setBounds(availR);
        }
        vsbR.height = availR.height + vpbInsets.top + vpbInsets.bottom;
        hsbR.width = availR.width + vpbInsets.left + vpbInsets.right;
        if (this.vsb != null) {
            if (vsbNeeded) {
                this.vsb.setVisible(true);
                this.vsb.setBounds(vsbR);
            } else {
                this.vsb.setVisible(false);
            }
        }
        if (this.hsb != null) {
            if (hsbNeeded) {
                this.hsb.setVisible(true);
                this.hsb.setBounds(hsbR);
            } else {
                this.hsb.setVisible(false);
            }
        }
    }

    private void adjustForVSB(Rectangle available, Rectangle vsbR, Insets vpbInsets) {
        int vsbWidth = Math.max(0, Math.min(this.vsb.getPreferredSize().width, available.width));
        available.width -= vsbWidth;
        vsbR.width = vsbWidth;
        vsbR.x = available.x + available.width + vpbInsets.right;
    }

    private void adjustForHSB(Rectangle available, Rectangle hsbR, Insets vpbInsets) {
        int hsbHeight = Math.max(0, Math.min(available.height, this.hsb.getPreferredSize().height));
        available.height -= hsbHeight;
        hsbR.y = available.y + available.height + vpbInsets.bottom;
        hsbR.height = hsbHeight;
    }
}

