/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.instrumentation;

import java.util.ArrayList;
import org.netbeans.lib.profiler.classfile.BaseClassInfo;
import org.netbeans.lib.profiler.classfile.ClassInfo;
import org.netbeans.lib.profiler.classfile.ClassRepository;
import org.netbeans.lib.profiler.classfile.DynamicClassInfo;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.instrumentation.ClassManager;
import org.netbeans.lib.profiler.instrumentation.ClassRewriter;
import org.netbeans.lib.profiler.instrumentation.DynamicConstantPoolExtension;
import org.netbeans.lib.profiler.instrumentation.SingleMethodScaner;

public abstract class MemoryProfMethodInstrumentor
extends ClassManager {
    protected ArrayList instrClasses = new ArrayList();
    MethodScanerForNewOpcodes msfno;
    protected String[] instantiatableClasses;
    protected int injType;
    protected int instrClassId;
    protected int nInstantiatableClasses;
    protected int nInstrClasses;
    protected int nInstrMethods;

    public MemoryProfMethodInstrumentor(ProfilingSessionStatus status, int injType) {
        super(status);
        this.status = status;
        this.instantiatableClasses = new String[100];
        this.injType = injType;
        this.msfno = new MethodScanerForNewOpcodes();
    }

    public Object[] getInitialMethodsToInstrument(String[] loadedClasses, int[] loadedClassLoaderIds, byte[][] cachedClassFileBytes) {
        MemoryProfMethodInstrumentor.resetLoadedClassData();
        this.initInstrumentationPackData();
        this.instrClassId = 0;
        MemoryProfMethodInstrumentor.storeClassFileBytesForCustomLoaderClasses(loadedClasses, loadedClassLoaderIds, cachedClassFileBytes);
        for (int i = 0; i < loadedClasses.length; ++i) {
            if (loadedClasses[i].equals("java.lang.Object")) continue;
            this.findAndMarkMethodsToInstrumentInClass(loadedClasses[i], loadedClassLoaderIds[i]);
        }
        return this.createInstrumentedMethodPack();
    }

    public String[] getInstantiatableClasses() {
        return this.instantiatableClasses;
    }

    public Object[] getMethodsToInstrumentUponClassLoad(String className, int classLoaderId) {
        this.initInstrumentationPackData();
        this.findAndMarkMethodsToInstrumentInClass(className, classLoaderId);
        return this.createInstrumentedMethodPack();
    }

    public int getNInstantiatableClasses() {
        return this.nInstantiatableClasses;
    }

    protected void findAndMarkMethodsToInstrumentInClass(String className, int classLoaderId) {
        DynamicClassInfo clazz = MemoryProfMethodInstrumentor.javaClassForName(className, classLoaderId);
        if (clazz == null) {
            return;
        }
        if (!clazz.isLoaded()) {
            clazz.setLoaded(true);
            if (clazz.getInstrClassId() == -1 && !clazz.isInterface()) {
                clazz.setInstrClassId(this.getNextClassId(clazz.getName()));
            }
            String[] methodNames = clazz.getMethodNames();
            boolean found = false;
            for (int i = 0; i < methodNames.length; ++i) {
                if (clazz.isMethodNative(i) || clazz.isMethodAbstract(i)) {
                    clazz.setMethodUnscannable(i);
                    continue;
                }
                if (!this.methodNeedsInstrumentation(clazz, i)) continue;
                ++this.nInstrMethods;
                clazz.setMethodInstrumented(i);
                found = true;
            }
            if (found) {
                ++this.nInstrClasses;
                this.instrClasses.add(clazz);
            }
        }
    }

    protected void initInstrumentationPackData() {
        this.instrClasses.clear();
        this.nInstrMethods = 0;
        this.nInstrClasses = 0;
        this.nInstantiatableClasses = 0;
    }

    protected abstract boolean methodNeedsInstrumentation(ClassInfo var1, int var2);

    protected Object[] createInstrumentedMethodPack() {
        if (this.nInstrMethods == 0) {
            return null;
        }
        return this.createInstrumentedMethodPack15();
    }

    protected boolean hasNewOpcodes(ClassInfo clazz, int methodIdx, boolean checkForOpcNew) {
        this.msfno.setClassAndMethod(clazz, methodIdx);
        return this.msfno.hasNewArrayOpcodes(this, checkForOpcNew);
    }

    protected abstract byte[] instrumentMethod(DynamicClassInfo var1, int var2);

    protected boolean methodNeedsRewriting(DynamicClassInfo clazz, int methodIdx) {
        return clazz.isMethodInstrumented(methodIdx);
    }

    int getNextClassId(String className) {
        if (this.nInstantiatableClasses == this.instantiatableClasses.length) {
            String[] oldInstantiatableClasses = this.instantiatableClasses;
            this.instantiatableClasses = new String[oldInstantiatableClasses.length + 100];
            System.arraycopy(oldInstantiatableClasses, 0, this.instantiatableClasses, 0, oldInstantiatableClasses.length);
        }
        this.instantiatableClasses[this.nInstantiatableClasses++] = className;
        this.status.updateAllocatedInstancesCountInfoInClient(className);
        return this.instrClassId++;
    }

    private Object[] createInstrumentedMethodPack15() {
        String[] instrMethodClasses = new String[this.nInstrClasses];
        int[] instrClassLoaderIds = new int[this.nInstrClasses];
        byte[][] replacementClassFileBytes = new byte[this.nInstrClasses][];
        for (int j = 0; j < this.nInstrClasses; ++j) {
            DynamicClassInfo clazz = (DynamicClassInfo)this.instrClasses.get(j);
            instrMethodClasses[j] = clazz.getName().replace('/', '.');
            instrClassLoaderIds[j] = clazz.getLoaderId();
            String[] methodNames = clazz.getMethodNames();
            int nMethods = methodNames.length;
            byte[][] replacementMethodInfos = new byte[nMethods][];
            DynamicConstantPoolExtension.getCPFragment(clazz, this.injType);
            for (int i = 0; i < nMethods; ++i) {
                replacementMethodInfos[i] = this.methodNeedsRewriting(clazz, i) ? this.instrumentMethod(clazz, i) : clazz.getMethodInfo(i);
            }
            DynamicConstantPoolExtension wholeECP = DynamicConstantPoolExtension.getAllAddedCPFragments(clazz);
            int nAddedCPEntries = wholeECP.getNEntries();
            byte[] addedCPContents = wholeECP.getContents();
            replacementClassFileBytes[j] = ClassRewriter.rewriteClassFile(clazz, replacementMethodInfos, nAddedCPEntries, addedCPContents);
        }
        return new Object[]{instrMethodClasses, instrClassLoaderIds, replacementClassFileBytes};
    }

    static class MethodScanerForNewOpcodes
    extends SingleMethodScaner {
        MethodScanerForNewOpcodes() {
        }

        boolean hasNewArrayOpcodes(MemoryProfMethodInstrumentor minstr, boolean checkForOpcNew) {
            int loaderId = this.clazz.getLoaderId();
            boolean found = false;
            for (int bci = 0; bci < this.bytecodesLength; bci += this.opcodeLength(bci)) {
                BaseClassInfo refClazz;
                String refClassName;
                int classCPIdx;
                int bc = this.bytecodes[bci] & 0xFF;
                if (bc == 187 && checkForOpcNew) {
                    found = true;
                    classCPIdx = this.getU2(bci + 1);
                    refClassName = this.clazz.getRefClassName(classCPIdx);
                    refClazz = ClassManager.javaClassOrPlaceholderForName(refClassName, loaderId);
                    if (refClazz.getInstrClassId() != -1) continue;
                    refClazz.setInstrClassId(minstr.getNextClassId(refClazz.getName()));
                    continue;
                }
                if (bc == 189 || bc == 197) {
                    found = true;
                    classCPIdx = this.getU2(bci + 1);
                    refClassName = this.clazz.getRefClassName(classCPIdx);
                    BaseClassInfo baseClassInfo = refClazz = bc == 189 ? ClassManager.javaClassForObjectArrayType(refClassName) : ClassRepository.lookupSpecialClass(refClassName);
                    if (refClazz == null || refClazz.getInstrClassId() != -1) continue;
                    refClazz.setInstrClassId(minstr.getNextClassId(refClazz.getName()));
                    continue;
                }
                if (bc != 188) continue;
                found = true;
                int arrayClassId = this.getByte(bci + 1);
                BaseClassInfo refClazz2 = ClassManager.javaClassForPrimitiveArrayType(arrayClassId);
                if (refClazz2.getInstrClassId() != -1) continue;
                refClazz2.setInstrClassId(minstr.getNextClassId(refClazz2.getName()));
            }
            return found;
        }
    }
}

