/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.copysupport;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.PhpVisibilityQuery;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.connections.RemoteConnections;
import org.netbeans.modules.php.project.copysupport.FileOperationFactory;
import org.netbeans.modules.php.project.copysupport.LocalOperationFactory;
import org.netbeans.modules.php.project.copysupport.RemoteOperationFactory;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public final class CopySupport
extends FileChangeAdapter
implements PropertyChangeListener,
FileChangeListener,
ChangeListener {
    static final Logger LOGGER = Logger.getLogger(CopySupport.class.getName());
    public static final boolean ALLOW_BROKEN = Boolean.getBoolean(CopySupport.class.getName() + ".allowBroken");
    private static final RequestProcessor COPY_SUPPORT_RP = new RequestProcessor("PHP file change handler (copy support)");
    private static final int FILE_CHANGE_DELAY = 300;
    private static final int PROPERTY_CHANGE_DELAY = 500;
    private static final int PROGRESS_INITIAL_DELAY = 1000;
    static final Queue<Callable<Boolean>> OPERATIONS_QUEUE = new ConcurrentLinkedQueue<Callable<Boolean>>();
    static final RequestProcessor.Task COPY_TASK = CopySupport.createCopyTask();
    final PhpProject project;
    final PhpVisibilityQuery phpVisibilityQuery;
    private final RequestProcessor.Task initTask;
    volatile boolean projectOpened = false;
    private final ProxyOperationFactory proxyOperationFactory;
    private FileSystem fileSystem;
    private FileChangeListener fileChangeListener;

    private CopySupport(PhpProject project) {
        assert (project != null);
        this.project = project;
        this.phpVisibilityQuery = PhpVisibilityQuery.forProject(project);
        this.proxyOperationFactory = new ProxyOperationFactory(project);
        ProjectPropertiesSupport.addWeakPropertyEvaluatorListener(project, this);
        RemoteConnections remoteConnections = RemoteConnections.get();
        remoteConnections.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)remoteConnections));
        this.initTask = COPY_SUPPORT_RP.create(new Runnable(){

            @Override
            public void run() {
                CopySupport.this.init();
            }
        });
    }

    public static CopySupport getInstance(PhpProject project) {
        return new CopySupport(project);
    }

    private static RequestProcessor.Task createCopyTask() {
        return COPY_SUPPORT_RP.create(new Runnable(){

            @Override
            public void run() {
                Callable<Boolean> operation = OPERATIONS_QUEUE.poll();
                while (operation != null) {
                    try {
                        operation.call();
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.WARNING, null, ex);
                    }
                    operation = OPERATIONS_QUEUE.poll();
                }
            }
        }, true);
    }

    public void projectOpened() {
        LOGGER.log(Level.FINE, "Opening Copy support for project {0}", this.project.getName());
        assert (!this.projectOpened) : "Copy Support already opened for project " + this.project.getName();
        this.projectOpened = true;
        this.initTask.schedule(500);
    }

    public void projectClosed() {
        LOGGER.log(Level.FINE, "Closing Copy support for project {0}", this.project.getName());
        assert (this.projectOpened) : "Copy Support already closed for project " + this.project.getName();
        this.projectOpened = false;
        this.unregisterFileChangeListener();
    }

    private void prepareOperation(Callable<Boolean> callable) {
        if (callable != null) {
            OPERATIONS_QUEUE.offer(callable);
            COPY_TASK.schedule(300);
        }
    }

    synchronized void init() {
        LOGGER.log(Level.FINE, "Copy support INIT for project {0}", this.project.getName());
        this.proxyOperationFactory.reset();
        if (this.proxyOperationFactory.isEnabled()) {
            this.prepareOperation(this.proxyOperationFactory.createInitHandler(this.getSources()));
            this.registerFileChangeListener();
        } else {
            this.unregisterFileChangeListener();
        }
    }

    private void registerFileChangeListener() {
        LOGGER.log(Level.FINE, "Copy support REGISTERING FS listener for project {0}", this.project.getName());
        assert (Thread.holdsLock(this));
        if (this.fileChangeListener != null) {
            LOGGER.log(Level.FINE, "\t-> not needed for project {0} (already registered)", this.project.getName());
            return;
        }
        if (ALLOW_BROKEN) {
            assert (this.fileChangeListener == null) : "FS listener cannot yet exist for project " + this.project.getName();
            try {
                this.fileSystem = this.getSources().getFileSystem();
                this.fileChangeListener = FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)this.fileSystem);
                this.fileSystem.addFileChangeListener(this.fileChangeListener);
                LOGGER.log(Level.FINE, "\t-> NON-RECURSIVE listener registered for project {0}", this.project.getName());
            }
            catch (FileStateInvalidException ex) {
                LOGGER.log(Level.WARNING, null, ex);
            }
        } else {
            this.fileChangeListener = new SourcesFileChangeListener(this);
            FileUtil.addRecursiveListener((FileChangeListener)this.fileChangeListener, (File)FileUtil.toFile((FileObject)this.getSources()), (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    boolean cancel;
                    boolean bl = cancel = !CopySupport.this.projectOpened;
                    if (cancel) {
                        LOGGER.log(Level.INFO, "Adding of recursive listener interrupted for project {0}", CopySupport.this.project.getName());
                    }
                    return cancel;
                }
            });
            LOGGER.log(Level.FINE, "\t-> RECURSIVE listener registered for project {0}", this.project.getName());
        }
    }

    private synchronized void unregisterFileChangeListener() {
        LOGGER.log(Level.FINE, "Copy support UNREGISTERING FS listener for project {0}", this.project.getName());
        if (this.fileChangeListener == null) {
            LOGGER.log(Level.FINE, "\t-> not needed for project {0} (not registered)", this.project.getName());
        } else {
            if (ALLOW_BROKEN) {
                assert (this.fileChangeListener != null) : "FS listener must be known already for project " + this.project.getName();
                this.fileSystem.removeFileChangeListener(this.fileChangeListener);
                LOGGER.log(Level.FINE, "\t-> NON-RECURSIVE listener unregistered for project {0}", this.project.getName());
            } else {
                assert (this.fileChangeListener instanceof SourcesFileChangeListener) : "FS listener of incorrect type: " + this.fileChangeListener.getClass().getName();
                try {
                    FileUtil.removeRecursiveListener((FileChangeListener)this.fileChangeListener, (File)FileUtil.toFile((FileObject)this.getSources()));
                    LOGGER.log(Level.FINE, "\t-> RECURSIVE listener unregistered for project {0}", this.project.getName());
                }
                catch (IllegalArgumentException ex) {
                    LOGGER.log(Level.WARNING, "If this happens to you reliably, report issue with steps to reproduce and attach IDE log (http://www.netbeans.org/community/issues).", ex);
                    FileObject originalSources = ((SourcesFileChangeListener)this.fileChangeListener).getSources();
                    FileObject currentSources = this.getSources();
                    LOGGER.log(Level.INFO, "registered sources (valid): {0} ({1}), current sources (valid): {2} ({3}), equals: {4}", new Object[]{originalSources, originalSources.isValid(), currentSources, currentSources.isValid(), originalSources.equals(currentSources)});
                }
            }
            this.fileSystem = null;
            this.fileChangeListener = null;
        }
    }

    public boolean waitFinished() {
        try {
            if (!this.proxyOperationFactory.isEnabled()) {
                return true;
            }
            if (COPY_TASK.waitFinished(200L)) {
                return true;
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return true;
        }
        NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(CopySupport.class, (String)"MSG_CopySupportRunning"), 0);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor) == NotifyDescriptor.YES_OPTION;
    }

    public void fileFolderCreated(FileEvent fe) {
        FileObject source = this.getValidProjectSource(fe);
        if (source == null) {
            return;
        }
        LOGGER.log(Level.FINE, "Processing event FOLDER CREATED for project {0}", this.project.getName());
        this.prepareOperation(this.proxyOperationFactory.createCopyHandler(source, fe));
    }

    public void fileDataCreated(FileEvent fe) {
        FileObject source = this.getValidProjectSource(fe);
        if (source == null) {
            return;
        }
        LOGGER.log(Level.FINE, "Processing event DATA CREATED for project {0}", this.project.getName());
        this.prepareOperation(this.proxyOperationFactory.createCopyHandler(source, fe));
    }

    public void fileChanged(FileEvent fe) {
        FileObject source = this.getValidProjectSource(fe);
        if (source == null) {
            return;
        }
        LOGGER.log(Level.FINE, "Processing event FILE CHANGED for project {0}", this.project.getName());
        this.prepareOperation(this.proxyOperationFactory.createCopyHandler(source, fe));
    }

    public void fileDeleted(FileEvent fe) {
        FileObject source = this.getValidProjectSource(fe);
        if (source == null) {
            return;
        }
        LOGGER.log(Level.FINE, "Processing event FILE DELETED for project {0}", this.project.getName());
        this.prepareOperation(this.proxyOperationFactory.createDeleteHandler(source, fe));
    }

    public void fileRenamed(FileRenameEvent fe) {
        FileObject source = this.getValidProjectSource((FileEvent)fe);
        if (source == null) {
            return;
        }
        LOGGER.log(Level.FINE, "Processing event FILE RENAMED for project {0}", this.project.getName());
        String originalName = fe.getName();
        String ext = fe.getExt();
        if (StringUtils.hasText((String)ext)) {
            originalName = originalName + "." + ext;
        }
        this.prepareOperation(this.proxyOperationFactory.createRenameHandler(source, originalName, fe));
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.projectOpened) {
            LOGGER.log(Level.FINE, "Processing event PROPERTY CHANGE for opened project {0}", this.project.getName());
            this.initTask.schedule(500);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.projectOpened) {
            LOGGER.log(Level.FINE, "Processing event STATE CHANGE (remote connections) for opened project {0}", this.project.getName());
            this.initTask.schedule(500);
        }
    }

    private FileObject getValidProjectSource(FileEvent fileEvent) {
        LOGGER.log(Level.FINEST, "Getting source file for project {0} from {1}", new Object[]{this.project.getName(), fileEvent});
        FileObject source = fileEvent.getFile();
        if (!PhpProjectUtils.isVisible(this.phpVisibilityQuery, source)) {
            LOGGER.finest("\t-> null (invisible source)");
            return null;
        }
        if (!CommandUtils.isUnderSources(this.project, source)) {
            LOGGER.finest("\t-> null (invalid source)");
            return null;
        }
        LOGGER.log(Level.FINE, "Got source file for project {0} from {1}", new Object[]{this.project.getName(), fileEvent});
        return source;
    }

    FileObject getSources() {
        return ProjectPropertiesSupport.getSourcesDirectory(this.project);
    }

    private static class SourcesFileChangeListener
    implements FileChangeListener {
        private final CopySupport copySupport;
        private final FileObject sources;

        public SourcesFileChangeListener(CopySupport copySupport) {
            this.copySupport = copySupport;
            this.sources = copySupport.getSources();
        }

        public FileObject getSources() {
            return this.sources;
        }

        public void fileFolderCreated(FileEvent fe) {
            this.copySupport.fileFolderCreated(fe);
        }

        public void fileDataCreated(FileEvent fe) {
            this.copySupport.fileDataCreated(fe);
        }

        public void fileChanged(FileEvent fe) {
            this.copySupport.fileChanged(fe);
        }

        public void fileDeleted(FileEvent fe) {
            this.copySupport.fileDeleted(fe);
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.copySupport.fileRenamed(fe);
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
            this.copySupport.fileAttributeChanged(fe);
        }
    }

    private static class ProxyOperationFactory
    extends FileOperationFactory {
        final FileOperationFactory localFactory;
        final FileOperationFactory remoteFactory;

        ProxyOperationFactory(PhpProject project) {
            super(project);
            this.localFactory = new LocalOperationFactory(project);
            this.remoteFactory = new RemoteOperationFactory(project);
        }

        @Override
        protected void resetInternal() {
            this.localFactory.reset();
            this.remoteFactory.reset();
        }

        @Override
        Logger getLogger() {
            return LOGGER;
        }

        @Override
        protected boolean isEnabled() {
            return this.localFactory.isEnabled() || this.remoteFactory.isEnabled();
        }

        @Override
        protected Callable<Boolean> createInitHandlerInternal(FileObject source) {
            return this.createHandler(this.localFactory.createInitHandler(source), this.remoteFactory.createInitHandler(source));
        }

        @Override
        protected Callable<Boolean> createCopyHandlerInternal(FileObject source, FileEvent fileEvent) {
            return this.createHandler(this.localFactory.createCopyHandler(source, fileEvent), this.remoteFactory.createCopyHandler(source, fileEvent));
        }

        @Override
        protected Callable<Boolean> createRenameHandlerInternal(FileObject source, String oldName, FileRenameEvent fileRenameEvent) {
            return this.createHandler(this.localFactory.createRenameHandler(source, oldName, fileRenameEvent), this.remoteFactory.createRenameHandler(source, oldName, fileRenameEvent));
        }

        @Override
        protected Callable<Boolean> createDeleteHandlerInternal(FileObject source, FileEvent fileEvent) {
            return this.createHandler(this.localFactory.createDeleteHandler(source, fileEvent), this.remoteFactory.createDeleteHandler(source, fileEvent));
        }

        private Callable<Boolean> createHandler(Callable<Boolean> localHandler, Callable<Boolean> remoteHandler) {
            if (localHandler == null && remoteHandler == null) {
                LOGGER.fine("No handler given");
                return null;
            }
            return new ProxyHandler(localHandler, remoteHandler);
        }

        @Override
        protected boolean isValid(FileEvent fileEvent) {
            return true;
        }

        private final class ProxyHandler
        implements Callable<Boolean> {
            private final Callable<Boolean> localHandler;
            private final Callable<Boolean> remoteHandler;

            public ProxyHandler(Callable<Boolean> localHandler, Callable<Boolean> remoteHandler) {
                this.localHandler = localHandler;
                this.remoteHandler = remoteHandler;
            }

            @Override
            public Boolean call() throws Exception {
                Boolean localRetval = this.callLocal();
                Boolean remoteRetval = this.callRemote();
                if (localRetval == null && remoteRetval == null) {
                    return null;
                }
                if (localRetval != null && !localRetval.booleanValue()) {
                    return false;
                }
                if (remoteRetval != null && !remoteRetval.booleanValue()) {
                    return false;
                }
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Boolean callLocal() {
                Boolean localRetval = null;
                Exception localExc = null;
                if (this.localHandler != null) {
                    LOGGER.log(Level.FINE, "Processing LOCAL copying handler for project {0}", ProxyOperationFactory.this.project.getName());
                    ProgressHandle progress = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(CopySupport.class, (String)"LBL_LocalSynchronization"));
                    progress.setInitialDelay(1000);
                    try {
                        progress.start();
                        localRetval = this.localHandler.call();
                    }
                    catch (Exception exc) {
                        LOGGER.log(Level.INFO, "LOCAL copying fail: ", exc);
                        localRetval = false;
                        localExc = exc;
                    }
                    finally {
                        progress.finish();
                    }
                }
                if (localRetval != null && !localRetval.booleanValue() && ProxyOperationFactory.this.askUser(NbBundle.getMessage(CopySupport.class, (String)"LBL_Copy_Support_Fail", (Object)ProxyOperationFactory.this.project.getName()))) {
                    ProxyOperationFactory.this.localFactory.invalidate();
                    LOGGER.log(Level.INFO, String.format("LOCAL copying for project %s disabled by user", ProxyOperationFactory.this.project.getName()), localExc);
                }
                return localRetval;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Boolean callRemote() {
                Boolean remoteRetval = null;
                Exception remoteExc = null;
                if (this.remoteHandler != null) {
                    LOGGER.log(Level.FINE, "Processing REMOTE copying handler for project {0}", ProxyOperationFactory.this.project.getName());
                    ProgressHandle progress = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(CopySupport.class, (String)"LBL_RemoteSynchronization"));
                    progress.setInitialDelay(1000);
                    try {
                        progress.start();
                        remoteRetval = this.remoteHandler.call();
                    }
                    catch (Exception exc) {
                        LOGGER.log(Level.INFO, "REMOTE copying fail: ", exc);
                        remoteRetval = false;
                        remoteExc = exc;
                    }
                    finally {
                        progress.finish();
                    }
                    if (remoteRetval != null && !remoteRetval.booleanValue() && ProxyOperationFactory.this.askUser(NbBundle.getMessage(CopySupport.class, (String)"LBL_Remote_On_Save_Fail", (Object)ProxyOperationFactory.this.project.getName()))) {
                        ProxyOperationFactory.this.remoteFactory.invalidate();
                        LOGGER.log(Level.INFO, String.format("REMOTE copying for project %s disabled by user", ProxyOperationFactory.this.project.getName()), remoteExc);
                    }
                }
                return remoteRetval;
            }
        }
    }
}

