/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.support;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.remote.support.RemoteConnectionSupport;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.openide.util.Exceptions;

public class RemoteCommandSupport
extends RemoteConnectionSupport {
    private final StringBuilder out = new StringBuilder();
    private final StringBuilder err = new StringBuilder();
    private final String cmd;
    private final Map<String, String> env;
    private final String[] args;
    private boolean interrupted = false;

    public static int run(ExecutionEnvironment execEnv, String cmd) {
        RemoteCommandSupport support = new RemoteCommandSupport(execEnv, cmd);
        return support.run();
    }

    public static int run(ExecutionEnvironment execEnv, String cmd, String ... args) {
        RemoteCommandSupport support = new RemoteCommandSupport(execEnv, cmd, null, args);
        return support.run();
    }

    public RemoteCommandSupport(ExecutionEnvironment execEnv, String cmd, Map<String, String> env, String ... args) {
        super(execEnv);
        this.cmd = cmd;
        this.env = env;
        this.args = args;
    }

    public RemoteCommandSupport(ExecutionEnvironment execEnv, String cmd, Map<String, String> env) {
        super(execEnv);
        this.cmd = cmd;
        this.env = env;
        this.args = null;
    }

    public RemoteCommandSupport(ExecutionEnvironment execEnv, String cmd) {
        this(execEnv, cmd, null);
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run() {
        if (!this.isFailedOrCancelled()) {
            RemoteUtil.LOGGER.log(Level.FINE, "RemoteCommandSupport<Init>: Running [{0}] on {1}", new Object[]{this.cmd, this.executionEnvironment});
            if (SwingUtilities.isEventDispatchThread()) {
                String text = "Running remote command in EDT: " + this.cmd;
                if (RemoteUtil.LOGGER.isLoggable(Level.FINE)) {
                    RemoteUtil.LOGGER.log(Level.FINE, text, new Exception(text));
                } else {
                    RemoteUtil.LOGGER.warning(text);
                }
            }
            BufferedReader remoteProcessOut = null;
            BufferedReader remoteProcessErr = null;
            try {
                String errMsg;
                String line;
                NativeProcessBuilder pb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.executionEnvironment);
                if (this.args == null) {
                    pb.setCommandLine(this.cmd);
                } else {
                    pb.setExecutable(this.cmd).setArguments(this.args);
                }
                pb.getEnvironment().putAll(this.env);
                NativeProcess process = pb.call();
                InputStream is = process.getInputStream();
                InputStream er = process.getErrorStream();
                if (is == null) {
                    throw new IOException("process (" + process.getClass().getName() + ") returned null input stream");
                }
                if (er == null) {
                    throw new IOException("process (" + process.getClass().getName() + ") returned null error stream");
                }
                remoteProcessOut = new BufferedReader(new InputStreamReader(is));
                remoteProcessErr = new BufferedReader(new InputStreamReader(er));
                while ((line = remoteProcessOut.readLine()) != null) {
                    if (line == null) continue;
                    this.out.append(line).append('\n');
                }
                int rc = process.waitFor();
                RemoteUtil.LOGGER.log(Level.FINE, "RemoteCommandSupport: {0} on {1} finished; rc={2}", new Object[]{this.cmd, this.executionEnvironment, rc});
                while ((errMsg = remoteProcessErr.readLine()) != null) {
                    if (errMsg == null) continue;
                    this.err.append(errMsg).append('\n');
                    if (!RemoteUtil.LOGGER.isLoggable(Level.FINEST)) continue;
                    RemoteUtil.LOGGER.log(Level.FINEST, "RemoteCommandSupport ERROR: {0}", errMsg);
                }
                this.setExitStatus(rc);
            }
            catch (InterruptedException ie) {
                this.interrupted = true;
                RemoteUtil.LOGGER.log(Level.FINEST, "Interrupted", ie);
            }
            catch (InterruptedIOException ie) {
                this.interrupted = true;
                RemoteUtil.LOGGER.log(Level.FINEST, "Interrupted", ie);
            }
            catch (IOException ex) {
                RemoteUtil.LOGGER.log(Level.WARNING, "IO failure during running {0} at {1}", new Object[]{this.cmd, this.env});
            }
            finally {
                if (remoteProcessOut != null) {
                    try {
                        remoteProcessOut.close();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                if (remoteProcessErr != null) {
                    try {
                        remoteProcessErr.close();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
        return this.getExitStatus();
    }

    public String toString() {
        return this.getOutput();
    }

    public String getOutput() {
        return this.out.toString();
    }

    public String getErr() {
        return this.err.toString();
    }
}

