/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard.checkedtree;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.netbeans.modules.cnd.discovery.wizard.checkedtree.AbstractRoot;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;

public class Root
implements AbstractRoot {
    private Map<String, AbstractRoot> children = new HashMap<String, AbstractRoot>();
    private String name;
    private String folder;
    private List<String> files;

    public Root(String name, String folder) {
        this.name = name;
        this.folder = folder;
    }

    @Override
    public Collection<AbstractRoot> getChildren() {
        return this.children.values();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFolder() {
        return CndFileUtils.normalizeFile((File)new File(this.folder)).getAbsolutePath();
    }

    private Root getChild(String child) {
        return (Root)this.children.get(child);
    }

    @Override
    public List<String> getFiles() {
        return this.files;
    }

    public void setFiles(List<String> files) {
        if (this.files == null) {
            this.files = files;
        }
    }

    public Root addChild(String child) {
        Root current = this;
        StringTokenizer st = new StringTokenizer(child, "/\\");
        StringBuilder path = new StringBuilder();
        while (st.hasMoreTokens()) {
            String segment = st.nextToken();
            if (path.length() > 0) {
                path.append('/');
            } else if (segment.length() <= 1 || segment.charAt(1) != ':') {
                path.append('/');
            }
            path.append(segment);
            if (st.hasMoreTokens()) {
                Root found = current.getChild(segment);
                if (found == null) {
                    found = new Root(segment, path.toString());
                    current.children.put(segment, found);
                }
                current = found;
                continue;
            }
            List<String> fileList = current.getFiles();
            if (fileList == null) {
                fileList = new ArrayList<String>();
                current.setFiles(fileList);
            }
            fileList.add(child);
        }
        return current;
    }
}

