/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.api.webservices;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.webservices.Webservices;
import org.netbeans.modules.j2ee.dd.impl.webservices.WebServicesProxy;
import org.netbeans.modules.schema2beans.BaseBean;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class DDProvider {
    private static final DDProvider ddProvider = new DDProvider();
    private Map ddMap = new HashMap(5);

    private DDProvider() {
    }

    public static DDProvider getDefault() {
        return ddProvider;
    }

    public synchronized Webservices getDDRoot(FileObject fileObject) throws IOException {
        WebServicesProxy webServicesProxy;
        block5: {
            if (fileObject == null) {
                return null;
            }
            webServicesProxy = this.getFromCache(fileObject);
            if (webServicesProxy != null) {
                return webServicesProxy;
            }
            fileObject.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

                public void fileChanged(FileEvent fileEvent) {
                    block9: {
                        FileObject fileObject = fileEvent.getFile();
                        try {
                            WebServicesProxy webServicesProxy = DDProvider.this.getFromCache(fileObject);
                            String string = null;
                            if (webServicesProxy == null) break block9;
                            try {
                                DDParse dDParse = DDProvider.this.parseDD(fileObject);
                                string = dDParse.getVersion();
                                DDProvider.setProxyErrorStatus(webServicesProxy, dDParse);
                                Webservices webservices = DDProvider.createWebSvcJar(dDParse);
                                if (!string.equals(webServicesProxy.getVersion().toString())) {
                                    webServicesProxy.setOriginal(webservices);
                                    break block9;
                                }
                                if (webServicesProxy.getOriginal() == null) {
                                    webServicesProxy.setOriginal(webservices);
                                    break block9;
                                }
                                webServicesProxy.getOriginal().merge(webservices, 3);
                            }
                            catch (SAXException sAXException) {
                                if (sAXException instanceof SAXParseException) {
                                    webServicesProxy.setError((SAXParseException)sAXException);
                                } else if (sAXException.getException() instanceof SAXParseException) {
                                    webServicesProxy.setError((SAXParseException)sAXException.getException());
                                }
                                webServicesProxy.setStatus(2);
                                webServicesProxy.setProxyVersion("1.1");
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            });
            try {
                DDParse dDParse = this.parseDD(fileObject);
                Webservices webservices = DDProvider.createWebSvcJar(dDParse);
                webServicesProxy = new WebServicesProxy(webservices, dDParse.getVersion());
                DDProvider.setProxyErrorStatus(webServicesProxy, dDParse);
            }
            catch (SAXException sAXException) {
                webServicesProxy = new WebServicesProxy(org.netbeans.modules.j2ee.dd.impl.webservices.model_1_2.Webservices.createGraph(), "1.2");
                webServicesProxy.setStatus(2);
                if (sAXException instanceof SAXParseException) {
                    webServicesProxy.setError((SAXParseException)sAXException);
                }
                if (!(sAXException.getException() instanceof SAXParseException)) break block5;
                webServicesProxy.setError((SAXParseException)sAXException.getException());
            }
        }
        this.ddMap.put(fileObject, webServicesProxy);
        return webServicesProxy;
    }

    public Webservices getDDRootCopy(FileObject fileObject) throws IOException {
        return (Webservices)this.getDDRoot(fileObject).clone();
    }

    private WebServicesProxy getFromCache(FileObject fileObject) {
        return (WebServicesProxy)this.ddMap.get(fileObject);
    }

    public Webservices getDDRoot(InputSource inputSource) throws IOException, SAXException {
        DDParse dDParse = this.parseDD(inputSource);
        Webservices webservices = DDProvider.createWebSvcJar(dDParse);
        WebServicesProxy webServicesProxy = new WebServicesProxy(webservices, webservices.getVersion().toString());
        DDProvider.setProxyErrorStatus(webServicesProxy, dDParse);
        return webServicesProxy;
    }

    public BaseBean getBaseBean(CommonDDBean commonDDBean) {
        if (commonDDBean instanceof BaseBean) {
            return (BaseBean)commonDDBean;
        }
        if (commonDDBean instanceof WebServicesProxy) {
            return (BaseBean)((WebServicesProxy)commonDDBean).getOriginal();
        }
        return null;
    }

    private static void setProxyErrorStatus(WebServicesProxy webServicesProxy, DDParse dDParse) {
        SAXParseException sAXParseException = dDParse.getWarning();
        webServicesProxy.setError(sAXParseException);
        if (sAXParseException != null) {
            webServicesProxy.setStatus(1);
        } else {
            webServicesProxy.setStatus(0);
        }
    }

    private static Webservices createWebSvcJar(DDParse dDParse) throws SAXException {
        Webservices webservices = null;
        String string = dDParse.getVersion();
        if ("1.1".equals(string)) {
            try {
                return new org.netbeans.modules.j2ee.dd.impl.webservices.model_1_1.Webservices(dDParse.getDocument(), 1);
            }
            catch (RuntimeException runtimeException) {
                throw new SAXException(runtimeException.getMessage());
            }
        }
        if ("1.2".equals(string)) {
            try {
                return new org.netbeans.modules.j2ee.dd.impl.webservices.model_1_2.Webservices(dDParse.getDocument(), 1);
            }
            catch (RuntimeException runtimeException) {
                throw new SAXException(runtimeException.getMessage());
            }
        }
        return webservices;
    }

    public SAXParseException parse(FileObject fileObject) throws SAXException, IOException {
        DDParse dDParse = this.parseDD(fileObject);
        return dDParse.getWarning();
    }

    private DDParse parseDD(FileObject fileObject) throws SAXException, IOException {
        return this.parseDD(fileObject.getInputStream());
    }

    private DDParse parseDD(InputStream inputStream) throws SAXException, IOException {
        return this.parseDD(new InputSource(inputStream));
    }

    private DDParse parseDD(InputSource inputSource) throws SAXException, IOException {
        Object object;
        ErrorHandler errorHandler = new ErrorHandler();
        DocumentBuilder documentBuilder = null;
        try {
            object = DocumentBuilderFactory.newInstance();
            documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException(parserConfigurationException.getMessage());
        }
        documentBuilder.setErrorHandler(errorHandler);
        documentBuilder.setEntityResolver(DDResolver.getInstance());
        object = documentBuilder.parse(inputSource);
        SAXParseException sAXParseException = errorHandler.getError();
        return new DDParse((Document)object, sAXParseException);
    }

    private static class DDParse {
        private Document document;
        private SAXParseException saxException;
        private String version;

        public DDParse(Document document, SAXParseException sAXParseException) {
            this.document = document;
            this.saxException = sAXParseException;
            this.extractVersion();
        }

        public Document getDocument() {
            return this.document;
        }

        private void extractVersion() {
            String string = this.document.getDocumentElement().getAttribute("version");
            this.version = "1.1".equals(string) ? "1.1" : "1.2";
        }

        public String getVersion() {
            return this.version;
        }

        public SAXParseException getWarning() {
            return this.saxException;
        }
    }

    private static class ErrorHandler
    implements org.xml.sax.ErrorHandler {
        private int errorType = -1;
        SAXParseException error;

        private ErrorHandler() {
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
            if (this.errorType < 0) {
                this.errorType = 0;
                this.error = sAXParseException;
            }
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            if (this.errorType < 1) {
                this.errorType = 1;
                this.error = sAXParseException;
            }
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.errorType = 2;
            throw sAXParseException;
        }

        public int getErrorType() {
            return this.errorType;
        }

        public SAXParseException getError() {
            return this.error;
        }
    }

    private static class DDResolver
    implements EntityResolver {
        static DDResolver resolver;

        private DDResolver() {
        }

        static synchronized DDResolver getInstance() {
            if (resolver == null) {
                resolver = new DDResolver();
            }
            return resolver;
        }

        @Override
        public InputSource resolveEntity(String string, String string2) {
            if ("http://www.ibm.com/webservices/xsd/j2ee_web_services_1_1.xsd".equals(string2)) {
                return new InputSource("nbres:/org/netbeans/modules/j2ee/dd/impl/resources/j2ee_web_services_1_1.xsd");
            }
            if ("http://java.sun.com/xml/ns/j2ee/j2ee_web_services_1_1.xsd".equals(string2)) {
                return new InputSource("nbres:/org/netbeans/modules/j2ee/dd/impl/resources/j2ee_web_services_1_1.xsd");
            }
            if ("http://www.ibm.com/webservices/xsd/javaee_web_services_1_2.xsd".equals(string2)) {
                return new InputSource("nbres:/org/netbeans/modules/j2ee/dd/impl/resources/javaee_web_services_1_2.xsd");
            }
            if ("http://java.sun.com/xml/ns/j2ee/javaee_web_services_1_2.xsd".equals(string2)) {
                return new InputSource("nbres:/org/netbeans/modules/j2ee/dd/impl/resources/javaee_web_services_1_2.xsd");
            }
            return null;
        }
    }
}

