/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ruby.plugins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.csl.spi.support.ModificationResult;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.ProgressProviderAdapter;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyParseResult;
import org.netbeans.modules.ruby.RubyUtils;
import org.openide.filesystems.FileObject;

public abstract class RubyRefactoringPlugin
extends ProgressProviderAdapter
implements RefactoringPlugin {
    protected boolean cancelled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isCancelled() {
        RubyRefactoringPlugin rubyRefactoringPlugin = this;
        synchronized (rubyRefactoringPlugin) {
            return this.cancelled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancelRequest() {
        RubyRefactoringPlugin rubyRefactoringPlugin = this;
        synchronized (rubyRefactoringPlugin) {
            this.cancelled = true;
        }
    }

    protected static final Problem createProblem(Problem result, boolean isFatal, String message) {
        Problem problem = new Problem(isFatal, message);
        if (result == null) {
            return problem;
        }
        if (isFatal) {
            problem.setNext(result);
            return problem;
        }
        Problem p = result;
        while (p.getNext() != null) {
            p = p.getNext();
        }
        p.setNext(problem);
        return result;
    }

    protected final Collection<ModificationResult> processFiles(Set<FileObject> files, TransformTask task) {
        HashSet<Source> rubyFiles = new HashSet<Source>(2 * files.size());
        HashSet<Source> rhtmlFiles = new HashSet<Source>(2 * files.size());
        for (FileObject file : files) {
            if (RubyUtils.isRubyFile((FileObject)file)) {
                rubyFiles.add(Source.create((FileObject)file));
                continue;
            }
            if (!RubyUtils.isRhtmlOrYamlFile((FileObject)file) || file.getSize() > 524288L) continue;
            rhtmlFiles.add(Source.create((FileObject)file));
        }
        HashSet<Source> sources = new HashSet<Source>(rubyFiles.size() + rhtmlFiles.size());
        sources.addAll(rubyFiles);
        sources.addAll(rhtmlFiles);
        try {
            ParserManager.parse(sources, (UserTask)task);
            return task.results;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract class TransformTask
    extends UserTask {
        private final Collection<ModificationResult> results = new ArrayList<ModificationResult>();

        protected TransformTask() {
        }

        public final void run(ResultIterator resultIterator) throws ParseException {
            this.visit(resultIterator);
            RubyRefactoringPlugin.this.fireProgressListenerStep();
        }

        protected abstract Collection<ModificationResult> process(ParserResult var1);

        private void visit(ResultIterator resultIterator) throws ParseException {
            RubyParseResult pr;
            if (resultIterator.getSnapshot().getMimeType().equals("text/x-ruby") && (pr = AstUtilities.getParseResult((Parser.Result)resultIterator.getParserResult())) != null) {
                Collection<ModificationResult> r = this.process((ParserResult)pr);
                this.results.addAll(r);
            }
            for (Embedding e : resultIterator.getEmbeddings()) {
                this.visit(resultIterator.getResultIterator(e));
            }
        }
    }
}

