/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb;

import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.RubyFloat;
import org.jruby.nb.RubyInteger;
import org.jruby.nb.RubyMatchData;
import org.jruby.nb.RubyMath;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyNumeric;
import org.jruby.nb.RubyObject;
import org.jruby.nb.RubyRational;
import org.jruby.nb.RubyRegexp;
import org.jruby.nb.RubyString;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.Frame;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.util.Numeric;
import org.jruby.util.ByteList;

@JRubyClass(name={"Complex"}, parent="Numeric")
public class RubyComplex
extends RubyNumeric {
    private static ObjectAllocator COMPLEX_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyComplex(runtime, klass, RubyFixnum.zero(runtime), RubyFixnum.zero(runtime));
        }
    };
    private IRubyObject real;
    private IRubyObject image;
    private static final boolean CL_CANNON = true;

    public static RubyClass createComplexClass(Ruby runtime) {
        String[] undefined;
        RubyClass complexc = runtime.defineClass("Complex", runtime.getNumeric(), COMPLEX_ALLOCATOR);
        runtime.setComplex(complexc);
        complexc.index = 20;
        complexc.kindOf = new RubyModule.KindOf(){

            @Override
            public boolean isKindOf(IRubyObject obj, RubyModule type) {
                return obj instanceof RubyComplex;
            }
        };
        ThreadContext context = runtime.getCurrentContext();
        complexc.callMethod(context, "private_class_method", runtime.newSymbol("allocate"));
        complexc.defineAnnotatedMethods(RubyComplex.class);
        for (String undef : undefined = new String[]{"<", "<=", "<=>", ">", ">=", "between?", "divmod", "floor", "ceil", "modulo", "round", "step", "truncate"}) {
            complexc.undefineMethod(undef);
        }
        complexc.defineConstant("I", RubyComplex.newComplexConvert(context, RubyFixnum.zero(runtime), RubyFixnum.one(runtime)));
        return complexc;
    }

    private RubyComplex(Ruby runtime, IRubyObject clazz, IRubyObject real, IRubyObject image) {
        super(runtime, (RubyClass)clazz);
        this.real = real;
        this.image = image;
    }

    static RubyComplex newComplexRaw(Ruby runtime, IRubyObject x, RubyObject y) {
        return new RubyComplex(runtime, runtime.getComplex(), x, y);
    }

    static RubyComplex newComplexRaw(Ruby runtime, IRubyObject x) {
        return new RubyComplex(runtime, runtime.getComplex(), x, RubyFixnum.zero(runtime));
    }

    public static IRubyObject newComplexCanonicalize(ThreadContext context, IRubyObject x) {
        return RubyComplex.newComplexCanonicalize(context, x, RubyFixnum.zero(context.getRuntime()));
    }

    public static IRubyObject newComplexCanonicalize(ThreadContext context, IRubyObject x, IRubyObject y) {
        return RubyComplex.canonicalizeInternal(context, context.getRuntime().getComplex(), x, y);
    }

    static IRubyObject newComplexPolar(ThreadContext context, IRubyObject x, IRubyObject y) {
        return RubyComplex.polar(context, context.getRuntime().getComplex(), x, y);
    }

    static IRubyObject newComplex(ThreadContext context, IRubyObject clazz, IRubyObject x) {
        return RubyComplex.newComplex(context, clazz, x, RubyFixnum.zero(context.getRuntime()));
    }

    static IRubyObject newComplex(ThreadContext context, IRubyObject clazz, IRubyObject x, IRubyObject y) {
        assert (!(x instanceof RubyComplex));
        return RubyComplex.canonicalizeInternal(context, clazz, x, y);
    }

    static RubyComplex newComplexBang(ThreadContext context, IRubyObject clazz, IRubyObject x, IRubyObject y) {
        assert (x instanceof RubyComplex && y instanceof RubyComplex);
        return new RubyComplex(context.getRuntime(), clazz, x, y);
    }

    public static RubyComplex newComplexBang(ThreadContext context, IRubyObject clazz, IRubyObject x) {
        assert (x instanceof RubyComplex);
        return RubyComplex.newComplexBang(context, clazz, x, RubyFixnum.zero(context.getRuntime()));
    }

    IRubyObject getImage() {
        return this.image;
    }

    IRubyObject getReal() {
        return this.real;
    }

    private static IRubyObject m_cos(ThreadContext context, IRubyObject x) {
        if (Numeric.f_scalar_p(context, x).isTrue()) {
            return RubyMath.cos(x, x);
        }
        RubyComplex complex = (RubyComplex)x;
        return RubyComplex.newComplex(context, context.getRuntime().getComplex(), Numeric.f_mul(context, RubyMath.cos(x, complex.real), RubyMath.cosh(x, complex.image)), Numeric.f_mul(context, Numeric.f_negate(context, RubyMath.sin(x, complex.real)), RubyMath.sinh(x, complex.image)));
    }

    private static IRubyObject m_sin(ThreadContext context, IRubyObject x) {
        if (Numeric.f_scalar_p(context, x).isTrue()) {
            return RubyMath.sin(x, x);
        }
        RubyComplex complex = (RubyComplex)x;
        return RubyComplex.newComplex(context, context.getRuntime().getComplex(), Numeric.f_mul(context, RubyMath.sin(x, complex.real), RubyMath.cosh(x, complex.image)), Numeric.f_mul(context, RubyMath.cos(x, complex.real), RubyMath.sinh(x, complex.image)));
    }

    private static IRubyObject m_sqrt(ThreadContext context, IRubyObject x) {
        if (Numeric.f_scalar_p(context, x).isTrue()) {
            if (!Numeric.f_negative_p(context, x)) {
                return RubyMath.sqrt(x, x);
            }
            return RubyComplex.newComplex(context, context.getRuntime().getComplex(), RubyFixnum.zero(context.getRuntime()), RubyMath.sqrt(x, Numeric.f_negate(context, x)));
        }
        RubyComplex complex = (RubyComplex)x;
        if (Numeric.f_negative_p(context, complex.image)) {
            return Numeric.f_conjugate(context, RubyComplex.m_sqrt(context, Numeric.f_conjugate(context, x)));
        }
        IRubyObject a = Numeric.f_abs(context, x);
        RubyFixnum two = RubyFixnum.two(context.getRuntime());
        return RubyComplex.newComplex(context, context.getRuntime().getComplex(), RubyMath.sqrt(x, Numeric.f_div(context, Numeric.f_add(context, a, complex.real), two)), RubyMath.sqrt(x, Numeric.f_div(context, Numeric.f_sub(context, a, complex.real), two)));
    }

    @Deprecated
    public static IRubyObject newInstanceBang(ThreadContext context, IRubyObject recv, IRubyObject[] args) {
        switch (args.length) {
            case 1: {
                return RubyComplex.newInstanceBang(context, recv, args[0]);
            }
            case 2: {
                return RubyComplex.newInstanceBang(context, recv, args[0], args[1]);
            }
        }
        Arity.raiseArgumentError(context.getRuntime(), args.length, 1, 1);
        return null;
    }

    @JRubyMethod(name={"new!"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject newInstanceBang(ThreadContext context, IRubyObject recv, IRubyObject real) {
        if (!(real instanceof RubyNumeric)) {
            real = Numeric.f_to_i(context, real);
        }
        return new RubyComplex(context.getRuntime(), recv, real, RubyFixnum.zero(context.getRuntime()));
    }

    @JRubyMethod(name={"new!"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject newInstanceBang(ThreadContext context, IRubyObject recv, IRubyObject real, IRubyObject image) {
        if (!(real instanceof RubyNumeric)) {
            real = Numeric.f_to_i(context, real);
        }
        if (!(image instanceof RubyNumeric)) {
            image = Numeric.f_to_i(context, image);
        }
        return new RubyComplex(context.getRuntime(), recv, real, image);
    }

    private static void realCheck(ThreadContext context, IRubyObject num) {
        switch (num.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: 
            case 21: {
                break;
            }
            default: {
                if (num instanceof RubyNumeric && Numeric.f_scalar_p(context, num).isTrue()) break;
                throw context.getRuntime().newArgumentError("not a real");
            }
        }
    }

    private static IRubyObject canonicalizeInternal(ThreadContext context, IRubyObject clazz, IRubyObject real, IRubyObject image) {
        if (Numeric.f_zero_p(context, image) && ((RubyModule)clazz).fastHasConstant("Unify") && !(real instanceof RubyFloat) && !(image instanceof RubyFloat)) {
            return real;
        }
        if (Numeric.f_scalar_p(context, real).isTrue() && Numeric.f_scalar_p(context, image).isTrue()) {
            return new RubyComplex(context.getRuntime(), clazz, real, image);
        }
        if (Numeric.f_scalar_p(context, real).isTrue()) {
            RubyComplex complex = (RubyComplex)image;
            return new RubyComplex(context.getRuntime(), clazz, Numeric.f_sub(context, real, complex.image), Numeric.f_add(context, RubyFixnum.zero(context.getRuntime()), complex.real));
        }
        if (Numeric.f_scalar_p(context, image).isTrue()) {
            RubyComplex complex = (RubyComplex)real;
            return new RubyComplex(context.getRuntime(), clazz, complex.real, Numeric.f_add(context, complex.image, image));
        }
        RubyComplex complex1 = (RubyComplex)real;
        RubyComplex complex2 = (RubyComplex)image;
        return new RubyComplex(context.getRuntime(), clazz, Numeric.f_sub(context, complex1.real, complex2.image), Numeric.f_add(context, complex1.image, complex2.real));
    }

    @Deprecated
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv, IRubyObject[] args) {
        switch (args.length) {
            case 1: {
                return RubyComplex.newInstance(context, recv, args[0]);
            }
            case 2: {
                return RubyComplex.newInstance(context, recv, args[0], args[1]);
            }
        }
        Arity.raiseArgumentError(context.getRuntime(), args.length, 1, 1);
        return null;
    }

    @JRubyMethod(name={"new", "rect", "rectangular"}, meta=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv, IRubyObject real) {
        RubyComplex.realCheck(context, real);
        return RubyComplex.canonicalizeInternal(context, recv, real, RubyFixnum.zero(context.getRuntime()));
    }

    @JRubyMethod(name={"new", "rect", "rectangular"}, meta=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv, IRubyObject real, IRubyObject image) {
        RubyComplex.realCheck(context, real);
        RubyComplex.realCheck(context, image);
        return RubyComplex.canonicalizeInternal(context, recv, real, image);
    }

    private static IRubyObject f_complex_polar(ThreadContext context, IRubyObject clazz, IRubyObject x, IRubyObject y) {
        assert (!(x instanceof RubyComplex) && !(y instanceof RubyComplex));
        return RubyComplex.canonicalizeInternal(context, clazz, Numeric.f_mul(context, x, RubyComplex.m_cos(context, y)), Numeric.f_mul(context, x, RubyComplex.m_sin(context, y)));
    }

    @JRubyMethod(name={"polar"}, meta=true)
    public static IRubyObject polar(ThreadContext context, IRubyObject clazz, IRubyObject abs, IRubyObject arg) {
        return RubyComplex.f_complex_polar(context, clazz, abs, arg);
    }

    public static IRubyObject newComplexConvert(ThreadContext context, IRubyObject x) {
        return RubyComplex.newComplexConvert(context, x, RubyFixnum.zero(context.getRuntime()));
    }

    public static IRubyObject newComplexConvert(ThreadContext context, IRubyObject x, IRubyObject y) {
        return RubyComplex.convert(context, context.getRuntime().getComplex(), x, y);
    }

    @Deprecated
    public static IRubyObject convert(ThreadContext context, IRubyObject clazz, IRubyObject[] args) {
        switch (args.length) {
            case 0: {
                return RubyComplex.convert(context, clazz);
            }
            case 1: {
                return RubyComplex.convert(context, clazz, args[0]);
            }
            case 2: {
                return RubyComplex.convert(context, clazz, args[0], args[1]);
            }
        }
        Arity.raiseArgumentError(context.getRuntime(), args.length, 0, 2);
        return null;
    }

    @JRubyMethod(name={"convert"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject convert(ThreadContext context, IRubyObject recv) {
        IRubyObject nil = context.getRuntime().getNil();
        return RubyComplex.convertCommon(context, recv, nil, nil);
    }

    @JRubyMethod(name={"convert"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject convert(ThreadContext context, IRubyObject recv, IRubyObject a1) {
        return RubyComplex.convertCommon(context, recv, a1, context.getRuntime().getNil());
    }

    @JRubyMethod(name={"convert"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject convert(ThreadContext context, IRubyObject recv, IRubyObject a1, IRubyObject a2) {
        return RubyComplex.convertCommon(context, recv, a1, a2);
    }

    private static IRubyObject convertCommon(ThreadContext context, IRubyObject recv, IRubyObject a1, IRubyObject a2) {
        Frame frame = context.getCurrentFrame();
        IRubyObject backref = frame.getBackRef();
        if (backref != null && backref instanceof RubyMatchData) {
            ((RubyMatchData)backref).use();
        }
        if (a1 instanceof RubyString) {
            a1 = RubyComplex.str_to_c_strict(context, a1);
        }
        if (a2 instanceof RubyString) {
            a2 = RubyComplex.str_to_c_strict(context, a2);
        }
        frame.setBackRef(backref);
        if (a1 instanceof RubyComplex) {
            RubyComplex a1Complex = (RubyComplex)a1;
            if (!(a1Complex.image instanceof RubyFloat) && Numeric.f_zero_p(context, a1Complex.image)) {
                a1 = a1Complex.real;
            }
        }
        if (a2 instanceof RubyComplex) {
            RubyComplex a2Complex = (RubyComplex)a2;
            if (!(a2Complex.image instanceof RubyFloat) && Numeric.f_zero_p(context, a2Complex.image)) {
                a2 = a2Complex.real;
            }
        }
        if (a1 instanceof RubyComplex && (a2.isNil() || Numeric.f_zero_p(context, a2))) {
            return a1;
        }
        return a2.isNil() ? RubyComplex.newInstance(context, recv, a1) : RubyComplex.newInstance(context, recv, a1, a2);
    }

    @JRubyMethod(name={"real"})
    public IRubyObject real() {
        return this.real;
    }

    @JRubyMethod(name={"image", "imag"})
    public IRubyObject image() {
        return this.image;
    }

    @JRubyMethod(name={"+"})
    public IRubyObject op_add(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyComplex) {
            RubyComplex otherComplex = (RubyComplex)other;
            return RubyComplex.newComplex(context, this.getMetaClass(), Numeric.f_add(context, this.real, otherComplex.real), Numeric.f_add(context, this.image, otherComplex.image));
        }
        if (other instanceof RubyNumeric && Numeric.f_scalar_p(context, other).isTrue()) {
            return RubyComplex.newComplex(context, this.getMetaClass(), Numeric.f_add(context, this.real, other), this.image);
        }
        return this.coerceBin(context, "+", other);
    }

    @JRubyMethod(name={"-"})
    public IRubyObject op_sub(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyComplex) {
            RubyComplex otherComplex = (RubyComplex)other;
            return RubyComplex.newComplex(context, this.getMetaClass(), Numeric.f_sub(context, this.real, otherComplex.real), Numeric.f_sub(context, this.image, otherComplex.image));
        }
        if (other instanceof RubyNumeric && Numeric.f_scalar_p(context, other).isTrue()) {
            return RubyComplex.newComplex(context, this.getMetaClass(), Numeric.f_sub(context, this.real, other), this.image);
        }
        return this.coerceBin(context, "-", other);
    }

    @JRubyMethod(name={"*"})
    public IRubyObject op_mul(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyComplex) {
            RubyComplex otherComplex = (RubyComplex)other;
            IRubyObject realp = Numeric.f_sub(context, Numeric.f_mul(context, this.real, otherComplex.real), Numeric.f_mul(context, this.image, otherComplex.image));
            IRubyObject imagep = Numeric.f_add(context, Numeric.f_mul(context, this.real, otherComplex.image), Numeric.f_mul(context, this.image, otherComplex.real));
            return RubyComplex.newComplex(context, this.getMetaClass(), realp, imagep);
        }
        if (other instanceof RubyNumeric && Numeric.f_scalar_p(context, other).isTrue()) {
            return RubyComplex.newComplex(context, this.getMetaClass(), Numeric.f_mul(context, this.real, other), Numeric.f_mul(context, this.image, other));
        }
        return this.coerceBin(context, "*", other);
    }

    @JRubyMethod(name={"/"})
    public IRubyObject op_div(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyComplex) {
            RubyComplex otherComplex = (RubyComplex)other;
            if (this.real instanceof RubyFloat || this.image instanceof RubyFloat || otherComplex.real instanceof RubyFloat || otherComplex.image instanceof RubyFloat) {
                RubyFloat magn = RubyMath.hypot(this, otherComplex.real, otherComplex.image);
                RubyComplex tmp = RubyComplex.newComplexBang(context, this.getMetaClass(), Numeric.f_quo(context, otherComplex.real, magn), Numeric.f_quo(context, otherComplex.image, magn));
                return Numeric.f_quo(context, Numeric.f_mul(context, this, Numeric.f_conjugate(context, tmp)), magn);
            }
            return Numeric.f_quo(context, Numeric.f_mul(context, this, Numeric.f_conjugate(context, other)), Numeric.f_abs2(context, other));
        }
        if (other instanceof RubyNumeric && Numeric.f_scalar_p(context, other).isTrue()) {
            return RubyComplex.newComplex(context, this.getMetaClass(), Numeric.f_quo(context, this.real, other), Numeric.f_quo(context, this.image, other));
        }
        return this.coerceBin(context, "/", other);
    }

    @Override
    @JRubyMethod(name={"fdiv", "quo"})
    public IRubyObject fdiv(ThreadContext context, IRubyObject other) {
        IRubyObject complex = RubyComplex.newComplex(context, this.getMetaClass(), Numeric.f_to_f(context, this.real), Numeric.f_to_f(context, this.image));
        return Numeric.f_div(context, complex, other);
    }

    @JRubyMethod(name={"**"})
    public IRubyObject op_expt(ThreadContext context, IRubyObject other) {
        if (Numeric.f_zero_p(context, other)) {
            return RubyComplex.newComplexBang(context, this.getMetaClass(), RubyFixnum.one(context.getRuntime()));
        }
        if (other instanceof RubyRational && Numeric.f_one_p(context, Numeric.f_denominator(context, other))) {
            other = Numeric.f_numerator(context, other);
        }
        if (other instanceof RubyComplex) {
            RubyArray a = Numeric.f_polar(context, this).convertToArray();
            IRubyObject r = a.eltInternal(0);
            IRubyObject theta = a.eltInternal(1);
            RubyComplex otherComplex = (RubyComplex)other;
            RubyFloat nr = RubyMath.exp(this, Numeric.f_sub(context, Numeric.f_mul(context, otherComplex.real, RubyMath.log(this, r)), Numeric.f_mul(context, otherComplex.image, theta)));
            IRubyObject ntheta = Numeric.f_add(context, Numeric.f_mul(context, theta, otherComplex.real), Numeric.f_mul(context, otherComplex.image, RubyMath.log(this, r)));
            return RubyComplex.polar(context, this.getMetaClass(), nr, ntheta);
        }
        if (other instanceof RubyInteger) {
            RubyFixnum one = RubyFixnum.one(context.getRuntime());
            if (Numeric.f_gt_p(context, other, RubyFixnum.zero(context.getRuntime())).isTrue()) {
                IRubyObject x;
                IRubyObject z = x = this;
                IRubyObject n = Numeric.f_sub(context, other, one);
                RubyFixnum two = RubyFixnum.two(context.getRuntime());
                while (!Numeric.f_zero_p(context, n)) {
                    RubyArray a = Numeric.f_divmod(context, n, two).convertToArray();
                    while (Numeric.f_zero_p(context, a.eltInternal(1))) {
                        RubyComplex xComplex = x;
                        x = RubyComplex.newComplex(context, this.getMetaClass(), Numeric.f_sub(context, Numeric.f_mul(context, xComplex.real, xComplex.real), Numeric.f_mul(context, xComplex.image, xComplex.image)), Numeric.f_mul(context, Numeric.f_mul(context, two, xComplex.real), xComplex.image));
                        n = a.eltInternal(0);
                        a = Numeric.f_divmod(context, n, two).convertToArray();
                    }
                    z = Numeric.f_mul(context, z, x);
                    n = Numeric.f_sub(context, n, one);
                }
                return z;
            }
            return Numeric.f_expt(context, Numeric.f_div(context, Numeric.f_to_r(context, one), this), Numeric.f_negate(context, other));
        }
        if (other instanceof RubyNumeric && Numeric.f_scalar_p(context, other).isTrue()) {
            RubyArray a = Numeric.f_polar(context, this).convertToArray();
            IRubyObject r = a.eltInternal(0);
            IRubyObject theta = a.eltInternal(1);
            return RubyComplex.f_complex_polar(context, this.getMetaClass(), Numeric.f_expt(context, r, other), Numeric.f_mul(context, theta, other));
        }
        return this.coerceBin(context, "**", other);
    }

    @Override
    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyComplex) {
            RubyComplex otherComplex = (RubyComplex)other;
            if (Numeric.f_equal_p(context, this.real, otherComplex.real) && Numeric.f_equal_p(context, this.image, otherComplex.image)) {
                return context.getRuntime().getTrue();
            }
            return context.getRuntime().getFalse();
        }
        if (other instanceof RubyNumeric && Numeric.f_scalar_p(context, other).isTrue()) {
            if (Numeric.f_equal_p(context, this.real, other) && Numeric.f_zero_p(context, this.image)) {
                return context.getRuntime().getTrue();
            }
            return context.getRuntime().getFalse();
        }
        return Numeric.f_equal_p(context, other, this) ? context.getRuntime().getTrue() : context.getRuntime().getFalse();
    }

    @JRubyMethod(name={"coerce"})
    public IRubyObject coerce(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyNumeric && Numeric.f_scalar_p(context, other).isTrue()) {
            return context.getRuntime().newArray(RubyComplex.newComplexBang(context, this.getMetaClass(), other), this);
        }
        throw context.getRuntime().newTypeError(other.getMetaClass().getName() + " can't be coerced into " + this.getMetaClass().getName());
    }

    @Override
    @JRubyMethod(name={"abs", "magnitude"})
    public IRubyObject abs(ThreadContext context) {
        return RubyMath.hypot(this, this.real, this.image);
    }

    @JRubyMethod(name={"abs2"})
    public IRubyObject abs2(ThreadContext context) {
        return Numeric.f_add(context, Numeric.f_mul(context, this.real, this.real), Numeric.f_mul(context, this.image, this.image));
    }

    @Override
    @JRubyMethod(name={"arg", "angle"})
    public IRubyObject arg(ThreadContext context) {
        return RubyMath.atan2(this, this.image, this.real);
    }

    @Override
    @JRubyMethod(name={"polar"})
    public IRubyObject polar(ThreadContext context) {
        return context.getRuntime().newArray(Numeric.f_abs(context, this), Numeric.f_arg(context, this));
    }

    @Override
    @JRubyMethod(name={"conjugate", "conj", "~"})
    public IRubyObject conjugate(ThreadContext context) {
        return RubyComplex.newComplex(context, this.getMetaClass(), this.real, Numeric.f_negate(context, this.image));
    }

    public IRubyObject real_p(ThreadContext context) {
        return context.getRuntime().getFalse();
    }

    public IRubyObject complex_p(ThreadContext context) {
        return context.getRuntime().getTrue();
    }

    public IRubyObject exact_p(ThreadContext context) {
        return Numeric.f_exact_p(context, this.real).isTrue() && Numeric.f_exact_p(context, this.image).isTrue() ? context.getRuntime().getTrue() : context.getRuntime().getFalse();
    }

    public IRubyObject inexact_p(ThreadContext context) {
        return this.exact_p(context).isTrue() ? context.getRuntime().getFalse() : context.getRuntime().getTrue();
    }

    @JRubyMethod(name={"denominator"})
    public IRubyObject demoninator(ThreadContext context) {
        return Numeric.f_lcm(context, Numeric.f_denominator(context, this.real), Numeric.f_denominator(context, this.image));
    }

    @Override
    @JRubyMethod(name={"numerator"})
    public IRubyObject numerator(ThreadContext context) {
        IRubyObject cd = this.callMethod(context, "denominator");
        return RubyComplex.newComplex(context, this.getMetaClass(), Numeric.f_mul(context, Numeric.f_numerator(context, this.real), Numeric.f_div(context, cd, Numeric.f_denominator(context, this.real))), Numeric.f_mul(context, Numeric.f_numerator(context, this.image), Numeric.f_div(context, cd, Numeric.f_denominator(context, this.image))));
    }

    @JRubyMethod(name={"hash"})
    public IRubyObject hash(ThreadContext context) {
        return Numeric.f_xor(context, this.real, this.image);
    }

    private static boolean signbit(ThreadContext context, IRubyObject x) {
        if (x instanceof RubyFloat) {
            return Double.doubleToLongBits(((RubyFloat)x).getDoubleValue()) < 0L;
        }
        return Numeric.f_negative_p(context, x);
    }

    private static boolean tpositive_p(ThreadContext context, IRubyObject x) {
        return !RubyComplex.signbit(context, x);
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s(ThreadContext context) {
        boolean impos = RubyComplex.tpositive_p(context, this.image);
        RubyString str = Numeric.f_to_s(context, this.real).convertToString();
        str.cat(impos ? (byte)43 : 45);
        str.cat(Numeric.f_to_s(context, Numeric.f_abs(context, this.image)).convertToString().getByteList());
        str.cat((byte)105);
        return str;
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        boolean impos = RubyComplex.tpositive_p(context, this.image);
        RubyString str = context.getRuntime().newString();
        str.cat((byte)40);
        str.cat(Numeric.f_inspect(context, this.real).convertToString().getByteList());
        str.cat(impos ? (byte)43 : 45);
        str.cat(Numeric.f_inspect(context, Numeric.f_abs(context, this.image)).convertToString().getByteList());
        str.cat((byte)105);
        str.cat((byte)41);
        return str;
    }

    @JRubyMethod(name={"marshal_dump"})
    public IRubyObject marshal_dump(ThreadContext context) {
        return context.getRuntime().newArray(this.real, this.image);
    }

    @JRubyMethod(name={"marshal_load"})
    public IRubyObject marshal_load(ThreadContext context, IRubyObject arg) {
        RubyArray a = arg.convertToArray();
        this.real = a.size() > 0 ? a.eltInternal(0) : context.getRuntime().getNil();
        this.image = a.size() > 1 ? a.eltInternal(1) : context.getRuntime().getNil();
        return this;
    }

    @JRubyMethod(name={"scalar?"})
    public IRubyObject scalar_p(ThreadContext context) {
        return context.getRuntime().getFalse();
    }

    @JRubyMethod(name={"to_i"})
    public IRubyObject to_i(ThreadContext context) {
        if (this.image instanceof RubyFloat || !Numeric.f_zero_p(context, this.image)) {
            throw context.getRuntime().newRangeError("can't convert " + Numeric.f_to_s(context, this).convertToString() + " into Integer");
        }
        return Numeric.f_to_i(context, this.real);
    }

    @JRubyMethod(name={"to_f"})
    public IRubyObject to_f(ThreadContext context) {
        if (this.image instanceof RubyFloat || !Numeric.f_zero_p(context, this.image)) {
            throw context.getRuntime().newRangeError("can't convert " + Numeric.f_to_s(context, this).convertToString() + " into Float");
        }
        return Numeric.f_to_f(context, this.real);
    }

    @JRubyMethod(name={"to_r"})
    public IRubyObject to_r(ThreadContext context) {
        if (this.image instanceof RubyFloat || !Numeric.f_zero_p(context, this.image)) {
            throw context.getRuntime().newRangeError("can't convert " + Numeric.f_to_s(context, this).convertToString() + " into Rational");
        }
        return Numeric.f_to_r(context, this.real);
    }

    static RubyArray str_to_c_internal(ThreadContext context, IRubyObject recv) {
        IRubyObject r;
        IRubyObject t;
        IRubyObject re;
        RubyString s = recv.callMethod(context, "strip").convertToString();
        ByteList bytes = s.getByteList();
        Ruby runtime = context.getRuntime();
        if (bytes.realSize == 0) {
            return runtime.newArray(runtime.getNil(), recv);
        }
        IRubyObject si = re = runtime.getNil();
        IRubyObject sr = re;
        boolean po = false;
        IRubyObject m = RubyRegexp.newRegexp(runtime, Numeric.ComplexPatterns.comp_pat0).callMethod(context, "match", s);
        if (!m.isNil()) {
            sr = m.callMethod(context, "[]", RubyFixnum.one(runtime));
            si = m.callMethod(context, "[]", RubyFixnum.two(runtime));
            re = m.callMethod(context, "post_match");
            po = true;
        }
        if (m.isNil() && !(m = RubyRegexp.newRegexp(runtime, Numeric.ComplexPatterns.comp_pat1).callMethod(context, "match", s)).isNil()) {
            sr = runtime.getNil();
            si = m.callMethod(context, "[]", RubyFixnum.one(runtime));
            if (si.isNil()) {
                si = runtime.newString();
            }
            if ((t = m.callMethod(context, "[]", RubyFixnum.two(runtime))).isNil()) {
                t = runtime.newString(new ByteList(new byte[]{49}));
            }
            si.convertToString().cat(t.convertToString().getByteList());
            re = m.callMethod(context, "post_match");
            po = false;
        }
        if (m.isNil()) {
            m = RubyRegexp.newRegexp(runtime, Numeric.ComplexPatterns.comp_pat2).callMethod(context, "match", s);
            if (m.isNil()) {
                return runtime.newArray(runtime.getNil(), recv);
            }
            sr = m.callMethod(context, "[]", RubyFixnum.one(runtime));
            if (m.callMethod(context, "[]", RubyFixnum.two(runtime)).isNil()) {
                si = runtime.getNil();
            } else {
                si = m.callMethod(context, "[]", RubyFixnum.three(runtime));
                t = m.callMethod(context, "[]", RubyFixnum.four(runtime));
                if (t.isNil()) {
                    t = runtime.newString(new ByteList(new byte[]{49}));
                }
                si.convertToString().cat(t.convertToString().getByteList());
            }
            re = m.callMethod(context, "post_match");
            po = false;
        }
        IRubyObject i = r = RubyFixnum.zero(runtime);
        if (!sr.isNil()) {
            r = sr.callMethod(context, "include?", runtime.newString(new ByteList(new byte[]{47}))).isTrue() ? Numeric.f_to_r(context, sr) : (Numeric.f_gt_p(context, sr.callMethod(context, "count", runtime.newString(".eE")), RubyFixnum.zero(runtime)).isTrue() ? Numeric.f_to_f(context, sr) : Numeric.f_to_i(context, sr));
        }
        if (!si.isNil()) {
            i = si.callMethod(context, "include?", runtime.newString(new ByteList(new byte[]{47}))).isTrue() ? Numeric.f_to_r(context, si) : (Numeric.f_gt_p(context, si.callMethod(context, "count", runtime.newString(".eE")), RubyFixnum.zero(runtime)).isTrue() ? Numeric.f_to_f(context, si) : Numeric.f_to_i(context, si));
        }
        return runtime.newArray(po ? RubyComplex.newComplexPolar(context, r, i) : RubyComplex.newComplexCanonicalize(context, r, i), re);
    }

    private static IRubyObject str_to_c_strict(ThreadContext context, IRubyObject recv) {
        RubyArray a = RubyComplex.str_to_c_internal(context, recv);
        if (a.eltInternal(0).isNil() || a.eltInternal(1).convertToString().getByteList().length() > 0) {
            IRubyObject s = recv.callMethod(context, "inspect");
            throw context.getRuntime().newArgumentError("invalid value for Complex: " + s.convertToString());
        }
        return a.eltInternal(0);
    }
}

