/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreeScanner;
import java.util.List;
import org.netbeans.modules.debugger.jpda.projects.AST2Bytecode;
import org.netbeans.spi.debugger.jpda.EditorContext;

class MethodArgumentsScanner
extends TreeScanner<EditorContext.MethodArgument[], Object> {
    private int offset;
    private CompilationUnitTree tree;
    private SourcePositions positions;
    private LineMap lineMap;
    private boolean methodInvocation;
    private AST2Bytecode.OperationCreationDelegate positionDelegate;
    private EditorContext.MethodArgument[] arguments;

    public MethodArgumentsScanner(int n, CompilationUnitTree compilationUnitTree, SourcePositions sourcePositions, boolean bl, AST2Bytecode.OperationCreationDelegate operationCreationDelegate) {
        this.offset = n;
        this.tree = compilationUnitTree;
        this.positions = sourcePositions;
        this.lineMap = compilationUnitTree.getLineMap();
        this.methodInvocation = bl;
        this.positionDelegate = operationCreationDelegate;
    }

    @Override
    public EditorContext.MethodArgument[] visitMethodInvocation(MethodInvocationTree methodInvocationTree, Object object) {
        if (!this.methodInvocation || (long)this.offset != this.positions.getEndPosition(this.tree, methodInvocationTree.getMethodSelect())) {
            return (EditorContext.MethodArgument[])super.visitMethodInvocation(methodInvocationTree, object);
        }
        List<? extends ExpressionTree> list = methodInvocationTree.getArguments();
        List<? extends Tree> list2 = methodInvocationTree.getTypeArguments();
        this.arguments = this.composeArguments(list, list2);
        return this.arguments;
    }

    @Override
    public EditorContext.MethodArgument[] visitNewClass(NewClassTree newClassTree, Object object) {
        if (!this.methodInvocation || (long)this.offset != this.positions.getEndPosition(this.tree, newClassTree.getIdentifier())) {
            return (EditorContext.MethodArgument[])super.visitNewClass(newClassTree, object);
        }
        List<? extends ExpressionTree> list = newClassTree.getArguments();
        List<? extends Tree> list2 = newClassTree.getTypeArguments();
        this.arguments = this.composeArguments(list, list2);
        return this.arguments;
    }

    @Override
    public EditorContext.MethodArgument[] visitMethod(MethodTree methodTree, Object object) {
        long l = this.positions.getStartPosition(this.tree, methodTree);
        long l2 = this.positions.getEndPosition(this.tree, methodTree);
        if (this.methodInvocation || l == -1L || l2 == -1L || (long)this.offset < this.lineMap.getLineNumber(l) || (long)this.offset > this.lineMap.getLineNumber(l2)) {
            return (EditorContext.MethodArgument[])super.visitMethod(methodTree, object);
        }
        List<? extends VariableTree> list = methodTree.getParameters();
        List<? extends TypeParameterTree> list2 = methodTree.getTypeParameters();
        int n = list.size();
        this.arguments = new EditorContext.MethodArgument[n];
        for (int i = 0; i < n; ++i) {
            VariableTree variableTree = list.get(i);
            long l3 = this.positions.getStartPosition(this.tree, variableTree);
            long l4 = this.positions.getEndPosition(this.tree, variableTree);
            if (l3 == -1L || l4 == -1L) {
                return new EditorContext.MethodArgument[0];
            }
            this.arguments[i] = new EditorContext.MethodArgument(variableTree.getName().toString(), variableTree.getType().toString(), this.positionDelegate.createPosition((int)l3, (int)this.lineMap.getLineNumber(l3), (int)this.lineMap.getColumnNumber(l3)), this.positionDelegate.createPosition((int)l4, (int)this.lineMap.getLineNumber(l4), (int)this.lineMap.getColumnNumber(l4)));
        }
        return this.arguments;
    }

    EditorContext.MethodArgument[] getArguments() {
        return this.arguments;
    }

    private final EditorContext.MethodArgument[] composeArguments(List<? extends Tree> list, List<? extends Tree> list2) {
        int n = list.size();
        EditorContext.MethodArgument[] methodArgumentArray = new EditorContext.MethodArgument[n];
        for (int i = 0; i < n; ++i) {
            Tree tree = list.get(i);
            long l = this.positions.getStartPosition(this.tree, tree);
            long l2 = this.positions.getEndPosition(this.tree, tree);
            if (l == -1L || l2 == -1L) {
                return new EditorContext.MethodArgument[0];
            }
            methodArgumentArray[i] = new EditorContext.MethodArgument(tree.toString(), list2.size() > i ? list2.get(i).toString() : "", this.positionDelegate.createPosition((int)l, (int)this.lineMap.getLineNumber(l), (int)this.lineMap.getColumnNumber(l)), this.positionDelegate.createPosition((int)l2, (int)this.lineMap.getLineNumber(l2), (int)this.lineMap.getColumnNumber(l2)));
        }
        return methodArgumentArray;
    }
}

