/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.models;

import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.debugger.common.CallStackFrame;
import org.netbeans.modules.cnd.debugger.common.EditorContextBridge;
import org.netbeans.modules.cnd.debugger.gdb.GdbCallStackFrame;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.disassembly.Disassembly;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class CallStackActionsProvider
implements NodeActionsProvider {
    private final Action MAKE_CURRENT_ACTION = Models.createAction((String)NbBundle.getBundle(CallStackActionsProvider.class).getString("CTL_CallstackAction_MakeCurrent_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            return true;
        }

        public void perform(Object[] nodes) {
            CallStackActionsProvider.this.makeCurrent((GdbCallStackFrame)((Object)nodes[0]));
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    private final Action POP_TO_HERE_ACTION = Models.createAction((String)NbBundle.getBundle(CallStackActionsProvider.class).getString("CTL_CallstackAction_PopToHere_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            return true;
        }

        public void perform(Object[] nodes) {
            CallStackActionsProvider.this.popToHere((GdbCallStackFrame)((Object)nodes[0]));
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    private final GdbDebugger debugger;

    public CallStackActionsProvider(ContextProvider lookupProvider) {
        this.debugger = (GdbDebugger)lookupProvider.lookupFirst(null, GdbDebugger.class);
    }

    public Action[] getActions(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return new Action[0];
        }
        if (!(node instanceof GdbCallStackFrame)) {
            throw new UnknownTypeException(node);
        }
        return new Action[]{this.MAKE_CURRENT_ACTION, this.POP_TO_HERE_ACTION};
    }

    public void performDefaultAction(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return;
        }
        if (node instanceof GdbCallStackFrame) {
            this.makeCurrent((GdbCallStackFrame)((Object)node));
            return;
        }
        throw new UnknownTypeException(node);
    }

    public void addModelListener(ModelListener l) {
    }

    public void removeModelListener(ModelListener l) {
    }

    private void popToHere(GdbCallStackFrame frame) {
        if (!frame.isValid()) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_InvalidCallStackFrame")));
        } else {
            this.debugger.getGdbProxy().stack_select_frame(frame.getFrameNumber() - 1);
            this.debugger.getGdbProxy().exec_finish();
            this.makeCurrent(frame);
        }
    }

    private void makeCurrent(final GdbCallStackFrame frame) {
        if (this.debugger.getCurrentCallStackFrame() != frame) {
            if (frame.isValid()) {
                frame.makeCurrent();
            } else {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_InvalidCallStackFrame")));
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EditorContextBridge.showSource((CallStackFrame)frame, (boolean)Disassembly.isInDisasm());
                }
            });
        }
    }
}

