/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.model.adapter;

import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.vmd.game.model.GlobalRepository;
import org.netbeans.modules.vmd.game.model.GlobalRepositoryListener;
import org.netbeans.modules.vmd.game.model.ImageResource;
import org.netbeans.modules.vmd.game.model.Layer;
import org.netbeans.modules.vmd.game.model.Scene;
import org.netbeans.modules.vmd.game.model.SceneListener;
import org.netbeans.modules.vmd.game.model.Sprite;
import org.netbeans.modules.vmd.game.model.TiledLayer;

public class GlobalRepositoryTreeAdapter
implements TreeModel,
GlobalRepositoryListener,
SceneListener,
PropertyChangeListener {
    private static final boolean DEBUG = false;
    private EventListenerList listenerList;
    private GlobalRepository globalRepository;

    public GlobalRepositoryTreeAdapter(GlobalRepository globalRepository) {
        this.globalRepository = globalRepository;
        this.listenerList = new EventListenerList();
        this.registerListeners();
    }

    private void registerListeners() {
        this.globalRepository.addGlobalRepositoryListener(this);
        for (Scene scene : this.globalRepository.getScenes()) {
            scene.addSceneListener(this);
            scene.addPropertyChangeListener(this);
            for (Layer layer : scene.getLayers()) {
                layer.addPropertyChangeListener(this);
            }
        }
    }

    @Override
    public Object getRoot() {
        return this.globalRepository;
    }

    @Override
    public Object getChild(Object object, int n) {
        if (object == this.globalRepository) {
            int n2 = this.globalRepository.getScenes().size();
            if (n >= n2) {
                return null;
            }
            return this.globalRepository.getScenes().get(n);
        }
        if (object instanceof Scene) {
            return ((Scene)object).getLayerAt(n);
        }
        return null;
    }

    @Override
    public int getChildCount(Object object) {
        if (object == this.globalRepository) {
            return this.globalRepository.getScenes().size();
        }
        if (object instanceof Scene) {
            return ((Scene)object).getLayers().size();
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object object) {
        return object != this.globalRepository && !(object instanceof Scene);
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        if (object == this.globalRepository) {
            return this.globalRepository.getScenes().indexOf((Scene)object2);
        }
        if (object instanceof Scene) {
            return ((Scene)object).indexOf((Layer)object2);
        }
        return -1;
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.add(TreeModelListener.class, treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.remove(TreeModelListener.class, treeModelListener);
    }

    @Override
    public void sceneAdded(Scene scene, int n) {
        scene.addPropertyChangeListener(this);
        scene.addSceneListener(this);
        TreePath treePath = new TreePath(this.getRoot());
        this.fireNodeInserted(treePath, n, scene);
    }

    @Override
    public void sceneRemoved(Scene scene, int n) {
        scene.removePropertyChangeListener(this);
        scene.removeSceneListener(this);
        TreePath treePath = new TreePath(this.getRoot());
        this.fireNodeRemoved(treePath, n, scene);
    }

    @Override
    public void tiledLayerAdded(TiledLayer tiledLayer, int n) {
        tiledLayer.addPropertyChangeListener(this);
    }

    @Override
    public void tiledLayerRemoved(TiledLayer tiledLayer, int n) {
        tiledLayer.removePropertyChangeListener(this);
    }

    @Override
    public void spriteAdded(Sprite sprite, int n) {
        sprite.addPropertyChangeListener(this);
    }

    @Override
    public void spriteRemoved(Sprite sprite, int n) {
        sprite.removePropertyChangeListener(this);
    }

    @Override
    public void imageResourceAdded(ImageResource imageResource) {
    }

    private void fireNodeInserted(TreePath treePath, int n, Object object) {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, new int[]{n}, new Object[]{object});
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeModelListener.class) continue;
            ((TreeModelListener)objectArray[i + 1]).treeNodesInserted(treeModelEvent);
        }
    }

    private void fireNodeRemoved(TreePath treePath, int n, Object object) {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, new int[]{n}, new Object[]{object});
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeModelListener.class) continue;
            ((TreeModelListener)objectArray[i + 1]).treeNodesRemoved(treeModelEvent);
        }
    }

    private void fireNodeChanged(TreePath treePath, int n, Object object) {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, new int[]{n}, new Object[]{object});
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeModelListener.class) continue;
            ((TreeModelListener)objectArray[i + 1]).treeNodesChanged(treeModelEvent);
        }
    }

    @Override
    public void layerAdded(Scene scene, Layer layer, int n) {
        TreePath treePath = new TreePath(new Object[]{this.getRoot(), scene});
        this.fireNodeInserted(treePath, n, layer);
    }

    @Override
    public void layerRemoved(Scene scene, Layer layer, Scene.LayerInfo layerInfo, int n) {
        TreePath treePath = new TreePath(new Object[]{this.getRoot(), scene});
        this.fireNodeRemoved(treePath, n, layer);
    }

    @Override
    public void layerMoved(Scene scene, Layer layer, int n, int n2) {
        this.layerRemoved(scene, layer, null, n);
        this.layerAdded(scene, layer, n2);
    }

    @Override
    public void layerPositionChanged(Scene scene, Layer layer, Point point, Point point2, boolean bl) {
    }

    @Override
    public void layerLockChanged(Scene scene, Layer layer, boolean bl) {
    }

    @Override
    public void layerVisibilityChanged(Scene scene, Layer layer, boolean bl) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        if (propertyChangeEvent.getPropertyName().equals("editable.prop.name")) {
            if (object instanceof Scene) {
                Scene scene = (Scene)object;
                TreePath treePath = new TreePath(this.getRoot());
                this.fireNodeChanged(treePath, this.globalRepository.getScenes().indexOf(scene), scene);
            } else if (object instanceof Layer) {
                Layer layer = (Layer)object;
                for (Scene scene : this.globalRepository.getScenes()) {
                    if (!scene.getLayers().contains(layer)) continue;
                    TreePath treePath = new TreePath(new Object[]{this.getRoot(), scene});
                    this.fireNodeChanged(treePath, scene.getLayers().indexOf(layer), layer);
                }
            }
        }
    }
}

