/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.palette;

import java.awt.Image;
import java.io.IOException;
import java.util.List;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.ProjectUtils;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.common.ActiveDocumentSupport;
import org.netbeans.modules.vmd.palette.PaletteItemDataObject;
import org.netbeans.modules.vmd.palette.PaletteMap;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;

public class PaletteItemDataNode
extends DataNode {
    private static Image errorBadge = ImageUtilities.loadImage((String)"org/netbeans/modules/vmd/palette/resources/error-badge.gif");
    private PaletteItemDataObject obj;
    private Lookup lookup;
    private boolean isValid = true;
    private boolean needCheck = true;

    public PaletteItemDataNode(PaletteItemDataObject paletteItemDataObject) {
        this(paletteItemDataObject, new InstanceContent());
    }

    private PaletteItemDataNode(PaletteItemDataObject paletteItemDataObject, InstanceContent instanceContent) {
        super((DataObject)paletteItemDataObject, Children.LEAF, (Lookup)new AbstractLookup((AbstractLookup.Content)instanceContent));
        instanceContent.add((Object)paletteItemDataObject);
        instanceContent.add((Object)this);
        this.obj = paletteItemDataObject;
        this.lookup = Lookups.singleton((Object)((Object)this));
    }

    public String getDisplayName() {
        return this.obj.getDisplayName();
    }

    public String getShortDescription() {
        return this.obj.getToolTip();
    }

    public Image getIcon(int n) {
        if (this.needCheck) {
            PaletteMap.getInstance().checkValidity(this.getProjectType(), this.lookup);
        }
        if (n == 1 || n == 3) {
            String string = this.obj.getIcon();
            Image image = null;
            if (string != null) {
                image = ImageUtilities.loadImage((String)string);
            }
            if (image == null) {
                image = super.getIcon(n);
            }
            if (!this.isValid) {
                image = ImageUtilities.mergeImages((Image)image, (Image)errorBadge, (int)errorBadge.getWidth(null), (int)errorBadge.getHeight(null));
            }
            return image;
        }
        String string = this.obj.getBigIcon();
        Image image = null;
        if (string != null) {
            image = ImageUtilities.loadImage((String)string);
        }
        if (image == null) {
            image = super.getIcon(n);
        }
        if (!this.isValid) {
            image = ImageUtilities.mergeImages((Image)image, (Image)errorBadge, (int)errorBadge.getWidth(null), (int)errorBadge.getHeight(null));
        }
        return image;
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    String getProjectType() {
        return this.obj.getProjectType();
    }

    String getProducerID() {
        return this.obj.getProducerID();
    }

    void setValid(boolean bl) {
        this.isValid = bl;
    }

    boolean isValid() {
        return this.isValid;
    }

    void setNeedCheck(boolean bl) {
        this.needCheck = bl;
    }

    public boolean canRename() {
        return false;
    }

    public boolean canDestroy() {
        DataObjectContext dataObjectContext;
        boolean bl = false;
        DesignDocument designDocument = ActiveDocumentSupport.getDefault().getActiveDocument();
        if (designDocument != null && (dataObjectContext = ProjectUtils.getDataObjectContextForDocument((DesignDocument)designDocument)) != null) {
            final ComponentProducer[] componentProducerArray = new ComponentProducer[1];
            final DescriptorRegistry descriptorRegistry = DescriptorRegistry.getDescriptorRegistry((String)dataObjectContext.getProjectType(), (String)dataObjectContext.getProjectID());
            descriptorRegistry.readAccess(new Runnable(){

                @Override
                public void run() {
                    List list = descriptorRegistry.getComponentProducers();
                    for (ComponentProducer componentProducer : list) {
                        if (!componentProducer.getProducerID().equals(PaletteItemDataNode.this.obj.getProducerID())) continue;
                        componentProducerArray[0] = componentProducer;
                        break;
                    }
                }
            });
            if (componentProducerArray[0] != null) {
                bl = "custom".equals(componentProducerArray[0].getPaletteDescriptor().getCategoryID());
            }
        }
        return bl;
    }

    public void destroy() throws IOException {
        DataObjectContext dataObjectContext;
        super.destroy();
        DesignDocument designDocument = ActiveDocumentSupport.getDefault().getActiveDocument();
        if (designDocument != null && (dataObjectContext = ProjectUtils.getDataObjectContextForDocument((DesignDocument)designDocument)) != null) {
            final ComponentProducer[] componentProducerArray = new ComponentProducer[1];
            final DescriptorRegistry descriptorRegistry = DescriptorRegistry.getDescriptorRegistry((String)dataObjectContext.getProjectType(), (String)dataObjectContext.getProjectID());
            descriptorRegistry.readAccess(new Runnable(){

                @Override
                public void run() {
                    List list = descriptorRegistry.getComponentProducers();
                    for (ComponentProducer componentProducer : list) {
                        if (!componentProducer.getProducerID().equals(PaletteItemDataNode.this.obj.getProducerID())) continue;
                        componentProducerArray[0] = componentProducer;
                        break;
                    }
                }
            });
            if (componentProducerArray[0] != null) {
                descriptorRegistry.removeComponentDescriptor(componentProducerArray[0].getMainComponentTypeID());
            }
        }
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }
}

