/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.io;

import java.util.HashMap;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.modules.vmd.api.io.ActiveViewSupport;
import org.netbeans.modules.vmd.api.io.CodeGenerator;
import org.netbeans.modules.vmd.api.io.DataEditorView;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.DesignDocumentAwareness;
import org.netbeans.modules.vmd.api.io.providers.DocumentSerializer;
import org.netbeans.modules.vmd.api.io.providers.IOSupport;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CodeResolver
implements DesignDocumentAwareness {
    private static final Lookup.Result<CodeGenerator> result = Lookup.getDefault().lookupResult(CodeGenerator.class);
    private DataObjectContext context;
    private DocumentSerializer serializer;
    private volatile DesignDocument document;
    private volatile long documentState = Long.MIN_VALUE;
    private volatile DataEditorView.Kind viewKind;

    public CodeResolver(DataObjectContext context, DocumentSerializer serializer) {
        this.context = context;
        this.serializer = serializer;
        this.serializer.addDesignDocumentAwareness(this);
    }

    public void resetModelModifiedStatus(DesignDocument document) {
        if (this.document == null && document != null) {
            this.document = document;
            this.documentState = document.getListenerManager().getDocumentState();
        }
    }

    @Override
    public void setDesignDocument(DesignDocument designDocument) {
        DataEditorView activeView = ActiveViewSupport.getDefault().getActiveView();
        if (activeView == null) {
            return;
        }
        if (activeView.getContext() != this.context) {
            return;
        }
        this.update(designDocument, activeView.getKind());
    }

    public void viewActivated(DataEditorView view) {
        this.update(this.serializer.getDocument(), view.getKind());
    }

    public void forceUpdateCode() {
        this.update(this.serializer.getDocument(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(final DesignDocument document, DataEditorView.Kind kind) {
        if (document == null) {
            return;
        }
        if (kind != null && kind.equals((Object)DataEditorView.Kind.NONE)) {
            return;
        }
        CodeResolver codeResolver = this;
        synchronized (codeResolver) {
            boolean regenerateSourceCode;
            if (kind != null && kind.equals((Object)this.viewKind)) {
                return;
            }
            boolean modelModified = this.document != document || this.documentState != document.getListenerManager().getDocumentState();
            boolean editorSupportModified = IOSupport.getCloneableEditorSupport(this.context.getDataObject()).isModified();
            boolean switchedFromModelToCode = kind != null && kind.equals((Object)DataEditorView.Kind.CODE) && this.viewKind != null && this.viewKind.equals((Object)DataEditorView.Kind.MODEL);
            final boolean switchedFromCodeToModel = kind != null && kind.equals((Object)DataEditorView.Kind.MODEL) && this.viewKind != null && this.viewKind.equals((Object)DataEditorView.Kind.CODE);
            boolean bl = regenerateSourceCode = editorSupportModified && modelModified && (switchedFromModelToCode || kind == null);
            if (!IOSupport.isDocumentUpdatingEnabled(this.context.getDataObject())) {
                if (regenerateSourceCode) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            String lckFile = ".LCK" + CodeResolver.this.context.getDataObject().getPrimaryFile().getNameExt() + "~";
                            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CodeResolver.class, (String)"CodeResolver.locked", (Object)lckFile)));
                        }
                    });
                }
                if (kind != null) {
                    this.viewKind = kind;
                }
                return;
            }
            JEditorPane pane = null;
            FoldHierarchy foldHierarchy = null;
            HashMap<String, Boolean> foldStates = null;
            if (regenerateSourceCode && (pane = this.findEditorPane()) != null) {
                foldHierarchy = FoldHierarchy.get((JTextComponent)pane);
                foldStates = new HashMap<String, Boolean>();
            }
            if (pane != null) {
                this.storeFoldStates(foldHierarchy.getRootFold(), foldStates);
            }
            long eventID = document.getTransactionManager().writeAccess(new Runnable(){

                @Override
                public void run() {
                    if (regenerateSourceCode) {
                        for (CodeGenerator generator : result.allInstances()) {
                            generator.validateModelForCodeGeneration(CodeResolver.this.context, document);
                        }
                    }
                    if (switchedFromCodeToModel || regenerateSourceCode) {
                        for (CodeGenerator generator : result.allInstances()) {
                            generator.updateModelFromCode(CodeResolver.this.context, document);
                        }
                    }
                }
            });
            this.document = document;
            if (regenerateSourceCode) {
                this.documentState = eventID;
            }
            if (kind != null) {
                this.viewKind = kind;
            }
            if (regenerateSourceCode) {
                document.getTransactionManager().readAccess(new Runnable(){

                    @Override
                    public void run() {
                        for (CodeGenerator generator : result.allInstances()) {
                            generator.updateCodeFromModel(CodeResolver.this.context, document);
                        }
                    }
                });
            }
            if (pane != null) {
                this.loadFoldStates(foldHierarchy, foldHierarchy.getRootFold(), foldStates);
            }
        }
    }

    private void storeFoldStates(Fold fold, HashMap<String, Boolean> foldStates) {
        String description = fold.getDescription();
        if ("custom-fold".equals(fold.getType().toString()) && description != null) {
            foldStates.put(description, fold.isCollapsed());
        }
        for (int a = 0; a < fold.getFoldCount(); ++a) {
            this.storeFoldStates(fold.getFold(a), foldStates);
        }
    }

    private void loadFoldStates(FoldHierarchy foldHierarchy, Fold fold, HashMap<String, Boolean> foldStates) {
        Boolean state;
        String description = fold.getDescription();
        if ("custom-fold".equals(fold.getType().toString()) && description != null && (state = foldStates.get(description)) != null && state.booleanValue() != fold.isCollapsed()) {
            if (state.booleanValue()) {
                foldHierarchy.collapse(fold);
            } else {
                foldHierarchy.expand(fold);
            }
        }
        for (int a = 0; a < fold.getFoldCount(); ++a) {
            this.loadFoldStates(foldHierarchy, fold.getFold(a), foldStates);
        }
    }

    private JEditorPane findEditorPane() {
        if (!SwingUtilities.isEventDispatchThread()) {
            return null;
        }
        JEditorPane[] panes = this.context.getCloneableEditorSupport().getOpenedPanes();
        if (panes == null || panes.length < 1) {
            return null;
        }
        return panes[0];
    }

    public void notifyDataObjectClosed() {
        this.serializer.removeDesignDocumentAwareness(this);
        this.serializer = null;
        this.context = null;
    }
}

