/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.sfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.netbeans.modules.cnd.repository.sfs.FileRWAccess;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.PersistentFactory;

public class SimpleRWAccess
implements FileRWAccess {
    private RandomAccessFile randomAccessFile;
    private final Object lock = new Lock();

    public SimpleRWAccess(File file) throws IOException {
        this.randomAccessFile = new RandomAccessFile(file, "rw");
    }

    @Override
    public long size() throws IOException {
        return this.randomAccessFile.length();
    }

    @Override
    public void truncate(long size) throws IOException {
        this.randomAccessFile.setLength(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void move(long offset, int size, long newOffset) throws IOException {
        byte[] buffer = new byte[size];
        Object object = this.lock;
        synchronized (object) {
            this.randomAccessFile.seek(offset);
            this.randomAccessFile.read(buffer);
            this.randomAccessFile.seek(newOffset);
            this.randomAccessFile.write(buffer);
        }
    }

    @Override
    public void move(FileRWAccess from, long offset, int size, long newOffset) throws IOException {
        if (!(from instanceof SimpleRWAccess)) {
            throw new IllegalArgumentException("Illegal class to move from: " + from.getClass().getName());
        }
        SimpleRWAccess from2 = (SimpleRWAccess)from;
        byte[] buffer = new byte[size];
        from2.randomAccessFile.seek(offset);
        from2.randomAccessFile.read(buffer);
        this.randomAccessFile.seek(newOffset);
        this.randomAccessFile.write(buffer);
    }

    @Override
    public void close() throws IOException {
        this.randomAccessFile.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(PersistentFactory factory, Persistent object, long offset) throws IOException {
        Object object2 = this.lock;
        synchronized (object2) {
            this.randomAccessFile.seek(offset);
            factory.write((DataOutput)this.randomAccessFile, object);
            return (int)(this.randomAccessFile.getFilePointer() - offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Persistent read(PersistentFactory factory, long offset, int size) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.randomAccessFile.seek(offset);
            return factory.read((DataInput)this.randomAccessFile);
        }
    }

    @Override
    public FileDescriptor getFD() throws IOException {
        return this.randomAccessFile.getFD();
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

