/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.favorites.api.Favorites;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.ui.GetSourcesFromKenaiAction;
import org.netbeans.modules.kenai.ui.NbProjectHandleImpl;
import org.netbeans.modules.kenai.ui.SourceHandleImpl;
import org.netbeans.modules.kenai.ui.spi.NbProjectHandle;
import org.netbeans.modules.kenai.ui.spi.ProjectHandle;
import org.netbeans.modules.kenai.ui.spi.SourceAccessor;
import org.netbeans.modules.kenai.ui.spi.SourceHandle;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.windows.WindowManager;

public class SourceAccessorImpl
extends SourceAccessor {
    private Map<SourceHandle, ProjectAndFeature> handlesMap = new HashMap<SourceHandle, ProjectAndFeature>();

    @Override
    public List<SourceHandle> getSources(ProjectHandle prjHandle) {
        KenaiProject project = prjHandle.getKenaiProject();
        ArrayList handlesList = new ArrayList();
        if (project != null) {
            try {
                for (KenaiFeature feature : project.getFeatures(KenaiService.Type.SOURCE)) {
                    SourceHandleImpl srcHandle = new SourceHandleImpl(prjHandle, feature);
                    handlesList.add(srcHandle);
                    this.handlesMap.put(srcHandle, new ProjectAndFeature(prjHandle.getKenaiProject(), feature, srcHandle.getExternalScmType()));
                }
            }
            catch (KenaiException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return handlesList.isEmpty() ? Collections.emptyList() : handlesList;
    }

    @Override
    public Action getOpenSourcesAction(SourceHandle srcHandle) {
        return new GetSourcesFromKenaiAction(this.handlesMap.get(srcHandle), srcHandle);
    }

    @Override
    public Action getDefaultAction(SourceHandle srcHandle) {
        return new GetSourcesFromKenaiAction(this.handlesMap.get(srcHandle), srcHandle);
    }

    @Override
    public Action getDefaultAction(final NbProjectHandle prj) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Project project = ((NbProjectHandleImpl)prj).getProject();
                if (project == null) {
                    ((NbProjectHandleImpl)prj).remove();
                } else {
                    OpenProjects.getDefault().open(new Project[]{project}, false);
                    WindowManager.getDefault().findTopComponent("projectTabLogical_tc").requestActive();
                    this.selectProject(project);
                }
            }

            private void selectProject(Project p) {
                ExplorerManager em = ((ExplorerManager.Provider)WindowManager.getDefault().findTopComponent("projectTabLogical_tc")).getExplorerManager();
                Node root = em.getRootContext();
                Node projNode = null;
                for (Node n : root.getChildren().getNodes()) {
                    Project prj2 = (Project)n.getLookup().lookup(Project.class);
                    if (prj2 == null || !prj2.getProjectDirectory().equals(p.getProjectDirectory())) continue;
                    projNode = n;
                    break;
                }
                if (projNode == null) {
                    projNode = root.getChildren().findChild(ProjectUtils.getInformation((Project)p).getName());
                }
                if (projNode != null) {
                    try {
                        em.setSelectedNodes(new Node[]{projNode});
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                }
            }
        };
    }

    @Override
    public Action getOpenOtherAction(final SourceHandle src) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectChooser.setProjectsFolder((File)src.getWorkingDirectory());
                JFileChooser chooser = ProjectChooser.projectChooser();
                chooser.setMultiSelectionEnabled(true);
                int option = chooser.showOpenDialog(WindowManager.getDefault().getMainWindow());
                if (option == 0) {
                    File[] projectDirs = chooser.isMultiSelectionEnabled() ? chooser.getSelectedFiles() : new File[]{chooser.getSelectedFile()};
                    ArrayList<Project> projects = new ArrayList<Project>(projectDirs.length);
                    for (File d : projectDirs) {
                        try {
                            Project p = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)d));
                            projects.add(p);
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        catch (IllegalArgumentException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    Project[] projectsArray = new Project[projects.size()];
                    projects.toArray(projectsArray);
                    OpenProjects.getDefault().open(projectsArray, false);
                    WindowManager.getDefault().findTopComponent("projectTabLogical_tc").requestActive();
                }
            }
        };
    }

    @Override
    public Action getOpenFavorites(final SourceHandle src) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowManager.getDefault().findTopComponent("favorites").requestActive();
                try {
                    FileObject fo = FileUtil.toFileObject((File)src.getWorkingDirectory());
                    Favorites.getDefault().selectWithAddition(fo);
                }
                catch (IOException ex) {
                    SourceAccessorImpl.printStackTrace(ex);
                }
                catch (IllegalArgumentException ex) {
                    SourceAccessorImpl.printStackTrace(ex);
                }
                catch (NullPointerException ex) {
                    SourceAccessorImpl.printStackTrace(ex);
                }
            }
        };
    }

    private static void printStackTrace(Throwable t) {
        Logger.getLogger(SourceAccessorImpl.class.getName()).log(Level.FINE, t.getMessage(), t);
    }

    public static class ProjectAndFeature {
        public KenaiProject kenaiProject;
        public KenaiFeature feature;
        public String externalScmType;

        public ProjectAndFeature(KenaiProject name, KenaiFeature ftr, String externalScmType) {
            this.kenaiProject = name;
            this.feature = ftr;
            this.externalScmType = externalScmType;
        }
    }
}

