/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.api;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.Union2;

public abstract class NbModuleOwnerSupport {
    public static String NB_BUGZILLA_CONFIG = ".nbbugzilla-components";
    private static NbModuleOwnerSupport instance;

    protected NbModuleOwnerSupport() {
    }

    public static NbModuleOwnerSupport getInstance() {
        if (instance == null && (instance = (NbModuleOwnerSupport)Lookup.getDefault().lookup(NbModuleOwnerSupport.class)) == null) {
            instance = new DefaultImpl();
        }
        return instance;
    }

    public final String getOwner(String configFileName, File path) {
        OwnerInfo ownerInfo = this.getOwnerInfo(configFileName, path);
        return ownerInfo != null ? ownerInfo.getOwner() : null;
    }

    public final OwnerInfo getOwnerInfo(String configFileName, File path) {
        this.checkConfigFileName(configFileName);
        this.checkPath(path);
        try {
            return this.getOwnerImpl(configFileName, path);
        }
        catch (Throwable t) {
            ErrorManager.getDefault().notify(16, t);
            return null;
        }
    }

    public OwnerInfo getOwnerInfo(Project project) {
        FileObject fileObject = project.getProjectDirectory();
        return this.getOwnerInfo(fileObject);
    }

    public OwnerInfo getOwnerInfo(FileObject fileObject) {
        if (fileObject == null) {
            return null;
        }
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            return null;
        }
        return NbModuleOwnerSupport.getInstance().getOwnerInfo(NB_BUGZILLA_CONFIG, file);
    }

    public OwnerInfo getOwnerInfo(Node node) {
        Lookup nodeLookup = node.getLookup();
        Project project = (Project)nodeLookup.lookup(Project.class);
        if (project != null) {
            return this.getOwnerInfo(project);
        }
        DataObject dataObj = (DataObject)nodeLookup.lookup(DataObject.class);
        if (dataObj != null) {
            return this.getOwnerInfo(dataObj);
        }
        return null;
    }

    private OwnerInfo getOwnerInfo(DataObject dataObj) {
        FileObject fileObj = dataObj.getPrimaryFile();
        if (fileObj == null) {
            return null;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObj);
        if (project != null) {
            return this.getOwnerInfo(project);
        }
        return this.getOwnerInfo(fileObj);
    }

    private void checkConfigFileName(String configFileName) throws IllegalArgumentException {
        if (configFileName == null) {
            throw new IllegalArgumentException("configFileName is <null>");
        }
        if (configFileName.length() == 0 || configFileName.equals(".") || configFileName.equals("..") || configFileName.lastIndexOf(File.separatorChar) != -1) {
            throw new IllegalArgumentException("Illegal name of configuration file: \"" + configFileName + '\"');
        }
    }

    private void checkPath(File path) throws IllegalArgumentException {
        if (path == null) {
            throw new IllegalArgumentException("path is <null>");
        }
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException("Absolute path is required - was: " + path);
        }
    }

    protected abstract OwnerInfo getOwnerImpl(String var1, File var2);

    protected abstract ConfigData getData(File var1);

    static class BufferedReaderIterator
    implements Iterable<String>,
    Iterator<String> {
        private final BufferedReader bufReader;
        private String nextLine;
        private boolean nextLinePrepared;

        BufferedReaderIterator(BufferedReader bufReader) {
            this.bufReader = bufReader;
        }

        @Override
        public Iterator<String> iterator() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            if (!this.nextLinePrepared) {
                this.nextLine = null;
                try {
                    this.nextLine = this.bufReader.readLine();
                }
                catch (IOException ex) {
                }
                finally {
                    this.nextLinePrepared = true;
                    if (this.nextLine == null) {
                        try {
                            this.bufReader.close();
                        }
                        catch (IOException ex) {}
                    }
                }
            }
            return this.nextLine != null;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.nextLinePrepared = false;
            return this.nextLine;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class OwnerInfo {
        static final OwnerInfo NULL_OWNER_INFO = new OwnerInfo("");
        private final String owner;
        private final List<String> extraData;

        static OwnerInfo parseSpec(CharSequence spec) {
            String part;
            char c;
            int i;
            if (spec.length() == 0) {
                return null;
            }
            String owner = null;
            ArrayList<String> extraList = null;
            int length = spec.length();
            for (i = 0; i < length && ((c = spec.charAt(i)) == ' ' || c == '\t'); ++i) {
            }
            if (i == length) {
                return null;
            }
            StringBuilder buf = null;
            int start = i;
            boolean escaped = false;
            while (i < length) {
                char c2 = spec.charAt(i);
                if (escaped) {
                    if (buf == null) {
                        buf = new StringBuilder(20);
                        buf.append(spec, start, i - 1);
                    }
                    buf.append(c2);
                    escaped = false;
                } else if (c2 == '\\') {
                    escaped = true;
                } else if (c2 == '/') {
                    String part2;
                    String string = part2 = buf != null ? buf.toString() : ((Object)spec.subSequence(start, i)).toString();
                    if (owner == null) {
                        owner = part2;
                    } else {
                        if (extraList == null) {
                            extraList = new ArrayList(4);
                        }
                        extraList.add(part2);
                    }
                    start = i + 1;
                    buf = null;
                } else if (buf != null) {
                    buf.append(c2);
                }
                ++i;
            }
            String string = part = buf != null ? buf.toString() : ((Object)spec.subSequence(start, length)).toString();
            if (owner == null) {
                owner = part;
            } else {
                if (extraList == null) {
                    extraList = new ArrayList<String>(4);
                }
                extraList.add(part);
            }
            if (extraList != null) {
                return new OwnerInfo(owner, extraList);
            }
            return new OwnerInfo(owner);
        }

        public OwnerInfo(String owner) {
            this(owner, (String[])null);
        }

        public OwnerInfo(String owner, String ... extraData) {
            this.checkOwner(owner);
            this.owner = owner;
            if (extraData == null || extraData.length == 0) {
                this.extraData = null;
            } else if (extraData.length == 1) {
                this.extraData = Collections.singletonList(extraData[0]);
            } else {
                this.extraData = new ArrayList<String>(extraData.length);
                for (String str : extraData) {
                    this.extraData.add(str);
                }
            }
        }

        public OwnerInfo(String owner, List<String> extraData) {
            this.checkOwner(owner);
            this.owner = owner;
            this.extraData = extraData == null || extraData.isEmpty() ? null : (extraData.size() == 1 ? Collections.singletonList(extraData.get(0)) : new ArrayList<String>(extraData));
        }

        private void checkOwner(String owner) throws IllegalArgumentException {
            if (owner == null) {
                throw new IllegalArgumentException("owner must not be null");
            }
        }

        public String getOwner() {
            return this.owner;
        }

        public List<String> getExtraData() {
            return this.extraData != null ? this.extraData : Collections.emptyList();
        }

        public int hashCode() {
            int hash = 7;
            hash = 79 * hash + this.owner.hashCode();
            hash = 79 * hash + (this.extraData != null ? ((Object)this.extraData).hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj.getClass() == OwnerInfo.class) {
                OwnerInfo other = (OwnerInfo)obj;
                return OwnerInfo.equal(this.owner, other.owner) && OwnerInfo.equal(this.extraData, other.extraData);
            }
            return false;
        }

        private static boolean equal(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }

        public String toString() {
            return super.toString() + this.paramString();
        }

        public String paramString() {
            StringBuilder buf = new StringBuilder(100);
            buf.append("[component=").append(this.owner).append(",extraData=").append(this.getExtraDataString()).append(']');
            return buf.toString();
        }

        private String getExtraDataString() {
            if (this.extraData == null || this.extraData.isEmpty()) {
                return "()";
            }
            StringBuilder buf = new StringBuilder(100);
            buf.append('(');
            boolean first = true;
            for (String item : this.extraData) {
                if (!first) {
                    buf.append(',');
                }
                buf.append(item != null ? item : "null");
                first = false;
            }
            buf.append(')');
            return buf.toString();
        }
    }

    public static class ConfigData {
        private static final Logger LOG = Logger.getLogger(ConfigData.class.getCanonicalName());
        private static final int TOP_NODES_COUNT = 26;
        private final Union2<List<Node>, Node[]>[] topNodes = new Union2[26];

        public static ConfigData load(File dataFile) {
            if (dataFile == null) {
                throw new IllegalArgumentException("dataFile is <null>");
            }
            ConfigData data = new ConfigData();
            try {
                data.loadData(dataFile);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(16, (Throwable)ex);
            }
            return data;
        }

        protected ConfigData() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void loadData(File dataFile) throws IOException {
            this.cleanData();
            PatternParser parser = new PatternParser();
            int lineNum = 0;
            try {
                for (String line : this.getConfigFileLines(dataFile)) {
                    this.processPatternFileLine(dataFile, line, ++lineNum, parser);
                }
            }
            finally {
                this.processNodes();
                parser.reset();
            }
        }

        private void cleanData() {
            Arrays.fill(this.topNodes, null);
        }

        protected Iterable<String> getConfigFileLines(File dataFile) throws IOException {
            return new BufferedReaderIterator(new BufferedReader(new InputStreamReader(new FileInputStream(dataFile))));
        }

        private void processPatternFileLine(File dataFile, String line, int lineNum, PatternParser parser) {
            if (line.length() == 0) {
                return;
            }
            if (line.charAt(0) == '#') {
                return;
            }
            List patternPath = parser.parsePattern(line);
            if (patternPath == null) {
                ParsingFailure failure = parser.getFailure();
                if (failure != ParsingFailure.EMPTY_LINE && LOG.isLoggable(Level.INFO)) {
                    int column;
                    StringBuilder msg = new StringBuilder(100);
                    msg.append("syntax error in mapping file ").append(dataFile).append(" at line ").append(lineNum).append(": ").append(failure.getDescription());
                    if (failure == ParsingFailure.SYNTAX_ERROR && (column = parser.getSyntaxErrorPosition()) != -1) {
                        msg.append(" at column ").append(column);
                    }
                    LOG.info(msg.toString());
                }
                return;
            }
            String infoString = line.substring(parser.getSeparatorPosition() + 1);
            OwnerInfo info = OwnerInfo.parseSpec(infoString);
            this.processPatternData(patternPath, info);
        }

        private void processPatternData(List<String> pattern, OwnerInfo info) {
            String firstPatternPart = pattern.get(0);
            if (firstPatternPart.equals("*")) {
                for (int i = 0; i < 26; ++i) {
                    this.processPatternData(i, pattern, info);
                }
            } else {
                int topNodeIndex = ConfigData.getTopNodeIndex(firstPatternPart);
                this.processPatternData(topNodeIndex, pattern, info);
            }
        }

        private void processPatternData(int topNodeIndex, List<String> pattern, OwnerInfo info) {
            Union2<List<Node>, Node[]> topNodeUnion = this.topNodes[topNodeIndex];
            if (topNodeUnion == null) {
                ArrayList<Node> newList = new ArrayList<Node>(10);
                this.topNodes[topNodeIndex] = Union2.createFirst(newList);
                newList.add(this.createNode(pattern, 0, info));
            } else {
                this.findNode((List)topNodeUnion.first(), pattern, 0, info);
            }
        }

        private Node findNode(List<Node> nodes, List<String> pattern, int patternPartIndex, OwnerInfo info) {
            boolean isPrefix = ConfigData.isPrefixPattern(pattern.get(patternPartIndex));
            return isPrefix ? this.findPrefixNode(nodes, pattern, patternPartIndex, info) : this.findNonPrefixNode(nodes, pattern, patternPartIndex, info);
        }

        private Node findPrefixNode(List<Node> nodes, List<String> pattern, int patternPartIndex, OwnerInfo info) {
            ListIterator<Node> it = nodes.listIterator();
            Node node = it.next();
            while (!node.isPrefix) {
                if (!it.hasNext()) {
                    node = this.createNode(pattern, patternPartIndex, info);
                    nodes.add(node);
                    return node;
                }
                node = it.next();
            }
            String patternPart = pattern.get(patternPartIndex);
            int length = patternPart.length();
            while (node.name.length() > length) {
                if (!it.hasNext()) {
                    node = this.createNode(pattern, patternPartIndex, info);
                    nodes.add(node);
                    return node;
                }
                node = it.next();
            }
            String nonPrefixPart = patternPart.substring(0, length - 1);
            while (node.name.length() == length) {
                if (node.name.equals(nonPrefixPart)) {
                    Node childNode;
                    if (patternPartIndex == pattern.size() - 1) {
                        return node;
                    }
                    Union2 childrenUnion = node.children;
                    if (childrenUnion != null) {
                        List children = (List)childrenUnion.first();
                        childNode = this.findNode(children, pattern, patternPartIndex + 1, info);
                    } else {
                        childNode = this.createNode(pattern, patternPartIndex + 1, info);
                        node.addChild(childNode);
                    }
                    return childNode;
                }
                if (!it.hasNext()) {
                    node = this.createNode(pattern, patternPartIndex, info);
                    nodes.add(node);
                    return node;
                }
                node = it.next();
            }
            node = this.createNode(pattern, patternPartIndex, info);
            nodes.add(it.previousIndex(), node);
            return node;
        }

        private Node findNonPrefixNode(List<Node> nodes, List<String> pattern, int patternPartIndex, OwnerInfo info) {
            String patternPart = pattern.get(patternPartIndex);
            int length = patternPart.length();
            ListIterator<Node> it = nodes.listIterator();
            Node node = it.next();
            while (!node.isPrefix && node.name.length() < length) {
                if (!it.hasNext()) {
                    node = this.createNode(pattern, patternPartIndex, info);
                    nodes.add(node);
                    return node;
                }
                node = it.next();
            }
            while (!node.isPrefix && node.name.length() == length) {
                if (node.name.equals(patternPart)) {
                    Node childNode;
                    if (patternPartIndex == pattern.size() - 1) {
                        return node;
                    }
                    Union2 childrenUnion = node.children;
                    if (childrenUnion != null) {
                        List children = (List)childrenUnion.first();
                        childNode = this.findNode(children, pattern, patternPartIndex + 1, info);
                    } else {
                        childNode = this.createNode(pattern, patternPartIndex + 1, info);
                        node.addChild(childNode);
                    }
                    return childNode;
                }
                if (!it.hasNext()) {
                    node = this.createNode(pattern, patternPartIndex, info);
                    nodes.add(node);
                    return node;
                }
                node = it.next();
            }
            node = this.createNode(pattern, patternPartIndex, info);
            nodes.add(it.previousIndex(), node);
            return node;
        }

        private Node createNode(List<String> pattern, int patternPartIndex, OwnerInfo info) {
            Node result;
            if (patternPartIndex == pattern.size() - 1) {
                result = new Node(pattern.get(patternPartIndex), info);
            } else {
                result = new Node(pattern.get(patternPartIndex), null);
                result.addChild(this.createNode(pattern, patternPartIndex + 1, info));
            }
            return result;
        }

        private void processNodes() {
            ConfigData.processNodes(this.topNodes);
        }

        private static void processNodes(Union2<List<Node>, Node[]>[] unionNodes) {
            for (int i = 0; i < unionNodes.length; ++i) {
                Node[] nodesArray;
                Union2<List<Node>, Node[]> node = unionNodes[i];
                if (node == null) continue;
                List nodeList = (List)node.first();
                assert (!nodeList.isEmpty());
                for (Node nodeArrayElem : nodesArray = ((List)node.first()).toArray(new Node[nodeList.size()])) {
                    nodeArrayElem.processChildren();
                }
                unionNodes[i] = Union2.createSecond((Object)nodesArray);
                assert (((Node[])unionNodes[i].second()).length != 0);
            }
        }

        public OwnerInfo getMatchingInfo(String relativePath) {
            String firstPartOfPath = ConfigData.getFirstPartOfPath(relativePath);
            int topNodeIndex = ConfigData.getTopNodeIndex(firstPartOfPath);
            Union2<List<Node>, Node[]> topNodeUnion = this.topNodes[topNodeIndex];
            if (topNodeUnion == null) {
                return null;
            }
            Node[] topNode = (Node[])topNodeUnion.second();
            if (topNode == null) {
                assert (false);
                return null;
            }
            OwnerInfo ownerInfo = this.findInfo(relativePath, firstPartOfPath, topNode);
            if (ownerInfo != null && ownerInfo != OwnerInfo.NULL_OWNER_INFO) {
                return ownerInfo;
            }
            return null;
        }

        private OwnerInfo findInfo(String relativePath, String firstPartOfPath, Node[] nodes) {
            String subPath;
            OwnerInfo subnodeInfo;
            int firstPartLen = firstPartOfPath.length();
            Node matchingNode = null;
            for (Node node : nodes) {
                if (!node.isPrefix) {
                    if (!node.name.equals(firstPartOfPath)) continue;
                    matchingNode = node;
                    break;
                }
                int prefixLen = node.name.length();
                int prefixLastCharIndex = prefixLen - 1;
                if (prefixLen > firstPartLen || prefixLen != 0 && (node.name.charAt(prefixLastCharIndex) != firstPartOfPath.charAt(prefixLastCharIndex) || !firstPartOfPath.startsWith(node.name))) continue;
                matchingNode = node;
                break;
            }
            if (matchingNode == null) {
                return null;
            }
            if (matchingNode.children != null && relativePath.length() > firstPartLen && (subnodeInfo = this.findInfo(subPath = relativePath.substring(firstPartLen + 1), ConfigData.getFirstPartOfPath(subPath), (Node[])matchingNode.children.second())) != null) {
                return subnodeInfo;
            }
            return matchingNode.info;
        }

        private static final int getTopNodeIndex(String pattern) {
            return ConfigData.getCharIndex(pattern.charAt(0)) % 26;
        }

        private static final int getCharIndex(char c) {
            return (c | 0x20) + 159 & 0xFF;
        }

        private static String getFirstPartOfPath(String path) {
            int firstSlashPos = path.indexOf(47);
            return firstSlashPos != -1 ? path.substring(0, firstSlashPos) : path;
        }

        private static boolean isPrefixPattern(String patternPart) {
            return patternPart.charAt(patternPart.length() - 1) == '*';
        }

        private static String getPrefixPart(String patternPart) {
            assert (ConfigData.isPrefixPattern(patternPart));
            return patternPart.substring(0, patternPart.length() - 1);
        }

        private static final class Node {
            final String name;
            final boolean isPrefix;
            final OwnerInfo info;
            private Union2<List<Node>, Node[]> children;

            Node(String patternPart, OwnerInfo info) {
                this.isPrefix = ConfigData.isPrefixPattern(patternPart);
                this.name = this.isPrefix ? ConfigData.getPrefixPart(patternPart) : patternPart;
                this.info = info != null ? info : OwnerInfo.NULL_OWNER_INFO;
            }

            void addChild(Node child) {
                if (this.children == null) {
                    this.children = Union2.createFirst(new ArrayList(4));
                }
                ((List)this.children.first()).add(child);
            }

            private void processChildren() {
                if (this.children == null) {
                    return;
                }
                List nodeList = (List)this.children.first();
                assert (!nodeList.isEmpty());
                Node[] nodesArray = ((List)this.children.first()).toArray(new Node[nodeList.size()]);
                this.children = Union2.createSecond((Object)nodesArray);
            }
        }

        private static final class PatternParser {
            private static final int INIT = 0;
            private static final int NAME = 1;
            private static final int STAR = 2;
            private String patternBeingParsed;
            private int state;
            private int begin;
            private String firstString;
            private List<String> result;
            private int separatorPosition;
            private ParsingFailure failure;
            private int syntaxErrorPosition;

            PatternParser() {
                this.reset();
            }

            private void reset() {
                this.patternBeingParsed = null;
                this.firstString = null;
                this.result = null;
                this.separatorPosition = -1;
                this.failure = null;
                this.syntaxErrorPosition = -1;
                this.begin = -1;
                this.state = 0;
            }

            ParsingFailure getFailure() {
                return this.failure;
            }

            int getSyntaxErrorPosition() {
                return this.syntaxErrorPosition;
            }

            int getSeparatorPosition() {
                return this.separatorPosition;
            }

            private List<String> parsePattern(String mappingFileLine) {
                char c;
                int i;
                this.reset();
                this.patternBeingParsed = mappingFileLine;
                int length = mappingFileLine.length();
                for (i = 0; i < length && ((c = mappingFileLine.charAt(i)) == ' ' || c == '\t'); ++i) {
                }
                if (i == length) {
                    this.failure = ParsingFailure.EMPTY_LINE;
                    return null;
                }
                if (mappingFileLine.charAt(i) == '=') {
                    this.failure = ParsingFailure.EMPTY_PATH;
                    return null;
                }
                int patternBeginning = i;
                boolean escaped = false;
                boolean containsEscapedChars = false;
                int lastNonSpacePos = i;
                block10: while (i < length) {
                    char c2 = mappingFileLine.charAt(i);
                    switch (this.state) {
                        case 0: {
                            assert (!escaped);
                            if (c2 == '*') {
                                this.storePatternPart("*");
                                this.state = 2;
                                break;
                            }
                            if (c2 == '=') {
                                this.separatorPosition = i;
                                break block10;
                            }
                            if (c2 == '/') {
                                this.failure = i == patternBeginning ? ParsingFailure.ABSOLUTE_PATH : ParsingFailure.SYNTAX_ERROR;
                                break block10;
                            }
                            if (c2 == '\\') {
                                escaped = true;
                                containsEscapedChars = true;
                            }
                            if (c2 != ' ' && c2 != '\t') {
                                lastNonSpacePos = i;
                            }
                            this.begin = i;
                            this.state = 1;
                            break;
                        }
                        case 1: {
                            if (escaped) {
                                escaped = false;
                                lastNonSpacePos = i;
                                break;
                            }
                            if (c2 == '*') {
                                this.storePatternPart(i + 1, containsEscapedChars);
                                containsEscapedChars = false;
                                this.state = 2;
                                break;
                            }
                            if (c2 == '/') {
                                this.storePatternPart(i, containsEscapedChars);
                                containsEscapedChars = false;
                                this.state = 0;
                                break;
                            }
                            if (c2 == '=') {
                                this.separatorPosition = i;
                                break block10;
                            }
                            if (c2 == '\\') {
                                escaped = true;
                                containsEscapedChars = true;
                            }
                            if (c2 == ' ' || c2 == '\t') break;
                            lastNonSpacePos = i;
                            break;
                        }
                        case 2: {
                            assert (!escaped);
                            if (c2 == '*') {
                                this.failure = ParsingFailure.SYNTAX_ERROR;
                                break block10;
                            }
                            if (c2 == '/') {
                                this.state = 0;
                                break;
                            }
                            if (c2 == '=') {
                                this.separatorPosition = i;
                                break block10;
                            }
                            this.failure = ParsingFailure.SYNTAX_ERROR;
                            break block10;
                        }
                        default: {
                            assert (false);
                            break;
                        }
                    }
                    ++i;
                }
                if (this.failure != null) {
                    this.syntaxErrorPosition = i;
                    return null;
                }
                if (this.separatorPosition == -1) {
                    this.failure = ParsingFailure.NO_SEPARATOR;
                    return null;
                }
                switch (this.state) {
                    case 0: {
                        this.storePatternPart("*");
                        break;
                    }
                    case 1: {
                        if (lastNonSpacePos >= this.begin) {
                            this.storePatternPart(lastNonSpacePos + 1, containsEscapedChars);
                            containsEscapedChars = false;
                            break;
                        }
                        this.storePatternPart("*");
                    }
                }
                return this.makeFinalResult();
            }

            private void storePatternPart(int endIndex, boolean containsEscapedChars) {
                String patternPart;
                assert (this.begin >= 0);
                assert (endIndex > this.begin);
                if (!containsEscapedChars) {
                    patternPart = this.patternBeingParsed.substring(this.begin, endIndex);
                } else {
                    StringBuilder buf = new StringBuilder(endIndex - this.begin - 1);
                    for (int i = this.begin; i < endIndex; ++i) {
                        char c = this.patternBeingParsed.charAt(i);
                        if (c == '\\') continue;
                        buf.append(c);
                    }
                    assert (buf.length() < endIndex - this.begin);
                    patternPart = buf.toString();
                }
                this.storePatternPart(patternPart);
            }

            private void storePatternPart(String part) {
                if (this.firstString == null) {
                    this.firstString = part;
                } else {
                    if (this.result == null) {
                        this.result = new ArrayList<String>(4);
                        this.result.add(this.firstString);
                    }
                    this.result.add(part);
                }
                this.begin = -1;
            }

            private List<String> makeFinalResult() {
                if (this.result != null) {
                    return this.result;
                }
                if (this.firstString != null) {
                    return Collections.singletonList(this.firstString);
                }
                return Collections.emptyList();
            }
        }

        static enum ParsingFailure {
            EMPTY_LINE("empty line"),
            EMPTY_PATH("empty path"),
            ABSOLUTE_PATH("not a relative path"),
            NO_SEPARATOR("missing '='"),
            SYNTAX_ERROR("syntax error");

            private final String description;

            private ParsingFailure(String description) {
                this.description = description;
            }

            String getDescription() {
                return this.description;
            }
        }
    }

    private static class DefaultImpl
    extends NbModuleOwnerSupport {
        private final Object cacheLock = new Object();
        private final ConfigFileCache dataCache = new ConfigFileCache();

        private DefaultImpl() {
        }

        @Override
        protected OwnerInfo getOwnerImpl(String configFileName, File absolutePath) {
            String relativePath;
            File configFile = null;
            String fileName = absolutePath.getName();
            if (fileName.equals(configFileName) && absolutePath.isFile()) {
                configFile = absolutePath;
                relativePath = configFileName;
            } else {
                File parent;
                ArrayList<String> reversePathElements = new ArrayList<String>(15);
                File lastCheckedPath = absolutePath;
                while ((parent = lastCheckedPath.getParentFile()) != null) {
                    File fileToCheck = new File(parent, configFileName);
                    if (fileToCheck.isFile()) {
                        configFile = fileToCheck;
                        break;
                    }
                    reversePathElements.add(parent.getName());
                    lastCheckedPath = parent;
                }
                if (configFile == null) {
                    return null;
                }
                if (reversePathElements.isEmpty()) {
                    relativePath = fileName;
                } else {
                    StringBuilder buf = new StringBuilder(100);
                    for (int i = reversePathElements.size() - 1; i >= 0; --i) {
                        buf.append((String)reversePathElements.get(i)).append('/');
                    }
                    buf.append(fileName);
                    relativePath = buf.toString();
                }
            }
            ConfigData parsedData = this.getData(configFile);
            if (parsedData == null) {
                return null;
            }
            return parsedData.getMatchingInfo(relativePath);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected ConfigData getData(File configFile) {
            Object object = this.cacheLock;
            synchronized (object) {
                ConfigData data;
                Reference ref = (Reference)this.dataCache.get(configFile);
                ConfigData configData = data = ref != null ? (ConfigData)ref.get() : null;
                if (data == null) {
                    data = ConfigData.load(configFile);
                    this.dataCache.put(configFile, new SoftReference<ConfigData>(data));
                }
                return data;
            }
        }

        private static final class ConfigFileCache
        extends LinkedHashMap<File, Reference<ConfigData>> {
            private static final int MAX_SIZE = 10;

            ConfigFileCache() {
                super(16, 0.75f, true);
            }

            @Override
            protected boolean removeEldestEntry(Map.Entry<File, Reference<ConfigData>> eldest) {
                return this.size() > 10;
            }
        }
    }
}

