/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.impl.facesmodel;

import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.netbeans.modules.web.jsf.api.facesmodel.FacesConfig;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFConfigComponent;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFConfigComponentFactory;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFConfigModel;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFVersion;
import org.netbeans.modules.web.jsf.api.metamodel.JsfModel;
import org.netbeans.modules.web.jsf.impl.facesmodel.JSFConfigComponentFactoryImpl;
import org.netbeans.modules.web.jsf.impl.facesmodel.JSFConfigQNames;
import org.netbeans.modules.web.jsf.impl.facesmodel.SyncUpdateVisitor;
import org.netbeans.modules.xml.xam.ComponentUpdater;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class JSFConfigModelImpl
extends AbstractDocumentModel<JSFConfigComponent>
implements JSFConfigModel {
    private static final Logger LOGGER = Logger.getLogger(JSFConfigModelImpl.class.getName());
    private FacesConfig facesConfig;
    private final JSFConfigComponentFactory componentFactory = new JSFConfigComponentFactoryImpl(this);
    private JsfModel myMetaModel;

    public JSFConfigModelImpl(ModelSource source) {
        super(source);
    }

    public JSFConfigModelImpl(ModelSource source, JsfModel model) {
        this(source);
        this.myMetaModel = model;
    }

    public JSFConfigComponent createRootComponent(Element root) {
        FacesConfig newFacesConfig = (FacesConfig)this.getFactory().create(root, null);
        if (newFacesConfig != null) {
            this.facesConfig = newFacesConfig;
        }
        return newFacesConfig;
    }

    protected ComponentUpdater<JSFConfigComponent> getComponentUpdater() {
        return new SyncUpdateVisitor();
    }

    @Override
    public FacesConfig getRootComponent() {
        LOGGER.fine("getRootComponent()");
        return this.facesConfig;
    }

    public JSFConfigComponent createComponent(JSFConfigComponent parent, Element element) {
        return this.getFactory().create(element, parent);
    }

    @Override
    public JSFConfigComponentFactory getFactory() {
        return this.componentFactory;
    }

    @Override
    public JSFVersion getVersion() {
        String namespaceURI = this.getRootComponent().getPeer().getNamespaceURI();
        JSFVersion version = JSFVersion.JSF_1_1;
        if ("http://java.sun.com/xml/ns/javaee".equals(namespaceURI) && (this.getRootComponent().getVersion().equals("2.0") || this.checkJSF20SchemaLocation(this.getRootComponent().getPeer()))) {
            version = JSFVersion.JSF_2_0;
        } else if ("http://java.sun.com/xml/ns/javaee".equals(namespaceURI)) {
            version = JSFVersion.JSF_1_2;
        }
        return version;
    }

    public Set<QName> getQNames() {
        return JSFConfigQNames.getMappedQNames(this.getVersion());
    }

    private boolean checkJSF20SchemaLocation(Element element) {
        Attr attr;
        NamedNodeMap map = element.getAttributes();
        String prefix = null;
        for (int i = 0; i < map.getLength(); ++i) {
            Node node = map.item(i);
            Attr attr2 = (Attr)node;
            String value = attr2.getValue();
            if (!value.equals("http://www.w3.org/2001/XMLSchema")) continue;
            String prefixedAttr = null;
            prefixedAttr = attr2.getName();
            if (prefixedAttr.indexOf(":") == -1) break;
            prefix = prefixedAttr.substring(prefixedAttr.indexOf(":") + 1);
            break;
        }
        String schemaLocation = "schemaLocation";
        if (prefix != null && prefix.length() > 0) {
            schemaLocation = prefix + ":" + schemaLocation;
        }
        if ((attr = (Attr)map.getNamedItem(schemaLocation)) == null) {
            return false;
        }
        String value = attr.getValue();
        StringTokenizer tokenizer = new StringTokenizer(value);
        String location = null;
        while (tokenizer.hasMoreTokens()) {
            location = tokenizer.nextToken();
        }
        return "http://java.sun.com/xml/ns/javaee/web-facesconfig_2_0.xsd".equals(location);
    }
}

