/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.overridden;

import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.Annotations;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ImplementationProvider;
import org.netbeans.editor.JumpList;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.java.editor.overridden.AnnotationType;
import org.netbeans.modules.java.editor.overridden.AnnotationsHolder;
import org.netbeans.modules.java.editor.overridden.ElementDescription;
import org.netbeans.modules.java.editor.overridden.IsOverriddenAnnotation;
import org.netbeans.modules.java.editor.overridden.IsOverriddenPopup;
import org.netbeans.modules.java.editor.overridden.PopupUtil;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public final class IsOverriddenAnnotationAction
extends AbstractAction {
    private static final Set<String> COMBINED_TYPES = new HashSet<String>(Arrays.asList("org-netbeans-modules-editor-annotations-implements-has-implementations-combined", "org-netbeans-modules-editor-annotations-implements-is-overridden-combined", "org-netbeans-modules-editor-annotations-override-is-overridden-combined"));

    public IsOverriddenAnnotationAction() {
        this.putValue("Name", NbBundle.getMessage(IsOverriddenAnnotationAction.class, (String)"CTL_IsOverriddenAnnotationAction"));
        this.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.invokeDefaultAction((JTextComponent)actionEvent.getSource())) {
            Action action;
            int n;
            Action[] actionArray = ImplementationProvider.getDefault().getGlyphGutterActions((JTextComponent)actionEvent.getSource());
            if (actionArray == null) {
                return;
            }
            for (n = 0; n < actionArray.length && actionArray[n] != this; ++n) {
            }
            if (actionArray.length > ++n && (action = actionArray[n]) != null && action.isEnabled()) {
                action.actionPerformed(actionEvent);
            }
        }
    }

    private FileObject getFile(JTextComponent jTextComponent) {
        Document document = jTextComponent.getDocument();
        DataObject dataObject = (DataObject)document.getProperty("stream");
        if (dataObject == null) {
            return null;
        }
        return dataObject.getPrimaryFile();
    }

    private IsOverriddenAnnotation findAnnotation(JTextComponent jTextComponent, AnnotationDesc annotationDesc, int n) {
        FileObject fileObject = this.getFile(jTextComponent);
        if (fileObject == null) {
            if (ErrorManager.getDefault().isLoggable(16)) {
                ErrorManager.getDefault().log(16, "component=" + jTextComponent + " does not have a file specified in the document.");
            }
            return null;
        }
        AnnotationsHolder annotationsHolder = AnnotationsHolder.get(fileObject);
        if (annotationsHolder == null) {
            Logger.getLogger(IsOverriddenAnnotationAction.class.getName()).log(Level.INFO, "component=" + jTextComponent + " does not have attached a IsOverriddenAnnotationHandler");
            return null;
        }
        for (IsOverriddenAnnotation isOverriddenAnnotation : annotationsHolder.getAnnotations()) {
            if (isOverriddenAnnotation.getPosition().getOffset() != n || !annotationDesc.getShortDescription().equals(isOverriddenAnnotation.getShortDescription())) continue;
            return isOverriddenAnnotation;
        }
        return null;
    }

    private List<IsOverriddenAnnotation> findAnnotations(JTextComponent jTextComponent, int n) {
        FileObject fileObject = this.getFile(jTextComponent);
        if (fileObject == null) {
            if (ErrorManager.getDefault().isLoggable(16)) {
                ErrorManager.getDefault().log(16, "component=" + jTextComponent + " does not have a file specified in the document.");
            }
            return null;
        }
        AnnotationsHolder annotationsHolder = AnnotationsHolder.get(fileObject);
        if (annotationsHolder == null) {
            Logger.getLogger(IsOverriddenAnnotationAction.class.getName()).log(Level.INFO, "component=" + jTextComponent + " does not have attached a IsOverriddenAnnotationHandler");
            return null;
        }
        LinkedList<IsOverriddenAnnotation> linkedList = new LinkedList<IsOverriddenAnnotation>();
        for (IsOverriddenAnnotation isOverriddenAnnotation : annotationsHolder.getAnnotations()) {
            if (isOverriddenAnnotation.getPosition().getOffset() != n) continue;
            linkedList.add(isOverriddenAnnotation);
        }
        return linkedList;
    }

    boolean invokeDefaultAction(final JTextComponent jTextComponent) {
        final Document document = jTextComponent.getDocument();
        if (document instanceof BaseDocument) {
            final int n = jTextComponent.getCaretPosition();
            final Annotations annotations = ((BaseDocument)document).getAnnotations();
            final LinkedHashMap<String, List<ElementDescription>> linkedHashMap = new LinkedHashMap<String, List<ElementDescription>>();
            final Point[] pointArray = new Point[1];
            document.render(new Runnable(){

                @Override
                public void run() {
                    try {
                        int n3 = Utilities.getLineOffset((BaseDocument)((BaseDocument)document), (int)n);
                        int n2 = Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)document), (int)n3);
                        pointArray[0] = jTextComponent.modelToView(n2).getLocation();
                        AnnotationDesc annotationDesc = annotations.getActiveAnnotation(n3);
                        if (annotationDesc == null) {
                            return;
                        }
                        List<IsOverriddenAnnotation> list = COMBINED_TYPES.contains(annotationDesc.getAnnotationType()) ? IsOverriddenAnnotationAction.this.findAnnotations(jTextComponent, n2) : Collections.singletonList(IsOverriddenAnnotationAction.this.findAnnotation(jTextComponent, annotationDesc, n2));
                        for (IsOverriddenAnnotation isOverriddenAnnotation : list) {
                            if (isOverriddenAnnotation == null) continue;
                            linkedHashMap.put(IsOverriddenAnnotationAction.computeCaption(isOverriddenAnnotation.getType(), isOverriddenAnnotation.getShortDescription()), isOverriddenAnnotation.getDeclarations());
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        ErrorManager.getDefault().notify((Throwable)badLocationException);
                    }
                }
            });
            if (linkedHashMap.isEmpty()) {
                return false;
            }
            JumpList.checkAddEntry((JTextComponent)jTextComponent, (int)n);
            IsOverriddenAnnotationAction.mouseClicked(linkedHashMap, jTextComponent, pointArray[0]);
            return true;
        }
        return false;
    }

    private static void mouseClicked(Map<String, List<ElementDescription>> map, JTextComponent jTextComponent, Point point) {
        if (map.size() == 1 && map.values().iterator().next().size() == 1) {
            ElementDescription elementDescription = map.values().iterator().next().get(0);
            FileObject fileObject = elementDescription.getSourceFile();
            if (fileObject != null) {
                ElementOpen.open((FileObject)fileObject, elementDescription.getHandle());
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
            return;
        }
        Point point2 = new Point(point);
        SwingUtilities.convertPointToScreen(point2, jTextComponent);
        StringBuilder stringBuilder = new StringBuilder();
        LinkedList<ElementDescription> linkedList = new LinkedList<ElementDescription>();
        boolean bl = true;
        for (Map.Entry<String, List<ElementDescription>> entry : map.entrySet()) {
            if (!bl) {
                stringBuilder.append("/");
            }
            bl = false;
            stringBuilder.append(entry.getKey());
            linkedList.addAll((Collection<ElementDescription>)entry.getValue());
        }
        PopupUtil.showPopup(new IsOverriddenPopup(stringBuilder.toString(), linkedList), stringBuilder.toString(), point2.x, point2.y, true, 0);
    }

    private static String computeCaption(AnnotationType annotationType, String string) throws MissingResourceException, IllegalStateException {
        String string2;
        switch (annotationType) {
            case IMPLEMENTS: {
                string2 = NbBundle.getMessage(IsOverriddenAnnotation.class, (String)"CAP_Implements");
                break;
            }
            case OVERRIDES: {
                string2 = NbBundle.getMessage(IsOverriddenAnnotation.class, (String)"CAP_Overrides");
                break;
            }
            case HAS_IMPLEMENTATION: 
            case IS_OVERRIDDEN: {
                string2 = string;
                break;
            }
            default: {
                throw new IllegalStateException("Currently not implemented: " + (Object)((Object)annotationType));
            }
        }
        return string2;
    }
}

