/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2ee.marking;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.lib.profiler.marker.MethodMarker;
import org.netbeans.lib.profiler.results.cpu.marking.MarkMapping;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbJarImplementation;
import org.netbeans.modules.profiler.categories.CustomMarker;
import org.netbeans.modules.profiler.projectsupport.utilities.SourceUtils;
import org.netbeans.modules.profiler.utils.ProjectUtilities;
import org.openide.filesystems.FileObject;

public abstract class BaseEJBMarkingProvider
extends CustomMarker {
    private MethodMarker delegate = new MethodMarker();
    private static Logger LOGGER = Logger.getLogger(BaseEJBMarkingProvider.class.getName());

    public BaseEJBMarkingProvider(Project project, Mark mark) {
        super(project, mark);
        this.addEjbMethods();
    }

    public MarkMapping[] getMappings() {
        return this.delegate.getMappings();
    }

    public Mark[] getMarks() {
        return this.delegate.getMarks();
    }

    protected abstract boolean isValid(ExecutableElement var1);

    private void addEjbMethods() {
        ClasspathInfo classpathInfo = ProjectUtilities.getClasspathInfo((Project)this.getProject());
        final JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]);
        for (MetadataModel<EjbJarMetadata> metadataModel : this.listAllMetadata()) {
            try {
                metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, Void>(){

                    public Void run(EjbJarMetadata ejbJarMetadata) throws Exception {
                        Ejb[] ejbArray;
                        StringBuilder stringBuilder = new StringBuilder().append(ejbJarMetadata.getRoot().getVersion().toString()).append(" = ");
                        ejbJarMetadata.getRoot();
                        System.out.println(stringBuilder.append("3.0").toString());
                        for (final Ejb ejb : ejbArray = ejbJarMetadata.getRoot().getEnterpriseBeans().getEjbs()) {
                            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                                public void cancel() {
                                }

                                public void run(CompilationController compilationController) throws Exception {
                                    TypeElement typeElement = compilationController.getElements().getTypeElement(ejb.getEjbClass());
                                    BaseEJBMarkingProvider.this.addTypeMethods(BaseEJBMarkingProvider.this.delegate, typeElement, compilationController);
                                }
                            }, true);
                        }
                        return null;
                    }
                });
            }
            catch (MetadataModelException metadataModelException) {
                metadataModelException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private Set<MetadataModel<EjbJarMetadata>> listAllMetadata() {
        HashSet<MetadataModel<EjbJarMetadata>> hashSet = new HashSet<MetadataModel<EjbJarMetadata>>();
        HashSet<Project> hashSet2 = new HashSet<Project>();
        hashSet2.add(this.getProject());
        ProjectUtilities.fetchSubprojects((Project)this.getProject(), hashSet2);
        for (Project project : hashSet2) {
            EjbJarImplementation ejbJarImplementation = (EjbJarImplementation)project.getLookup().lookup(EjbJarImplementation.class);
            if (ejbJarImplementation == null) continue;
            hashSet.add((MetadataModel<EjbJarMetadata>)ejbJarImplementation.getMetadataModel());
        }
        return hashSet;
    }

    private void addTypeMethods(MethodMarker methodMarker, TypeElement typeElement, CompilationController compilationController) {
        if (methodMarker == null || typeElement == null || this.getMark() == null || compilationController == null) {
            return;
        }
        try {
            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                if (executableElement.getKind() != ElementKind.METHOD || executableElement.getModifiers().contains((Object)Modifier.ABSTRACT) || !this.isValid(executableElement)) continue;
                try {
                    methodMarker.addMethodMark(ElementUtilities.getBinaryName((TypeElement)typeElement), executableElement.getSimpleName().toString(), SourceUtils.getVMMethodSignature((ExecutableElement)executableElement, (CompilationInfo)compilationController), this.getMark());
                }
                catch (NullPointerException nullPointerException) {
                    nullPointerException.printStackTrace();
                }
            }
        }
        catch (IOException iOException) {
            LOGGER.throwing(BaseEJBMarkingProvider.class.getName(), "addTypeMethods", iOException);
        }
    }
}

