/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.LocalAsgnNode;
import org.jrubyparser.ast.MethodDefNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.EditRegions;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.PreviewableFix;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.hints.infrastructure.RubyAstRule;
import org.netbeans.modules.ruby.hints.infrastructure.RubyRuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.util.NbBundle;

public class NestedLocal
extends RubyAstRule {
    public boolean appliesTo(RuleContext context) {
        return true;
    }

    @Override
    public Set<NodeType> getKinds() {
        return Collections.singleton(NodeType.FORNODE);
    }

    public void cancel() {
    }

    public String getId() {
        return "Nested_Local";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(NestedLocal.class, (String)"NestedLocal");
    }

    public String getDescription() {
        return NbBundle.getMessage(NestedLocal.class, (String)"NestedLocalDesc");
    }

    @Override
    public void run(RubyRuleContext context, List<Hint> result) {
        Node node = context.node;
        AstPath path = context.path;
        ParserResult info = context.parserResult;
        if (node.getNodeType() == NodeType.FORNODE) {
            List list = node.childNodes();
            for (Node child : list) {
                if (!(child instanceof LocalAsgnNode)) continue;
                String name = ((INameNode)child).getName();
                Node method = AstUtilities.findLocalScope(null, (AstPath)path);
                if (method == null || !this.isUsed(method, name, child, new boolean[1])) continue;
                OffsetRange range = AstUtilities.getNameRange((Node)child);
                ArrayList<RenameVarFix> fixList = new ArrayList<RenameVarFix>(2);
                Node root = AstUtilities.getRoot((Parser.Result)info);
                AstPath childPath = new AstPath(root, child);
                fixList.add(new RenameVarFix(context, childPath, node, false));
                fixList.add(new RenameVarFix(context, childPath, node, true));
                String displayName = NbBundle.getMessage(NestedLocal.class, (String)"NestedLocalName", (Object)name);
                if ((range = LexUtilities.getLexerOffsets((Parser.Result)info, (OffsetRange)range)) == OffsetRange.NONE) continue;
                Hint desc = new Hint((Rule)this, displayName, RubyUtils.getFileObject((Parser.Result)info), range, fixList, 100);
                result.add(desc);
            }
        }
    }

    private boolean isUsed(Node node, String name, Node target, boolean[] done) {
        if (node == target) {
            done[0] = true;
            return false;
        }
        if ((node.getNodeType() == NodeType.LOCALVARNODE || node.getNodeType() == NodeType.LOCALASGNNODE) && name.equals(((INameNode)node).getName())) {
            return true;
        }
        List list = node.childNodes();
        for (Node child : list) {
            if (child.isInvisible()) continue;
            boolean found = this.isUsed(child, name, target, done);
            if (found) {
                return true;
            }
            if (!done[0]) continue;
            return false;
        }
        return false;
    }

    public boolean getDefaultEnabled() {
        return true;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    public boolean showInTasklist() {
        return true;
    }

    public JComponent getCustomizer(Preferences node) {
        return null;
    }

    private static class RenameVarFix
    implements PreviewableFix {
        private final RubyRuleContext context;
        private final AstPath path;
        private final Node target;
        private final boolean renameOuter;

        RenameVarFix(RubyRuleContext context, AstPath path, Node target, boolean renameOuter) {
            this.context = context;
            this.target = target;
            this.path = path;
            this.renameOuter = renameOuter;
        }

        public String getDescription() {
            if (this.renameOuter) {
                return NbBundle.getMessage(NestedLocal.class, (String)"ChangeOuter");
            }
            return NbBundle.getMessage(NestedLocal.class, (String)"ChangeInner");
        }

        public EditList getEditList() throws Exception {
            BaseDocument doc = this.context.doc;
            EditList edits = new EditList(doc);
            Set<OffsetRange> ranges = this.findRegionsToEdit();
            String oldName = ((INameNode)this.path.leaf()).getName();
            int oldLen = oldName.length();
            String newName = "new_name";
            for (OffsetRange range : ranges) {
                edits.replace(range.getStart(), oldLen, newName, false, 0);
            }
            return edits;
        }

        public void implement() throws Exception {
            Set<OffsetRange> ranges = this.findRegionsToEdit();
            int caretOffset = Integer.MAX_VALUE;
            for (OffsetRange range : ranges) {
                if (range.getStart() >= caretOffset) continue;
                caretOffset = range.getStart();
            }
            EditRegions.getInstance().edit(RubyUtils.getFileObject((Parser.Result)this.context.parserResult), ranges, caretOffset);
        }

        private void addNonBlockRefs(Node node, String name, Set<OffsetRange> ranges, boolean isParameter) {
            OffsetRange range;
            if ((node.getNodeType() == NodeType.LOCALASGNNODE || node.getNodeType() == NodeType.LOCALVARNODE) && name.equals(((INameNode)node).getName())) {
                range = AstUtilities.getNameRange((Node)node);
                if ((range = LexUtilities.getLexerOffsets((Parser.Result)this.context.parserResult, (OffsetRange)range)) != OffsetRange.NONE) {
                    ranges.add(range);
                }
            } else if (isParameter && node.getNodeType() == NodeType.ARGUMENTNODE && name.equals(((INameNode)node).getName())) {
                range = AstUtilities.getNameRange((Node)node);
                if ((range = LexUtilities.getLexerOffsets((Parser.Result)this.context.parserResult, (OffsetRange)range)) != OffsetRange.NONE) {
                    ranges.add(range);
                }
            } else if (node.getNodeType() == NodeType.ARGSNODE) {
                isParameter = true;
            }
            List list = node.childNodes();
            for (Node child : list) {
                if (child.isInvisible() || child instanceof MethodDefNode || child == this.target) continue;
                this.addNonBlockRefs(child, name, ranges, isParameter);
            }
        }

        private Set<OffsetRange> findRegionsToEdit() {
            HashSet<OffsetRange> ranges = new HashSet<OffsetRange>();
            assert (this.path.leaf() instanceof INameNode);
            String name = ((INameNode)this.path.leaf()).getName();
            if (this.renameOuter) {
                Node scope = AstUtilities.findLocalScope((Node)this.path.leaf(), (AstPath)this.path);
                this.addNonBlockRefs(scope, name, ranges, false);
            } else {
                this.addNonBlockRefs(this.target, name, ranges, false);
            }
            return ranges;
        }

        public boolean isSafe() {
            return false;
        }

        public boolean isInteractive() {
            return true;
        }

        public boolean canPreview() {
            return true;
        }
    }
}

