/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.management.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.netbeans.modules.dlight.management.api.DLightManager;
import org.netbeans.modules.dlight.management.api.DLightSession;
import org.netbeans.modules.dlight.management.api.DLightSessionListener;
import org.netbeans.modules.dlight.management.api.SessionStateListener;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.openide.util.RequestProcessor;

public class StopDLightAction
extends AbstractAction
implements DLightSessionListener,
SessionStateListener {
    public StopDLightAction() {
        super("Stop D-Light");
        this.putValue("iconBase", "org/netbeans/modules/dlight/management/resources/stop24.png");
        this.putValue("SmallIcon", "org/netbeans/modules/dlight/management/resources/stop.png");
        DLightManager.getDefault().addDLightSessionListener(this);
    }

    @Override
    public boolean isEnabled() {
        return DLightManager.getDefault().getActiveSession() != null && (DLightManager.getDefault().getActiveSession().getState() == DLightSession.SessionState.RUNNING || DLightManager.getDefault().getActiveSession().getState() == DLightSession.SessionState.STARTING);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                DLightLogger.instance.info("StopDLightAction performed @ " + System.currentTimeMillis());
                DLightManager.getDefault().stopActiveSession();
            }
        });
    }

    @Override
    public void activeSessionChanged(DLightSession oldSession, DLightSession newSession) {
        if (oldSession != null) {
            oldSession.removeSessionStateListener(this);
        }
        if (newSession != null) {
            newSession.addSessionStateListener(this);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StopDLightAction.this.setEnabled(StopDLightAction.this.isEnabled());
            }
        });
    }

    @Override
    public void sessionStateChanged(DLightSession session, DLightSession.SessionState oldState, DLightSession.SessionState newState) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StopDLightAction.this.setEnabled(StopDLightAction.this.isEnabled());
            }
        });
    }

    @Override
    public void sessionAdded(DLightSession newSession) {
        if (newSession != null) {
            newSession.addSessionStateListener(this);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StopDLightAction.this.setEnabled(StopDLightAction.this.isEnabled());
            }
        });
    }

    @Override
    public void sessionRemoved(DLightSession removedSession) {
        if (removedSession != null) {
            removedSession.removeSessionStateListener(this);
        }
    }
}

