/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.servletunit;

import com.meterware.servletunit.ServletUnitHttpSession;
import com.meterware.servletunit.SessionListenerDispatcher;
import java.util.Hashtable;
import java.util.Set;
import javax.servlet.ServletContext;

class ServletUnitContext {
    private SessionListenerDispatcher _listenerDispatcher;
    private ServletContext _servletContext;
    private Hashtable _sessions = new Hashtable();
    private String _contextPath = null;

    ServletUnitContext(String contextPath, ServletContext servletContext, SessionListenerDispatcher dispatcher) {
        this._servletContext = servletContext;
        this._contextPath = contextPath != null ? contextPath : "";
        this._listenerDispatcher = dispatcher;
    }

    Set getSessionIDs() {
        return this._sessions.keySet();
    }

    ServletUnitHttpSession getValidSession(String sessionId, ServletUnitHttpSession session, boolean create) {
        if (session == null && sessionId != null) {
            session = this.getSession(sessionId);
        }
        if (session != null && session.isInvalid()) {
            session = null;
        }
        if (session == null && create) {
            session = this.newSession();
        }
        return session;
    }

    ServletUnitHttpSession getSession(String id) {
        return (ServletUnitHttpSession)this._sessions.get(id);
    }

    ServletUnitHttpSession newSession() {
        ServletUnitHttpSession result = new ServletUnitHttpSession(this._servletContext, this._listenerDispatcher);
        this._sessions.put(result.getId(), result);
        this._listenerDispatcher.sendSessionCreated(result);
        return result;
    }

    String getContextPath() {
        return this._contextPath;
    }
}

