/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model;

import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.PyThread;
import org.python.pydev.debug.model.remote.RemoteDebugger;
import org.python.pydev.plugin.PydevPlugin;

public class PyDebugTarget
extends AbstractDebugTarget {
    private IProcess process;

    public PyDebugTarget(ILaunch launch, IProcess process, IPath[] file, RemoteDebugger debugger) {
        this.launch = launch;
        this.process = process;
        this.file = file;
        this.debugger = debugger;
        this.threads = new PyThread[0];
        launch.addDebugTarget((IDebugTarget)this);
        debugger.addTarget(this);
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        breakpointManager.addBreakpointListener((IBreakpointListener)this);
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchListener)this);
    }

    public void launchRemoved(ILaunch launch) {
        if (launch == this.launch) {
            IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
            breakpointManager.removeBreakpointListener((IBreakpointListener)this);
            this.debugger.dispose();
            this.debugger = null;
        }
    }

    public IProcess getProcess() {
        return this.process;
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        if (this.process == null) {
            return true;
        }
        return this.process.isTerminated();
    }

    public void terminate() {
        if (this.process != null) {
            try {
                this.process.terminate();
            }
            catch (DebugException e) {
                PydevPlugin.log((Throwable)e);
            }
            this.process = null;
        }
        super.terminate();
    }
}

