/*
 * Decompiled with CFR 0.152.
 */
package tr.prefs.projects;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.openide.util.NbBundle;
import tr.prefs.projects.ProjectsOptionsPanelController;
import tr.prefs.projects.ProjectsPrefs;

final class ProjectsOptionsPanel
extends JPanel {
    private final ProjectsOptionsPanelController controller;
    private Vector<ProjectsPrefs.ActionState> states;
    private JComboBox actionStatesCombo;
    private JCheckBox autoSeqCheckBox;
    private JCheckBox dueDateCheckBox;
    private JCheckBox createDateCheckBox;
    private JLabel actionStatesLabel;
    private JCheckBox startDateCheckBox;

    ProjectsOptionsPanel(ProjectsOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        this.add((Component)this.getView(), "Center");
    }

    private JComponent getView() {
        this.autoSeqCheckBox = new JCheckBox(this.getMsg("Pref_AutoSequence"));
        this.autoSeqCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectsOptionsPanel.this.controller.changed();
            }
        });
        this.startDateCheckBox = new JCheckBox(this.getMsg("Pref_StartDate"));
        this.startDateCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectsOptionsPanel.this.controller.changed();
            }
        });
        this.dueDateCheckBox = new JCheckBox(this.getMsg("Pref_DueDate"));
        this.dueDateCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectsOptionsPanel.this.controller.changed();
            }
        });
        this.createDateCheckBox = new JCheckBox(this.getMsg("CTL_editCreateDate"));
        this.createDateCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectsOptionsPanel.this.controller.changed();
            }
        });
        this.actionStatesLabel = new JLabel(this.getMsg("DefaultActionState"));
        this.states = new Vector();
        this.states.add(ProjectsPrefs.ActionState.INACTIVE);
        this.states.add(ProjectsPrefs.ActionState.DOASAP);
        this.states.add(ProjectsPrefs.ActionState.SCHEDULED);
        this.states.add(ProjectsPrefs.ActionState.DELEGATED);
        this.actionStatesCombo = new JComboBox<ProjectsPrefs.ActionState>(new DefaultComboBoxModel<ProjectsPrefs.ActionState>(this.states));
        this.actionStatesCombo.setMaximumRowCount(this.states.size());
        JPanel panel = new JPanel((LayoutManager)new MigLayout("", "0[]2[]0", "0[]2[]2[]2[]2[]0"));
        panel.add((Component)this.autoSeqCheckBox, "align left, span, wrap");
        panel.add((Component)this.startDateCheckBox, "align left, span, wrap");
        panel.add((Component)this.dueDateCheckBox, "align left, span, wrap");
        panel.add((Component)this.createDateCheckBox, "align left, span, wrap");
        panel.add((Component)this.actionStatesLabel, "align left, gapleft 8");
        panel.add((Component)this.actionStatesCombo, "align left, wrap");
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        return scrollPane;
    }

    private String getMsg(String key) {
        return NbBundle.getMessage(this.getClass(), (String)key);
    }

    void load() {
        this.autoSeqCheckBox.setSelected(ProjectsPrefs.isSequencing());
        this.startDateCheckBox.setSelected(ProjectsPrefs.isIncludeStartDate());
        this.dueDateCheckBox.setSelected(ProjectsPrefs.isIncludeDueDate());
        this.actionStatesCombo.setSelectedItem((Object)ProjectsPrefs.getNewActionState());
        this.createDateCheckBox.setSelected(ProjectsPrefs.isEditCreateDate());
    }

    void store() {
        ProjectsPrefs.setSequencing(this.autoSeqCheckBox.isSelected());
        ProjectsPrefs.setIncludeStartDate(this.startDateCheckBox.isSelected());
        ProjectsPrefs.setIncludeDueDate(this.dueDateCheckBox.isSelected());
        ProjectsPrefs.setNewActionState((ProjectsPrefs.ActionState)((Object)this.actionStatesCombo.getSelectedItem()));
        ProjectsPrefs.setEditCreateDate(this.createDateCheckBox.isSelected());
    }

    boolean valid() {
        return true;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }
}

