/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.ConsThread;
import jalview.DrawableSequence;
import jalview.FormatAdapter;
import jalview.FormatProperties;
import jalview.Popup;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.io.File;

public class FilePopup
extends Popup {
    TextField tf = new TextField(40);
    Label tfLabel = new Label("Filename : ");
    Button b;
    Label format = new Label("Alignment format");
    Choice f = new Choice();

    public FilePopup(Frame frame, String string) {
        super(frame, string);
        int n = 0;
        while (n < FormatProperties.formats.size()) {
            this.f.addItem((String)FormatProperties.formats.elementAt(n));
            ++n;
        }
        this.b = new Button("Browse..");
        this.gbc.fill = 0;
        this.gbc.insets = new Insets(20, 20, 20, 20);
        this.add(this.tfLabel, this.gb, this.gbc, 0, 0, 1, 1);
        this.add(this.tf, this.gb, this.gbc, 1, 0, 4, 1);
        this.add(this.format, this.gb, this.gbc, 0, 1, 1, 1);
        this.add(this.f, this.gb, this.gbc, 1, 1, 1, 1);
        this.add(this.b, this.gb, this.gbc, 5, 0, 1, 1);
        this.gbc.fill = 2;
        this.add(this.status, this.gb, this.gbc, 0, 2, 1, 1);
        this.gbc.fill = 0;
        this.add(this.apply, this.gb, this.gbc, 0, 3, 1, 1);
        this.add(this.close, this.gb, this.gbc, 1, 3, 1, 1);
        this.pack();
        this.show();
    }

    public boolean handleEvent(Event event) {
        if (event.target == this.apply && event.id == 1001) {
            this.status.setText("Reading file...");
            this.status.validate();
            String string = this.tf.getText();
            File file = new File(string);
            if (file.isFile()) {
                DrawableSequence[] drawableSequenceArray = null;
                drawableSequenceArray = FormatAdapter.toDrawableSequence(FormatAdapter.read(string, "File", this.f.getSelectedItem()));
                if (drawableSequenceArray != null) {
                    this.status.setText("Creating new alignment window...");
                    this.status.validate();
                    AlignFrame alignFrame = new AlignFrame(this.parent.getParent(), drawableSequenceArray);
                    if (alignFrame.ap.seqPanel.align.size() > 0) {
                        alignFrame.resize(700, 500);
                        alignFrame.show();
                        ConsThread consThread = new ConsThread(alignFrame);
                        consThread.start();
                    }
                    ((Component)this).hide();
                    this.dispose();
                } else {
                    this.status.setText("ERROR: No sequences found. Check format.");
                }
            } else {
                this.status.setText("ERROR: File not found or wrong format");
            }
            return true;
        }
        if (event.target == this.b && event.id == 1001) {
            FileDialog fileDialog = new FileDialog(this.parent, "Open alignment file", 0);
            fileDialog.show();
            String string = "";
            String string2 = "";
            if (fileDialog.getDirectory() != null) {
                string = fileDialog.getDirectory();
            }
            if (fileDialog.getFile() != null) {
                string2 = fileDialog.getFile();
            }
            ((TextComponent)this.tf).setText(String.valueOf(string) + string2);
            return true;
        }
        return super.handleEvent(event);
    }
}

