# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Author: Florian Boucault <florian@fluendo.com>

from elisa.core.component import Component
from elisa.core.utils import defer


class ServiceProvider(Component):
    """
    Service providers run during all the lifetime of the application.

    They are started first in the components initialization sequence, so they
    should listen to the message bus for the 'components_initialized' message
    before communication with other components.
    """

    def start(self):
        """
        Start the service.

        return: a deferred fired when the service is started
        rtype:  L{elisa.core.utils.defer.Deferred}
        """
        return defer.succeed(None)

    def stop(self):
        """
        Stop the service.

        return: a deferred fired when the service is started
        rtype:  L{elisa.core.utils.defer.Deferred}
        """
        return defer.succeed(None)
