/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.reporter;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.view.BugTreeView;
import edu.umd.cs.findbugs.AppVersion;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class MarkerReporter
implements IWorkspaceRunnable {
    BugInstance bug;
    IResource resource;
    int startLine;
    BugCollection collection;
    IProject project;
    static final boolean EXPERIMENTAL_BUGS = false;

    public MarkerReporter(BugInstance bug, IResource resource, int startLine, BugCollection theCollection, IProject project) {
        this.startLine = startLine;
        this.bug = bug;
        this.resource = resource;
        this.collection = theCollection;
        this.project = project;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        BugTreeView theView;
        String markerName;
        int priority = this.bug.getPriority();
        switch (priority) {
            case 1: {
                markerName = "edu.umd.cs.findbugs.plugin.eclipse.findbugsMarkerHigh";
                break;
            }
            case 2: {
                markerName = "edu.umd.cs.findbugs.plugin.eclipse.findbugsMarkerNormal";
                break;
            }
            case 3: {
                markerName = "edu.umd.cs.findbugs.plugin.eclipse.findbugsMarkerLow";
                break;
            }
            case 4: {
                return;
            }
            case 5: {
                FindbugsPlugin.getDefault().logError("Bug with ignore priority ");
                return;
            }
            default: {
                FindbugsPlugin.getDefault().logError("Bug with unknown priority " + priority);
                return;
            }
        }
        IMarker marker = this.resource.createMarker(markerName);
        marker.setAttribute("lineNumber", this.startLine);
        marker.setAttribute("BUG_LINE_NUMBER", this.startLine);
        marker.setAttribute("BUGTYPE", (Object)this.bug.getType());
        long seqNum = this.bug.getFirstVersion();
        if (seqNum == 0L) {
            marker.setAttribute("FIRST_VERSION", (Object)Long.toString(-1L));
        } else {
            AppVersion theVersion = this.collection.getAppVersionFromSequenceNumber(seqNum);
            if (theVersion == null) {
                marker.setAttribute("FIRST_VERSION", (Object)("Cannot find AppVersion: seqnum=" + seqNum + "; collection seqnum=" + this.collection.getSequenceNumber()));
            } else {
                marker.setAttribute("FIRST_VERSION", (Object)Long.toString(theVersion.getTimestamp()));
            }
        }
        marker.setAttribute("message", (Object)this.bug.getMessageWithPriorityTypeAbbreviation());
        marker.setAttribute("severity", 1);
        marker.setAttribute("PRIORITY_TYPE", (Object)this.bug.getPriorityTypeString());
        if (this.bug.getPriority() == 1) {
            marker.setAttribute("priority", 2);
        } else if (this.bug.getPriority() == 2) {
            marker.setAttribute("priority", 1);
        } else {
            marker.setAttribute("priority", 0);
        }
        String uniqueId = this.bug.getInstanceHash();
        if (uniqueId != null) {
            marker.setAttribute("FINDBUGS_UNIQUE_ID", (Object)uniqueId);
        }
        if ((theView = BugTreeView.getBugTreeView()) != null) {
            theView.addMarker(this.project, marker);
        }
    }
}

