/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui.preferences;

import java.util.ArrayList;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiMessages;
import org.rubypeople.rdt.internal.debug.ui.preferences.EditInterpreterDialog;
import org.rubypeople.rdt.internal.debug.ui.preferences.RubyInterpreterContentProvider;
import org.rubypeople.rdt.internal.debug.ui.preferences.RubyInterpreterLabelProvider;
import org.rubypeople.rdt.internal.launching.RubyInterpreter;
import org.rubypeople.rdt.internal.launching.RubyRuntime;

public class RubyInterpreterPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected CheckboxTableViewer tableViewer;
    protected Button addButton;
    protected Button editButton;
    protected Button removeButton;

    public void init(IWorkbench iWorkbench) {
    }

    protected Control createContents(Composite composite) {
        this.noDefaultAndApplyButton();
        Composite composite2 = this.createPageRoot(composite);
        Table table = this.createInstalledInterpretersTable(composite2);
        this.createInstalledInterpretersTableViewer(table);
        this.createButtonGroup(composite2);
        this.tableViewer.setInput((Object)RubyRuntime.getDefault().getInstalledInterpreters());
        RubyInterpreter rubyInterpreter = RubyRuntime.getDefault().getSelectedInterpreter();
        if (rubyInterpreter != null) {
            this.tableViewer.setChecked((Object)rubyInterpreter, true);
        }
        this.enableButtons();
        return composite2;
    }

    protected void createButtonGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(2));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        this.addButton = new Button(composite2, 8);
        this.addButton.setLayoutData((Object)new GridData(768));
        this.addButton.setText(RdtDebugUiMessages.getString("RubyInterpreterPreferencePage.addButton.label"));
        this.addButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                RubyInterpreterPreferencePage.this.addInterpreter();
            }
        });
        this.editButton = new Button(composite2, 8);
        this.editButton.setLayoutData((Object)new GridData(768));
        this.editButton.setText(RdtDebugUiMessages.getString("RubyInterpreterPreferencePage.editButton.label"));
        this.editButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                RubyInterpreterPreferencePage.this.editInterpreter();
            }
        });
        this.removeButton = new Button(composite2, 8);
        this.removeButton.setLayoutData((Object)new GridData(768));
        this.removeButton.setText(RdtDebugUiMessages.getString("RubyInterpreterPreferencePage.removeButton.label"));
        this.removeButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                RubyInterpreterPreferencePage.this.removeInterpreter();
            }
        });
    }

    protected void createInstalledInterpretersTableViewer(Table table) {
        this.tableViewer = new CheckboxTableViewer(table);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new RubyInterpreterLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new RubyInterpreterContentProvider());
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                RubyInterpreterPreferencePage.this.enableButtons();
            }
        });
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                RubyInterpreterPreferencePage.this.updateSelectedInterpreter(checkStateChangedEvent.getElement());
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                RubyInterpreterPreferencePage.this.editInterpreter();
            }
        });
    }

    protected Table createInstalledInterpretersTable(Composite composite) {
        Table table = new Table(composite, 67616);
        GridData gridData = new GridData(1808);
        table.setLayoutData((Object)gridData);
        table.setHeaderVisible(true);
        table.setLinesVisible(false);
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setText(RdtDebugUiMessages.getString("RubyInterpreterPreferencePage.rubyInterpreterTable.interpreterName"));
        tableColumn.setWidth(125);
        tableColumn = new TableColumn(table, 0);
        tableColumn.setText(RdtDebugUiMessages.getString("RubyInterpreterPreferencePage.rubyInterpreterTable.interpreterPath"));
        tableColumn.setWidth(350);
        return table;
    }

    protected Composite createPageRoot(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        return composite2;
    }

    protected void addInterpreter() {
        RubyInterpreter rubyInterpreter = new RubyInterpreter(null, null);
        EditInterpreterDialog editInterpreterDialog = new EditInterpreterDialog(this.getShell(), RdtDebugUiMessages.getString("RubyInterpreterPreferencePage.EditInterpreterDialog.addInterpreter.title"));
        editInterpreterDialog.create();
        editInterpreterDialog.setInterpreterToEdit(rubyInterpreter);
        if (editInterpreterDialog.open() == 0) {
            this.tableViewer.add((Object)rubyInterpreter);
            Object[] objectArray = this.tableViewer.getCheckedElements();
            if (objectArray == null || objectArray.length == 0) {
                this.tableViewer.setChecked((Object)rubyInterpreter, true);
            }
        }
    }

    protected void removeInterpreter() {
        this.tableViewer.remove((Object)this.getSelectedInterpreter());
    }

    protected void enableButtons() {
        if (this.getSelectedInterpreter() != null) {
            this.editButton.setEnabled(true);
            this.removeButton.setEnabled(true);
        } else {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
    }

    protected void updateSelectedInterpreter(Object object) {
        Object[] objectArray = this.tableViewer.getCheckedElements();
        int n = 0;
        while (n < objectArray.length) {
            this.tableViewer.setChecked(objectArray[n], false);
            ++n;
        }
        this.tableViewer.setChecked(object, true);
    }

    protected void editInterpreter() {
        EditInterpreterDialog editInterpreterDialog = new EditInterpreterDialog(this.getShell(), RdtDebugUiMessages.getString("RubyInterpreterPreferencePage.EditInterpreterDialog.editInterpreter.title"));
        editInterpreterDialog.create();
        RubyInterpreter rubyInterpreter = this.getSelectedInterpreter();
        editInterpreterDialog.setInterpreterToEdit(rubyInterpreter);
        if (editInterpreterDialog.open() == 0) {
            this.tableViewer.update((Object)rubyInterpreter, null);
        }
    }

    protected RubyInterpreter getSelectedInterpreter() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.tableViewer.getSelection();
        return (RubyInterpreter)iStructuredSelection.getFirstElement();
    }

    public boolean performOk() {
        TableItem[] tableItemArray = this.tableViewer.getTable().getItems();
        ArrayList<Object> arrayList = new ArrayList<Object>(tableItemArray.length);
        int n = 0;
        while (n < tableItemArray.length) {
            arrayList.add(tableItemArray[n].getData());
            ++n;
        }
        RubyRuntime.getDefault().setInstalledInterpreters(arrayList);
        Object[] objectArray = this.tableViewer.getCheckedElements();
        if (objectArray.length > 0) {
            RubyRuntime.getDefault().setSelectedInterpreter((RubyInterpreter)objectArray[0]);
        }
        return super.performOk();
    }
}

