/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.rubypeople.rdt.core.IElementChangedListener;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyModel;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.internal.core.BatchOperation;
import org.rubypeople.rdt.internal.core.DefaultWorkingCopyOwner;
import org.rubypeople.rdt.internal.core.RubyModel;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.RubyProject;
import org.rubypeople.rdt.internal.core.RubyScript;
import org.rubypeople.rdt.internal.core.SymbolIndexResourceChangeListener;
import org.rubypeople.rdt.internal.core.builder.IndexUpdater;
import org.rubypeople.rdt.internal.core.builder.MassIndexUpdaterJob;
import org.rubypeople.rdt.internal.core.builder.RubyBuilder;
import org.rubypeople.rdt.internal.core.parser.RubyParser;
import org.rubypeople.rdt.internal.core.symbols.ISymbolFinder;
import org.rubypeople.rdt.internal.core.symbols.SymbolIndex;
import org.rubypeople.rdt.internal.core.util.Util;

public class RubyCore
extends Plugin {
    private static RubyCore RUBY_CORE_PLUGIN = null;
    public static final String PLUGIN_ID = "org.rubypeople.rdt.core";
    private static final String RUBY_PARSER_DEBUG_OPTION = "org.rubypeople.rdt.core/rubyparser";
    private static final String MODEL_MANAGER_VERBOSE_OPTION = "org.rubypeople.rdt.core/modelmanager";
    private static final String SYMBOL_INDEX_VERBOSE_OPTION = "org.rubypeople.rdt.core/symbolIndex";
    private static final String BUILDER_VERBOSE_OPTION = "org.rubypeople.rdt.core/rubyBuilder";
    public static final String NATURE_ID = "org.rubypeople.rdt.core.rubynature";
    public static final IEclipsePreferences[] preferencesLookup = new IEclipsePreferences[2];
    static final int PREF_INSTANCE = 0;
    static final int PREF_DEFAULT = 1;
    public static final String DEFAULT_TASK_TAGS = "TODO,FIXME,XXX";
    public static final String BUILDER_ID = "org.rubypeople.rdt.core.rubybuilder";
    public static final String DEFAULT_TASK_PRIORITIES = "NORMAL,HIGH,NORMAL";
    public static final String COMPILER_TASK_PRIORITIES = "org.rubypeople.rdt.core.compiler.taskPriorities";
    public static final String COMPILER_TASK_PRIORITY_HIGH = "HIGH";
    public static final String COMPILER_TASK_PRIORITY_LOW = "LOW";
    public static final String COMPILER_TASK_PRIORITY_NORMAL = "NORMAL";
    public static final String COMPILER_TASK_TAGS = "org.rubypeople.rdt.core.compiler.taskTags";
    public static final String COMPILER_TASK_CASE_SENSITIVE = "org.rubypeople.rdt.core.compiler.taskCaseSensitive";
    public static final String ENABLED = "enabled";
    public static final String DISABLED = "disabled";
    public static final String TAB = "tab";
    public static final String SPACE = "space";
    public static final String CORE_ENCODING = "org.rubypeople.rdt.core.encoding";
    public static final String INSERT = "insert";
    public static final String DO_NOT_INSERT = "do not insert";
    public static final String RUBY_SOURCE_CONTENT_TYPE = "org.rubypeople.rdt.core.rubySource";
    private SymbolIndex symbolIndex;
    private ISymbolFinder symbolFinder;

    public RubyCore() {
        RUBY_CORE_PLUGIN = this;
        this.symbolIndex = new SymbolIndex();
        this.symbolFinder = this.symbolIndex;
    }

    public static RubyCore getPlugin() {
        return RUBY_CORE_PLUGIN;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        RubyModelManager.getRubyModelManager().startup();
        RubyParser.setDebugging(this.isDebugOptionTrue(RUBY_PARSER_DEBUG_OPTION));
        RubyModelManager.setVerbose(this.isDebugOptionTrue(MODEL_MANAGER_VERBOSE_OPTION));
        SymbolIndex.setVerbose(this.isDebugOptionTrue(SYMBOL_INDEX_VERBOSE_OPTION));
        RubyBuilder.setVerbose(this.isDebugOptionTrue(BUILDER_VERBOSE_OPTION));
        SymbolIndexResourceChangeListener.register(this.symbolIndex);
        IndexUpdater indexUpdater = new IndexUpdater(this.symbolIndex);
        List<IProject> list = Arrays.asList(RubyCore.getRubyProjects());
        MassIndexUpdaterJob massIndexUpdaterJob = new MassIndexUpdaterJob(indexUpdater, list);
        massIndexUpdaterJob.schedule();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop(BundleContext bundleContext) throws Exception {
        try {
            RubyModelManager.getRubyModelManager().shutdown();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            super.stop(bundleContext);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        super.stop(bundleContext);
    }

    private boolean isDebugOptionTrue(String string) {
        String string2 = Platform.getDebugOption((String)string);
        return string2 == null ? false : string2.equalsIgnoreCase("true");
    }

    public static boolean upgradeOldProjects() throws CoreException {
        boolean bl = false;
        IProject[] iProjectArray = RubyCore.getRubyProjects();
        int n = 0;
        while (n < iProjectArray.length) {
            if (RubyCore.upgradeOldProject(iProjectArray[n])) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public static boolean upgradeOldProject(IProject iProject) throws CoreException {
        RubyModelManager rubyModelManager = RubyModelManager.getRubyModelManager();
        RubyModel rubyModel = rubyModelManager.getRubyModel();
        IRubyProject iRubyProject = rubyModel.getRubyProject((IResource)iProject);
        if (iRubyProject != null) {
            return iRubyProject.upgrade();
        }
        return false;
    }

    public static void trace(String string) {
        if (RubyCore.getPlugin().isDebugging()) {
            System.out.println(string);
        }
    }

    public static void log(Exception exception) {
        String string = exception.getMessage();
        if (string == null) {
            string = "";
        }
        RubyCore.log(4, string, exception);
    }

    public static void log(String string) {
        RubyCore.log(1, string);
    }

    public static void log(int n, String string) {
        RubyCore.log(n, string, null);
    }

    public static void log(int n, String string, Throwable throwable) {
        RubyCore.getPlugin().getLog().log((IStatus)new Status(n, PLUGIN_ID, 0, string, throwable));
        System.out.println(string);
        if (throwable != null) {
            throwable.printStackTrace();
        }
    }

    public static String getOSDirectory(Plugin plugin) {
        Bundle bundle = plugin.getBundle();
        String string = bundle.getLocation();
        int n = string.indexOf(64);
        if (n == -1) {
            throw new RuntimeException("Location of launching bundle does not contain @: " + string);
        }
        String string2 = string.substring(n + 1);
        File file = new File(string2);
        if (!file.exists()) {
            File file2;
            String string3 = System.getProperty("osgi.install.area");
            if (string3.startsWith("file:")) {
                string3 = string3.substring("file:".length());
            }
            if (!(file = new File(file2 = new File(new Path(string3).toOSString()), string2)).exists()) {
                throw new RuntimeException("Unable to find (" + file + ") directory for " + plugin.getClass());
            }
        }
        return String.valueOf(file.getAbsolutePath()) + "/";
    }

    public static IProject[] getRubyProjects() {
        ArrayList<IProject> arrayList = new ArrayList<IProject>();
        IProject[] iProjectArray = RubyCore.getWorkspace().getRoot().getProjects();
        int n = 0;
        while (n < iProjectArray.length) {
            IProject iProject = iProjectArray[n];
            if (RubyCore.isRubyProject(iProject)) {
                arrayList.add(iProject);
            }
            ++n;
        }
        IProject[] iProjectArray2 = new IProject[arrayList.size()];
        return arrayList.toArray(iProjectArray2);
    }

    public static boolean isRubyProject(IProject iProject) {
        try {
            return iProject.hasNature(NATURE_ID);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static IRubyScript create(IFile iFile) {
        return RubyCore.create(iFile, null);
    }

    public static IRubyScript create(IFile iFile, IRubyProject iRubyProject) {
        if (iRubyProject == null) {
            iRubyProject = RubyCore.create(iFile.getProject());
        }
        if (RubyCore.isRubyLikeFileName(iFile.getName())) {
            return new RubyScript((RubyProject)iRubyProject, iFile, iFile.getName(), DefaultWorkingCopyOwner.PRIMARY);
        }
        return null;
    }

    public static IRubyProject create(IProject iProject) {
        if (iProject == null) {
            return null;
        }
        RubyModel rubyModel = RubyModelManager.getRubyModelManager().getRubyModel();
        return rubyModel.getRubyProject((IResource)iProject);
    }

    public static void addRubyNature(IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        if (!iProject.hasNature(NATURE_ID)) {
            IProjectDescription iProjectDescription = iProject.getDescription();
            String[] stringArray = iProjectDescription.getNatureIds();
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray.length] = NATURE_ID;
            iProjectDescription.setNatureIds(stringArray2);
            iProject.setDescription(iProjectDescription, iProgressMonitor);
        }
    }

    public static IRubyElement create(IResource iResource) {
        return RubyModelManager.create(iResource, null);
    }

    public static IRubyModel create(IWorkspaceRoot iWorkspaceRoot) {
        if (iWorkspaceRoot == null) {
            return null;
        }
        return RubyModelManager.getRubyModelManager().getRubyModel();
    }

    public static void run(IWorkspaceRunnable iWorkspaceRunnable, ISchedulingRule iSchedulingRule, IProgressMonitor iProgressMonitor) throws CoreException {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        if (iWorkspace.isTreeLocked()) {
            new BatchOperation(iWorkspaceRunnable).run(iProgressMonitor);
        } else {
            iWorkspace.run((IWorkspaceRunnable)new BatchOperation(iWorkspaceRunnable), iSchedulingRule, 1, iProgressMonitor);
        }
    }

    public SymbolIndex getSymbolIndex() {
        return this.symbolIndex;
    }

    public ISymbolFinder getSymbolFinder() {
        return this.symbolFinder;
    }

    public void setSymbolFinder(ISymbolFinder iSymbolFinder) {
        this.symbolFinder = iSymbolFinder;
    }

    public static String getOption(String string) {
        return RubyModelManager.getRubyModelManager().getOption(string);
    }

    public static String getEncoding() {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        if (iWorkspace != null) {
            try {
                return iWorkspace.getRoot().getDefaultCharset();
            }
            catch (CoreException coreException) {}
        }
        return ResourcesPlugin.getEncoding();
    }

    public static Hashtable getOptions() {
        return RubyModelManager.getRubyModelManager().getOptions();
    }

    public static void addElementChangedListener(IElementChangedListener iElementChangedListener) {
        RubyCore.addElementChangedListener(iElementChangedListener, 5);
    }

    public static void addElementChangedListener(IElementChangedListener iElementChangedListener, int n) {
        RubyModelManager.getRubyModelManager().deltaState.addElementChangedListener(iElementChangedListener, n);
    }

    public static void removeElementChangedListener(IElementChangedListener iElementChangedListener) {
        RubyModelManager.getRubyModelManager().deltaState.removeElementChangedListener(iElementChangedListener);
    }

    public static RubyCore getRubyCore() {
        return RubyCore.getPlugin();
    }

    public static boolean isRubyLikeFileName(String string) {
        return Util.isRubyLikeFileName(string);
    }
}

